//
//  WebViewController.m
//  红
//
//  Created by 焦钟培 on 16/5/9.
//  Copyright © 2016年 焦钟培. All rights reserved.
//

#import "WebViewController.h"
#import "AFNetworking.h"
#import "ApplicationStatusViewController.h"

@interface WebViewController ()<UIWebViewDelegate>
@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;
@property (nonatomic) NSInteger number;
@end

@implementation WebViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    // Do any additional setup after loading the view.
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.text = @"快速通道";
    navL.textAlignment = NSTextAlignmentCenter;
    navL.font = [UIFont systemFontOfSize:16];
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@"nav"] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleBlackTranslucent;
    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    UIWebView *web = [[UIWebView alloc] initWithFrame:CGRectMake(0, 0, KWidth, KHeight)];
    web.delegate = self;
    NSURL *url = [NSURL URLWithString:_payUrl];
    NSURLRequest *request = [NSURLRequest requestWithURL:url];
    [web loadRequest:request];
    [self.view addSubview:web];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    [self.navigationController.navigationBar setTintColor:[Comment getColor:@"4999F5"]];
}

- (BOOL)webView: (UIWebView *)webView shouldStartLoadWithRequest:(NSURLRequest *)request navigationType:(UIWebViewNavigationType)navigationType{
    NSString *requestString = [[[request URL] absoluteString] stringByReplacingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
    _number++;
    NSLog(@"UIWebView console: %@", requestString);
    if (_number == 3) {
        [self createrAlert:@"账单已支付！"];
    }
//    if ([requestString hasPrefix:@"ios-log:"]) {
//        NSString* logString = [[requestString componentsSeparatedByString:@":#iOS#"] objectAtIndex:1];
//        NSLog(@"UIWebView console: %@", logString);
//        return NO;
//    }
    return YES;
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (void)createrAlert: (NSString *)titil {
    UIView *view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, KWidth, KHeight)];
    view.backgroundColor = [UIColor whiteColor];
    [self.view addSubview:view];
    UIApplication *application = [UIApplication sharedApplication];
    UIWindow *window = [application.windows objectAtIndex:0];
    UIView *backView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, KWidth, KHeight)];
    backView.backgroundColor = [UIColor grayColor];
    backView.alpha = 0.6;
    backView.tag = 1;
    [window addSubview:backView];
    
    UIView *backWView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 300, 180)];
    backWView.center = CGPointMake(KWidth/2, KHeight/2);
    backWView.backgroundColor = [UIColor whiteColor];
    backWView.tag = 2;
    [window addSubview:backWView];
    
    UILabel *lable = [[UILabel alloc] initWithFrame:CGRectMake(0, 20, 300, 60)];
    lable.font = [UIFont systemFontOfSize:22];
    lable.backgroundColor = [UIColor groupTableViewBackgroundColor];
    lable.textAlignment = NSTextAlignmentCenter;
    lable.text = titil;
    [backWView addSubview:lable];
    
    UIButton *button = [[UIButton alloc] initWithFrame:CGRectMake(50, 100, 200, 40)];
    button.backgroundColor = [Comment getColor:@"489604"];
    [button setTitle:@"跳转支付结果" forState:UIControlStateNormal];
    button.layer.masksToBounds = YES;
    button.layer.cornerRadius = 2;
    [button setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [button addTarget:self action:@selector(pushResultController) forControlEvents:UIControlEventTouchUpInside];
    [backWView addSubview:button];
}
- (void)pushResultController {
    UIApplication *application = [UIApplication sharedApplication];
    UIWindow *window = [application.windows objectAtIndex:0];
    for (UIView * view in window.subviews) {
        if (view.tag == 1 || view.tag == 2) {
            [view removeFromSuperview];
        }
    }
//    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
//    ApplicationStatusViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"ApplicationStatusViewController"];
//    [self.navigationController pushViewController:dev animated:YES];

    [self startRequest];
}
- (void)startRequest {
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    NSString *userId = [[NSUserDefaults standardUserDefaults] objectForKey:@"userId"];
    NSLog(@"%@",userId);
    
    [manager POST:REFRESHPAYRESULT parameters:@{@"userId":[[NSUserDefaults standardUserDefaults] objectForKey:@"userId"],@"applyId":[NSNumber numberWithInteger:[_applyId integerValue]]} success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [self.activityIndicator stopAnimating];
        
        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
        ApplicationStatusViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"ApplicationStatusViewController"];
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        NSDictionary *devDic = [dic objectForKey:@"payResult"];
//        dev.bankName = [devDic objectForKey:@"bankName"];
//        dev.amount = [NSString stringWithFormat:@"%@",[devDic objectForKey:@"amount"]];
//        dev.period = [NSString stringWithFormat:@"%@",[devDic objectForKey:@"interest"]];
        dev.isZore = [[devDic objectForKey:@"isZero"] boolValue];
//        dev.returnMonth = [NSString stringWithFormat:@"%@",[devDic objectForKey:@"returnMonth"]];
//        dev.returnPerMonth = [NSString stringWithFormat:@"%@",[devDic objectForKey:@"returnPerMonth"]];
        dev.isNH = YES;
        dev.store = [devDic objectForKey:@"storeName"];
        dev.bankName = [devDic objectForKey:@"bankName"];
        dev.amount = [NSString stringWithFormat:@"%@",[devDic objectForKey:@"amount"]];
        dev.period = [NSString stringWithFormat:@"%@",[devDic objectForKey:@"period"]];
        dev.returnMonth = [NSString stringWithFormat:@"%@",[devDic objectForKey:@"returnMonth"]];
        dev.returnPerMonth = [NSString stringWithFormat:@"%@",[devDic objectForKey:@"returnPerMonth"]];
        dev.appStatus = [[devDic objectForKey:@"applyStatus"] integerValue];
        dev.storeAddress = [devDic objectForKey:@"address"];
        NSDateFormatter* formatter = [[NSDateFormatter alloc] init];
        [formatter setDateStyle:NSDateFormatterMediumStyle];
        [formatter setTimeStyle:NSDateFormatterShortStyle];
        [formatter setDateFormat:@"yyyy-MM-dd hh:mm"];
        NSDate *date = [NSDate dateWithTimeIntervalSince1970:[[devDic objectForKey:@"applyDate"] integerValue]/1000];
        NSString *confromTimespStr = [formatter stringFromDate:date];
        dev.dateformatter = confromTimespStr;

        [self.navigationController pushViewController:dev animated:YES];
        
        NSLog(@"%@",dic);
        
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [self.activityIndicator stopAnimating];
        
        [NSTimer scheduledTimerWithTimeInterval:5.0 target:self selector:@selector(startRequest) userInfo:nil repeats:NO];
    }];
}


@end
