//
//  WalletViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/27.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "WalletViewController.h"
#import "WalletTableViewCell.h"

@interface WalletViewController ()<UITableViewDataSource, UITableViewDelegate>
@property (strong, nonatomic) IBOutlet UILabel *label;
@property (nonatomic, strong)NSMutableArray *tableArray;
@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;

@end

@implementation WalletViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.label.text = _allMoney;
    self.tableArray = [NSMutableArray arrayWithObjects:@[],@[@"南京卡子门商场",@"¥20万元"],@[@"无锡锡山商场",@"¥30万元"],@[@"常州飞龙商场",@"¥45万元"], nil];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    navL.text = @"我的钱包";
    navL.textAlignment = NSTextAlignmentCenter;
    
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
    // Do any additional setup after loading the view.
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [_tableDic.allKeys count] + 1;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row  == 0) {
        static NSString *cellName = @"cell";
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellName];
        if (!cell) {
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellName];
        }
        cell.backgroundColor = [UIColor groupTableViewBackgroundColor];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;

        return cell;
    }
    static NSString *CellIdentifier = @"LoanTableViewCell";
    WalletTableViewCell *cell = (WalletTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil)
    {
        cell= (WalletTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"WalletTableViewCell" owner:self options:nil]  lastObject];
    }
    cell.shop.text = [_tableDic.allKeys objectAtIndex:indexPath.row - 1];
    cell.money.text =  [NSString stringWithFormat:@"¥%@元",[_tableDic objectForKey:cell.shop.text]];
    if (indexPath.row == [_tableDic.allKeys count]) {
        cell.first.hidden = YES;
        cell.last.hidden = NO;
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
    
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        return 25;
    }
    return 76;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
