//
//  ShareSheet.m
//  红
//
//  Created by 焦钟培 on 16/1/26.
//  Copyright © 2016年 焦钟培. All rights reserved.
//

#import "ShareSheet.h"
#import "AppDelegate.h"
#define WINDOW_COLOR [UIColor colorWithRed:0 green:0 blue:0 alpha:0.4]
#define ANIMATE_DURATION  0.25f



@implementation ShareSheet

-(id)initWithView:(UIView *)view AndHeight:(float)height {
    self = [super init];
    if (self) {
        //初始化背景视图，添加手势
        self.frame = CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width, [UIScreen mainScreen].bounds.size.height);
        self.backgroundColor = WINDOW_COLOR;
        UITapGestureRecognizer *tapGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tappedCancel)];
        [self addGestureRecognizer:tapGesture];
        //生成LZWActionSheetView
        self.backGroundView = [[UIView alloc] initWithFrame:CGRectMake(0, ([UIScreen mainScreen].bounds.size.height - 200), 320, height)];
        self.backGroundView.backgroundColor = [UIColor whiteColor];
        button = [[UIButton alloc] initWithFrame:CGRectMake(0, height - 60, 150 * (KWidth/375), 40)];
        button.center = CGPointMake(KWidth/2, button.center.y);
        button.backgroundColor = [Comment getColor:@"a0a0a0"];
        [button setTitle:@"取消" forState:UIControlStateNormal];
        [button setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [button addTarget:self action:@selector(done) forControlEvents:UIControlEventTouchUpInside];
        
        UITapGestureRecognizer *tapGesture1 = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tappedBackGroundView)];
        [self.backGroundView addGestureRecognizer:tapGesture1];
        
        
        [self.backGroundView addSubview:view];
        [self.backGroundView addSubview:button];
        [self addSubview:self.backGroundView];
        
        [UIView animateWithDuration:0.2f animations:^{
            [self.backGroundView setFrame:CGRectMake(0, [UIScreen mainScreen].bounds.size.height-height, [UIScreen mainScreen].bounds.size.width, height)];
            
        } completion:^(BOOL finished) {
            
        }];
        
        
    }
    
    return self;
}

- (void)tappedCancel {
    [UIView animateWithDuration:ANIMATE_DURATION animations:^{
        [self.backGroundView setFrame:CGRectMake(0, [UIScreen mainScreen].bounds.size.height, [UIScreen mainScreen].bounds.size.width, 0)];
        self.alpha = 0;
    } completion:^(BOOL finished) {
        if (finished) {
            [self removeFromSuperview];
        }
    }];
}
-(void)showInView:(UIView *)view{
    [[UIApplication sharedApplication].delegate.window addSubview:self];
    
}
- (void)tappedBackGroundView {
    
}

-(void)done {
    [self.doneDelegate done];
    [self tappedCancel];
}

-(void)docancel {
    [self tappedCancel];
}



@end
