//
//  PayPasswordViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/28.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "PayPasswordViewController.h"
#import "NSString+CommentString.h"
#import "AFNetworking.h"
#include <openssl/opensslv.h>
#include <openssl/rsa.h>
#include <openssl/evp.h>
#include <openssl/bn.h>

@interface PayPasswordViewController ()<UITextFieldDelegate>
{
    NSMutableArray *dataFSource;
    NSMutableArray *dataLSource;
}
@property (strong, nonatomic) IBOutlet UITextField *firstTextField;
@property (strong, nonatomic) IBOutlet UIView *firstView;
@property (strong, nonatomic) IBOutlet UITextField *lastTextField;
@property (strong, nonatomic) IBOutlet UIView *lastView;
@property (strong, nonatomic) NSString* firstStr;
@property (strong, nonatomic) NSString * lastStr;
@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;

@end

@implementation PayPasswordViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    
    dataFSource = [NSMutableArray array];
    dataLSource = [NSMutableArray array];

    [self setUI];
    
    UIButton *last = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, _lastView.frame.size.width, _lastView.frame.size.height)];
    [last addTarget:self action:@selector(lastAction) forControlEvents:UIControlEventTouchUpInside];
    [_lastView addSubview:last];
    
    UIButton *first = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, _firstView.frame.size.width, _firstView.frame.size.height)];
    [first addTarget:self action:@selector(firstAction) forControlEvents:UIControlEventTouchUpInside];
    [_firstView addSubview:first];
//    NSString *str = [NSString pinxCreator:@"06123456FFFFFFFF" withPinv:@"0000111000111016"];
//    str = [NSString stringWithFormat:@"%@%@",str,str];
//    NSLog(@"%@",str);
//    NSInteger len = [@"c52d48a6f3f1f06fe1edfbeb11f16b0990926392e0c4bf29bff4e1905b3a1e89c98dd5b9d19fbec69be1124d86f61ce8ce1355af3d1631e9ca3e9634d6b29575" length];
//    NSString *temp = @"";
//    for (int i = 0; i < len - 6 - str.length; i++) {
//        NSString *hexString = [NSString stringWithFormat:@"%@",[[NSString alloc] initWithFormat:@"%1x",arc4random()%15]];
//
//        temp = [NSString stringWithFormat:@"%@%@",temp,hexString];
//        NSLog(@"%@",hexString);
//    }
//    str = [NSString stringWithFormat:@"0002%@00%@",temp,str];
//    NSLog(@"%@",str);
//    NSString *lastStr = [self RSAEncrypotoTheData:str];
//    NSLog(@"%@",lastStr);
//    Do any additional setup after loading the view.
}
- (void)lastAction {
    [_firstTextField resignFirstResponder];
    [_lastTextField becomeFirstResponder];
}
- (void)firstAction {
    [_lastTextField resignFirstResponder];
    [_firstTextField becomeFirstResponder];
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (void)setUI
{
    _lastView.layer.borderColor = [[Comment getColor:@"898989"] CGColor];
    
    _lastView.layer.borderWidth = 0.5;
    _firstView.layer.borderColor = [[Comment getColor:@"898989"] CGColor];
    
    _firstView.layer.borderWidth = 0.5;
//    topTX = [[UITextField alloc] initWithFrame:CGRectMake(0, 0, self.view.frame.size.width, self.view.frame.size.height)];
    _firstTextField.hidden = YES;
    _lastTextField.hidden = YES;
//    topTX.keyboardType = UIKeyboardTypeNumberPad;
    [_firstTextField addTarget:self action:@selector(txFchange:) forControlEvents:UIControlEventEditingChanged];
    [_lastTextField addTarget:self action:@selector(txLchange:) forControlEvents:UIControlEventEditingChanged];

//    [self.view addSubview:topTX];
    
    //进入界面，topTX成为第一响应
//    [_firstTextField becomeFirstResponder];
    
    for (int i = 0; i < 6; i++)
    {
        UITextField *pwdLabel = [[UITextField alloc] initWithFrame:CGRectMake(i*41, 0, 41, 41)];
        pwdLabel.layer.borderColor = [[Comment getColor:@"898989"] CGColor];
        pwdLabel.enabled = NO;
        pwdLabel.textAlignment = NSTextAlignmentCenter;//居中
        pwdLabel.secureTextEntry = YES;//设置密码模式
        pwdLabel.layer.borderWidth = 0.5;
        [self.firstView addSubview:pwdLabel];
        [dataFSource addObject:pwdLabel];
    }
    for (int i = 0; i < 6; i++)
    {
        UITextField *pwdLabel = [[UITextField alloc] initWithFrame:CGRectMake(i*41, 0, 41, 41)];
        pwdLabel.layer.borderColor = [[Comment getColor:@"898989"] CGColor];
        pwdLabel.enabled = NO;
        pwdLabel.textAlignment = NSTextAlignmentCenter;//居中
        pwdLabel.secureTextEntry = YES;//设置密码模式
        pwdLabel.layer.borderWidth = 0.5;
        [self.lastView addSubview:pwdLabel];
        [dataLSource addObject:pwdLabel];
    }
}

#pragma mark 文本框内容改变
- (void)txFchange:(UITextField *)tx
{
    NSString *password = tx.text;
    
    if (password.length == dataFSource.count)
    {
        [tx resignFirstResponder];//隐藏键盘
    }
    
    for (int i = 0; i < dataFSource.count; i++)
    {
        UITextField *pwdtx = [dataFSource objectAtIndex:i];
        if (i < password.length)
        {
            NSString *pwd = [password substringWithRange:NSMakeRange(i, 1)];
            pwdtx.text = pwd;
        } else {
            pwdtx.text = @"";

        }
        
    }
    
    if (password.length == 6)
    {
//        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"输入的密码是" message:password delegate:nil cancelButtonTitle:@"完成" otherButtonTitles:nil, nil];
//        [alert show];
        _firstStr = password;
        [_firstTextField resignFirstResponder];
    }
}
- (void)txLchange:(UITextField *)tx
{
    NSString *password = tx.text;
    
    if (password.length == dataLSource.count)
    {
        [tx resignFirstResponder];//隐藏键盘
    }
    
    for (int i = 0; i < dataLSource.count; i++)
    {
        UITextField *pwdtx = [dataLSource objectAtIndex:i];
        if (i < password.length)
        {
            NSString *pwd = [password substringWithRange:NSMakeRange(i, 1)];
            pwdtx.text = pwd;
        } else {
            pwdtx.text = @"";
            
        }
        
        
    }
    
    if (password.length == 6)
    {
        _lastStr = password;
        [_lastTextField resignFirstResponder];
//        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"输入的密码是" message:password delegate:nil cancelButtonTitle:@"完成" otherButtonTitles:nil, nil];
//        [alert show];
    }
}

- (IBAction)buttonAction:(id)sender {
    NSString * str = [NSString stringWithFormat:@"06%@FFFFFFFF",_lastTextField.text];
        str = [NSString pinxCreator:str withPinv:@"0000111000111016"];
        str = [NSString stringWithFormat:@"%@%@",str,str];
        NSLog(@"%@",str);
        NSInteger len = [@"c52d48a6f3f1f06fe1edfbeb11f16b0990926392e0c4bf29bff4e1905b3a1e89c98dd5b9d19fbec69be1124d86f61ce8ce1355af3d1631e9ca3e9634d6b29575" length];
        NSString *temp = @"";
        for (int i = 0; i < len - 6 - str.length; i++) {
            NSString *hexString = [NSString stringWithFormat:@"%@",[[NSString alloc] initWithFormat:@"%1x",1 + arc4random()%15]];
    
            temp = [NSString stringWithFormat:@"%@%@",temp,hexString];
            NSLog(@"%@",hexString);
        }
        str = [NSString stringWithFormat:@"0002%@00%@",temp,str];
        NSLog(@"%@",str);

    NSString *m= @"c52d48a6f3f1f06fe1edfbeb11f16b0990926392e0c4bf29bff4e1905b3a1e89c98dd5b9d19fbec69be1124d86f61ce8ce1355af3d1631e9ca3e9634d6b29575";
    NSString *e=@"010001";
    NSData *decryptedIPKC= [self decryptIPKC:str modulus:m exponent:e];
    NSString *miwen =  decryptedIPKC.description;
    miwen = [miwen stringByReplacingOccurrencesOfString:@" " withString:@""];
    miwen = [miwen stringByReplacingOccurrencesOfString:@"<" withString:@""];
    miwen = [miwen stringByReplacingOccurrencesOfString:@">" withString:@""];
    NSLog(@"ESTE ES EL NSDATA %@", miwen);

    
    
    if ([_lastStr isEqualToString:_firstStr] && _lastStr.length == 6) {
//        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"提示" message:@"成功" delegate:nil cancelButtonTitle:@"完成" otherButtonTitles:nil, nil];
//        [alert show];
//
//        [self.navigationController popViewControllerAnimated:YES];
        [self startHTTPMiWen: miwen];
    } else {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"提示" message:@"请输入相同的六位密码" delegate:nil cancelButtonTitle:@"完成" otherButtonTitles:nil, nil];
        [alert show];
    }
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[Comment imageWithColor:[UIColor groupTableViewBackgroundColor]] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    navL.textAlignment = NSTextAlignmentCenter;
    navL.text = @"设置支付密码";
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
//    UIView *newView = [[UIView alloc] initWithFrame:CGRectMake(0, -20, KWidth, 20)];
//    newView.backgroundColor = [UIColor blackColor];
//    newView.tag = 1000;
//    [self.navigationController.navigationBar addSubview:newView];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    UIView *newView = [self.navigationController.navigationBar viewWithTag:1000];
    [newView removeFromSuperview];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
}
-(NSData*) decryptIPKC:(NSString*)ipkc modulus:(NSString*)mod exponent:(NSString*)exp{
    NSString * hexString = ipkc;
    int hexStringLength= [hexString length] / 2;
    //unsigned char enc_bin[144];
    unsigned char dec_bin[hexStringLength];
    //int enc_len;
    int dec_len;
    RSA * rsa_pub = RSA_new();
    
    const char *N=[mod UTF8String] ;
    const char *E=[exp UTF8String];
    char * myBuffer = (char *)malloc((int)[hexString length] / 2 + 1);
    bzero(myBuffer, [hexString length] / 2 + 1);
    for (int i = 0; i < [hexString length] - 1; i += 2) {
        unsigned int anInt;
        NSString * hexCharStr = [hexString substringWithRange:NSMakeRange(i, 2)];
        NSScanner * scanner = [[NSScanner alloc] initWithString:hexCharStr];
        [scanner scanHexInt:&anInt];
        myBuffer[i / 2] = (char)anInt;
    }
    printf("Mybuffer: %s",myBuffer);
    if (!BN_hex2bn(&rsa_pub->n, N)) {
        printf("NO CARGO EL MODULO");
    }
    printf(" N: %s\n", N);
    printf(" n: %s\n", BN_bn2hex(rsa_pub->n));
    
    if (!BN_hex2bn(&rsa_pub->e, E)) {
        printf("NO CARGO EL EXPONENTE");
    }
    printf(" E: %s\n", E);
    printf(" e: %s\n", BN_bn2hex(rsa_pub->e));
    printf("public key size : %d bits\n", RSA_size(rsa_pub));
    /* decrypt */
    if ((dec_len = RSA_public_decrypt(hexStringLength, (unsigned char*)myBuffer, dec_bin, rsa_pub,RSA_NO_PADDING))<0) {
        printf("NO\n ");
    }
    printf("decrypted data:\n %s", dec_bin);
    //    print_hex(dec_bin, dec_len);
    NSData* data = [NSData dataWithBytes:dec_bin length:sizeof(dec_bin)];
    free(myBuffer);
    return data;
}
- (void)startHTTPMiWen: (NSString *)mimen {
    
    NSDictionary *dic = @{@"id":[NSNumber numberWithInteger:[[[NSUserDefaults standardUserDefaults] objectForKey:@"userId"] integerValue]],@"userCardId":[[NSUserDefaults standardUserDefaults] objectForKey:@"userCardId"],@"payPwd":mimen,@"phone":[[NSUserDefaults standardUserDefaults] objectForKey:@"phoneNumut"]};
    [self.activityIndicator startAnimating];
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    [manager POST:SETPAYPWD parameters:dic success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [self.activityIndicator stopAnimating];
        
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"%@",dic);
//        NSString *str = [dic objectForKey:@"message"];
        [self.navigationController popViewControllerAnimated:YES];
        
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [self.activityIndicator stopAnimating];
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"网络异常" preferredStyle:UIAlertControllerStyleAlert];
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
    }];
}

@end
