//
//  MoreViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/14.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "MoreViewController.h"
#import "AccountsTableViewCell.h"
#import "AboutViewController.h"
#import "HelpViewController.h"
#import "ShareSheet.h"

@interface MoreViewController ()<UITableViewDelegate, UITableViewDataSource,doneSelect>
@property (nonatomic, strong)NSMutableArray *tableArray;
@end

@implementation MoreViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.tableArray = [NSMutableArray arrayWithObjects:@"关于我们",@"咨询服务",@"分享好友",@"给予评价",@"",@"助手",@"", nil];
    self.navigationItem.title = @"";
}
- (void)createSheet {
    UIView *shareView = [[UIView alloc] initWithFrame:CGRectMake(20, 12, (KWidth-40), (16 + 100 * (KWidth / 375))* 2)];
    ShareSheet* shareSheet = [[ShareSheet alloc] initWithView:shareView AndHeight:(16 + 100 * (KWidth / 375))* 2 + 78];

    shareSheet.doneDelegate = self;
    for (int i = 0; i < 5; i++) {
        NSInteger numberForButton;
        if (i > 2) {
            numberForButton = 1;
        } else {
            numberForButton = 0;
        }
        UIButton *button = [[UIButton alloc] initWithFrame:CGRectMake(((KWidth-40)/3 - 70* (KWidth / 375))/2 + (i%3) * ((KWidth-40)/3), 8 + (16 + 100 * (KWidth / 375)) * numberForButton, 70* (KWidth / 375), 100* (KWidth / 375))];
        [button setImage:[UIImage imageNamed:[NSString stringWithFormat:@"share_%d",i]] forState:UIControlStateNormal];
        [button addTarget:shareSheet action:@selector(done) forControlEvents:UIControlEventTouchUpInside];
        [shareView addSubview:button];
    }
    [shareSheet showInView:self.view];

}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    return [_tableArray count];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 4 || indexPath.row == 6) {
        
        static NSString *CellIdentifier = @"UITableViewCell";
        UITableViewCell *cell = (UITableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil)
        {
            cell= [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        UIView *view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, KWidth, 1)];
        view.backgroundColor = [Comment getColor:@"CECFD0"];
        cell.backgroundColor = [UIColor groupTableViewBackgroundColor];
        [cell addSubview:view];
        return cell;
    }

    static NSString *CellIdentifier = @"AccountsTableViewCell";
    AccountsTableViewCell *cell = (AccountsTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil)
    {
        cell= (AccountsTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"AccountsTableViewCell" owner:self options:nil]  lastObject];
    }
    if (indexPath.row == 3 || indexPath.row == 5) {
//        cell.lastView.hidden = NO;
        cell.firstView.hidden = YES;
    }
    
    cell.pic.image = [UIImage imageNamed:[_tableArray objectAtIndex:indexPath.row]];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.title.text = [_tableArray objectAtIndex:indexPath.row];
    return cell;
    
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 4) {
        return 13;
    }
    if (indexPath.row == 6) {
        return 1;
    }
    return 65;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
    AboutViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"AboutViewController"];
    HelpViewController *helpDev = [[HelpViewController alloc] init];
    NSString *str = [NSString stringWithFormat:@"itms-apps://itunes.apple.com/WebObjects/MZStore.woa/wa/viewContentsUserReviews?type=Purple+Software&id=%@",@"1051289750"];
    NSURL * url = [NSURL URLWithString:str];
    switch (indexPath.row) {
        case 0:
         dev.title = @"        红星美凯龙家居集团股份有限公司（简称：红星美凯龙01528.HK）连续5年跻身中国民营企业500强前50位，自1986年创业以来，始终以建设温馨、和谐的家园，提升消费者的居家生活品味为己任。截至目前，已在北京、上海、广州、深圳等110多个城市开办了162家商场。2015年销售总额突破600亿元，成为中国家居业的第一品牌。荣获“国内影响力品牌领袖大奖”、“家居家装行业影响力品牌领袖大奖”等。上海星易通汇商务服务有限公司前身是红星美凯龙集团支付与预付费卡业务事业部。2013年6月商务部特许红星美凯龙集团获得家具行业唯一一张单用途预付费卡备案牌照(310000EEJ0021)，红星美凯龙集团的全资子公司-上海星易通汇商务服务有限公司，全面负责通汇卡运营管理。红星美凯龙通汇卡以整合家居行业上下游资源，推进预付式消费，开展商业信用建设、提升顾客服务为主要诉求，藉此打造红星美凯龙品牌经营体系内集“新型支付+营销+信用+服务”于一体的综合性运营管理工具。\n\n        上海星易通汇商务服务有限公司 版权所有 2015";
            dev.navStr = @"品牌介绍";
            [self.navigationController pushViewController:dev animated:YES];
            break;
        case 1:
            [self createrAlertMessage];
            break;
        case 2:
            [self createSheet];
            break;
        case 3:
            if ([[UIApplication sharedApplication] canOpenURL:url]) {
                [[UIApplication sharedApplication] openURL:url];
            } else {
                NSLog(@"can not open");
            }
            break;
        case 5:
            self.tabBarController.tabBar.hidden=YES;
            
            //2.如果在push跳转时需要隐藏tabBar，设置self.hidesBottomBarWhenPushed=YES;
            
            self.hidesBottomBarWhenPushed=YES;
            [self.navigationController pushViewController:helpDev animated:YES];
            self.hidesBottomBarWhenPushed=NO;
            break;
        default:
            break;
    }
}
- (void)createrAlertMessage {
    //初始化提示框；
    NSString *cancelButtonTitle = NSLocalizedString(@"取消", nil);
    NSString *otherButtonTitle = NSLocalizedString(@"拨打", nil);
    
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"星易家居贷" message:@"咨询服务热线\n4008-213-213\n（服务时间：工作日9：00-18：00）" preferredStyle:UIAlertControllerStyleAlert];
    // Create the actions.
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
    }];
    UIAlertAction *otherAction = [UIAlertAction actionWithTitle:otherButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        UIWebView*callWebview =[[UIWebView alloc] init];
        NSURL *telURL =[NSURL URLWithString:@"tel:4008213213"];// 貌似tel:// 或者 tel: 都行
        [callWebview loadRequest:[NSURLRequest requestWithURL:telURL]];
        //记得添加到view上
        [self.view addSubview:callWebview];
    }];
    [alertController addAction:cancelAction];
    [alertController addAction:otherAction];
    
    //弹出提示框；
    [self presentViewController:alertController animated:true completion:nil];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@"nav"] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleBlackTranslucent;
    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (void)done {
    
}

@end
