//
//  LoginViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/15.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "LoginViewController.h"
#import "AFNetworking.h"
#import "NSString+CommentString.h"
#import "ForgetViewController.h"

@interface LoginViewController ()<UITextFieldDelegate>
@property (strong, nonatomic) UIAlertController *alert;
@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;

@property (strong, nonatomic) IBOutlet UITextField *phoneNum;
@property (strong, nonatomic) IBOutlet UITextField *password;
@property (strong, nonatomic) UIView *doneView;
@end

@implementation LoginViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    
    self.phoneNum.delegate = self;
    self.password.delegate = self;
    [self registerForKeyboardNotifications];
    self.doneView = [UIView new];
    _doneView.backgroundColor = [Comment getColor:@"D0D4DA"];
    _doneView.hidden = YES;
    _doneView.frame = CGRectMake(0, KHeight - 246, KWidth, 30);
    [self.view addSubview:_doneView];
    [self.view addSubview:_doneView];
    UIView *upLine = [[UIView alloc] initWithFrame:CGRectMake(0, 0, KWidth, 1)];
    upLine.backgroundColor = [Comment getColor:@"CECFD0"];
    [_doneView addSubview:upLine];
    UIView *downLine = [[UIView alloc] initWithFrame:CGRectMake(0, 29, KWidth, 1)];
    downLine.backgroundColor = [UIColor lightGrayColor];
    [_doneView addSubview:downLine];
    UIButton *doneButton = [[UIButton alloc] initWithFrame:CGRectMake(KWidth - 50, 5, 40, 20)];
//    doneButton.layer.cornerRadius = 2;
//    doneButton.layer.masksToBounds = YES;
//    doneButton.layer.borderColor = [[UIColor blackColor] CGColor];
//    doneButton.layer.borderWidth = 0.5;
    [doneButton setTitleColor:[Comment getColor:@"007aff"] forState:UIControlStateNormal];

    [doneButton setTitle:@"完成" forState:UIControlStateNormal];
    [doneButton addTarget:self action:@selector(responderKeyBoard) forControlEvents:UIControlEventTouchUpInside];
    [_doneView addSubview:doneButton];
    // Do any additional setup after loading the view.
}
- (void)responderKeyBoard {
    _doneView.hidden = YES;
    [self.password resignFirstResponder];
    [self.phoneNum resignFirstResponder];
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [self.password resignFirstResponder];
    [self.phoneNum resignFirstResponder];
    return NO;
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (IBAction)loginAction:(id)sender {
    [self.activityIndicator startAnimating];
    NSDictionary *dic = @{@"phone":_phoneNum.text,@"password":[_password.text md5String]};
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    [manager POST:LOGINURL parameters:dic success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [self.activityIndicator stopAnimating];
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"%@",dic);
        id message = [dic objectForKey:@"message"];
        if ([message isKindOfClass:[NSString class]]) {
            [self createrAlertMessage:[dic objectForKey:@"message"]];
        } else {
            [self.navigationController popViewControllerAnimated:NO];
            NSString *userId = [NSString stringWithFormat:@"%@",[[dic objectForKey:@"user"] objectForKey:@"id"]];
            NSString *phoneNum = [NSString stringWithFormat:@"%@",[[dic objectForKey:@"user"] objectForKey:@"phone"]];
            NSString *userCardId = [NSString stringWithFormat:@"%@",[[dic objectForKey:@"user"] objectForKey:@"userCardId"]];
            [[NSUserDefaults standardUserDefaults] setObject:@"yes" forKey:@"islogin"];
            [[NSUserDefaults standardUserDefaults] setObject:userId forKey:@"userId"];
            [[NSUserDefaults standardUserDefaults] setObject:phoneNum forKey:@"phoneNum"];
            [[NSUserDefaults standardUserDefaults] setObject:userCardId forKey:@"userCardId"];
            [[NSUserDefaults standardUserDefaults] setObject:_password.text forKey:@"password"];

        }
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [self.activityIndicator stopAnimating];
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"网络异常" preferredStyle:UIAlertControllerStyleAlert];
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
    }];
}

- (void)createrAlertMessage: (NSString *)message {
    //初始化提示框；
    self.alert = [UIAlertController alertControllerWithTitle:@"提示" message:message preferredStyle:  UIAlertControllerStyleAlert];
    
    //弹出提示框；
    [self presentViewController:_alert animated:true completion:nil];
    [NSTimer scheduledTimerWithTimeInterval:2 target:self selector:@selector(dismissViewController) userInfo:nil repeats:NO];
}
- (void)dismissViewController {
    [_alert dismissViewControllerAnimated:YES completion:nil];
}
- (void) registerForKeyboardNotifications
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWasShown:) name:UIKeyboardDidShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter]  addObserver:self selector:@selector(keyboardWasHidden:) name:UIKeyboardDidHideNotification object:nil];
}

- (void) keyboardWasShown:(NSNotification *) notif
{
    _doneView.hidden = NO;
    NSDictionary *info = [notif userInfo];
    NSValue *value = [info objectForKey:UIKeyboardFrameBeginUserInfoKey];
    CGSize keyboardSize = [value CGRectValue].size;
    
    NSLog(@"keyBoard:%f", keyboardSize.height);
}
- (void) keyboardWasHidden:(NSNotification *) notif
{
    _doneView.hidden = YES;
    NSDictionary *info = [notif userInfo];
    NSValue *value = [info objectForKey:UIKeyboardFrameBeginUserInfoKey];
    CGSize keyboardSize = [value CGRectValue].size;
    NSLog(@"keyboardWasHidden keyBoard:%f", keyboardSize.height);
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[Comment imageWithColor:[UIColor groupTableViewBackgroundColor]] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    navL.textAlignment = NSTextAlignmentCenter;
    navL.text = @"登录家居贷";
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
//    UIView *newView = [[UIView alloc] initWithFrame:CGRectMake(0, -20, KWidth, 20)];
//    newView.backgroundColor = [UIColor blackColor];
//    newView.tag = 1000;
//    [self.navigationController.navigationBar addSubview:newView];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    UIView *newView = [self.navigationController.navigationBar viewWithTag:1000];
    [newView removeFromSuperview];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    [self.navigationController.navigationBar setTintColor:[Comment getColor:@"4999F5"]];

}
- (IBAction)forgetAction:(id)sender {
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Login" bundle:nil];
    ForgetViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"ForgetViewController"];
    if (_phoneNum.text.length != 0) {
        dev.phoneNum = _phoneNum.text;
        [self.navigationController pushViewController:dev animated:YES];
    } else {
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"请输入手机号码" preferredStyle:UIAlertControllerStyleAlert];
        
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
    }
}


@end
