//
//  LoanViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/27.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "LoanViewController.h"
#import "ApplicationStatusViewController.h"
#import "LoanTableViewCell.h"
#import "AFNetworking.h"
@interface LoanViewController ()<UITableViewDataSource, UITableViewDelegate>
@property (nonatomic, strong)NSMutableArray *noArray;
@property (nonatomic, strong)NSMutableArray *lowArray;
@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;

@property (nonatomic, strong)NSMutableArray *tableArray;
@property (strong, nonatomic) IBOutlet UITableView *table;
@property (strong, nonatomic) UIAlertController *alert;

@end

@implementation LoanViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    
    [self startRequest];
    self.tableArray = [NSMutableArray array];
    self.lowArray = [NSMutableArray array];
    self.noArray = [NSMutableArray array];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.text = @"我的贷款";
    navL.font = [UIFont systemFontOfSize:16];
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
    // Do any additional setup after loading the view.
}
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 2;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if (section == 0) {
        for (NSDictionary *dic in _tableArray) {
            if ([[dic objectForKey:@"isZero"] boolValue]) {
                [_noArray addObject:dic];
            }
        }
        return [_noArray count] + 1;
    }
    for (NSDictionary *dic in _tableArray) {
        if (![[dic objectForKey:@"isZero"] boolValue]) {
            [_lowArray addObject:dic];
        }
    }
    return [_lowArray count];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == [_noArray count] && indexPath.section == 0) {
        static NSString *cellName = @"cell";
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellName];
        if (!cell) {
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellName];
        }
        cell.backgroundColor = [UIColor groupTableViewBackgroundColor];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }
    static NSString *CellIdentifier = @"LoanTableViewCell";
    LoanTableViewCell *cell = (LoanTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil)
    {
        cell= (LoanTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"LoanTableViewCell" owner:self options:nil]  lastObject];
    }
    if (indexPath.section == 0) {
        if (indexPath.row == [_noArray count] - 1) {
            cell.first.hidden = YES;
            cell.last.hidden = NO;
        }
        NSDictionary *dic = [_noArray objectAtIndex:indexPath.row];
//        cell.type.text = @"零利息家居贷";
        cell.pic.image = [UIImage imageNamed:@"零利息icon"];
        cell.shop.text = [dic objectForKey:@"storeName"];
        cell.money.text = [NSString stringWithFormat:@"¥%@万元",[dic objectForKey:@"amount"]];
        NSDateFormatter* formatter = [[NSDateFormatter alloc] init];
        [formatter setDateStyle:NSDateFormatterMediumStyle];
        [formatter setTimeStyle:NSDateFormatterShortStyle];
        [formatter setDateFormat:@"yyyy-MM-dd"];
        NSDate *date = [NSDate dateWithTimeIntervalSince1970:[[dic objectForKey:@"applyDate"] integerValue]/1000];
        NSString *confromTimespStr = [formatter stringFromDate:date];
        cell.type.text = [NSString stringWithFormat:@"申请日期：%@",confromTimespStr];

    } else {
        NSDictionary *dic = [_lowArray objectAtIndex:indexPath.row];
        cell.first.hidden = YES;
        cell.last.hidden = NO;
        
        cell.shop.text = [dic objectForKey:@"storeName"];
//        cell.type.text = @"低利息家居贷";
        cell.money.text = [NSString stringWithFormat:@"¥%@万元",[dic objectForKey:@"amount"]];
        cell.pic.image = [UIImage imageNamed:@"Account低利息图标"];
        NSDateFormatter* formatter = [[NSDateFormatter alloc] init];
        [formatter setDateStyle:NSDateFormatterMediumStyle];
        [formatter setTimeStyle:NSDateFormatterShortStyle];
        [formatter setDateFormat:@"yyyy-MM-dd"];
        NSDate *date = [NSDate dateWithTimeIntervalSince1970:[[dic objectForKey:@"applyDate"] integerValue]/1000];
        NSString *confromTimespStr = [formatter stringFromDate:date];
        cell.type.text = [NSString stringWithFormat:@"申请日期：%@",confromTimespStr];
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
    
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.section == 0 && indexPath.row == [_noArray count]) {
        return 20;
    }
    return 92;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
    ApplicationStatusViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"ApplicationStatusViewController"];
    if (indexPath.section == 0) {
        if (indexPath.row != [_noArray count]) {
            NSDictionary *dic = [_noArray objectAtIndex:indexPath.row];
            dev.store = [dic objectForKey:@"storeName"];
            dev.bankName = [dic objectForKey:@"bankName"];
            dev.amount = [NSString stringWithFormat:@"%@",[dic objectForKey:@"amount"]];
            dev.period = [NSString stringWithFormat:@"%@",[dic objectForKey:@"period"]];
            dev.isZore = YES;
            dev.returnMonth = [NSString stringWithFormat:@"%@",[dic objectForKey:@"returnMonth"]];
            dev.returnPerMonth = [NSString stringWithFormat:@"%@",[dic objectForKey:@"returnPerMonth"]];
            dev.appStatus = [[dic objectForKey:@"applyStatus"] integerValue];
            dev.storeAddress = [dic objectForKey:@"address"];
            NSDateFormatter* formatter = [[NSDateFormatter alloc] init];
            [formatter setDateStyle:NSDateFormatterMediumStyle];
            [formatter setTimeStyle:NSDateFormatterShortStyle];
            [formatter setDateFormat:@"yyyy-MM-dd hh:mm"];
            NSDate *date = [NSDate dateWithTimeIntervalSince1970:[[dic objectForKey:@"applyDate"] integerValue]/1000];
            NSString *confromTimespStr = [formatter stringFromDate:date];
            dev.dateformatter = confromTimespStr;
            [self.navigationController pushViewController:dev animated:YES];
        }
    } else {
        NSDictionary *dic = [_lowArray objectAtIndex:indexPath.row];
        dev.store = [dic objectForKey:@"storeName"];
        dev.bankName = [dic objectForKey:@"bankName"];
        dev.amount = [NSString stringWithFormat:@"%@",[dic objectForKey:@"amount"]];
        dev.period = [NSString stringWithFormat:@"%@",[dic objectForKey:@"period"]];
        dev.isZore = NO;
        dev.appStatus = [[dic objectForKey:@"applyStatus"] integerValue];
        dev.storeAddress = [dic objectForKey:@"address"];
        dev.returnMonth = [NSString stringWithFormat:@"%@",[dic objectForKey:@"returnMonth"]];
        dev.returnPerMonth = [NSString stringWithFormat:@"%@",[dic objectForKey:@"returnPerMonth"]];
        NSDateFormatter* formatter = [[NSDateFormatter alloc] init];
        [formatter setDateStyle:NSDateFormatterMediumStyle];
        [formatter setTimeStyle:NSDateFormatterShortStyle];
        [formatter setDateFormat:@"yyyy-MM-dd hh:mm"];
        NSDate *date = [NSDate dateWithTimeIntervalSince1970:[[dic objectForKey:@"applyDate"] integerValue]/1000];
        NSString *confromTimespStr = [formatter stringFromDate:date];
        dev.dateformatter = confromTimespStr;
        [self.navigationController pushViewController:dev animated:YES];
    }
}
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    return 37.5;
}
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView *view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, KWidth, 37.5)];
    view. backgroundColor = [UIColor whiteColor];
    UILabel *lable = [[UILabel alloc] initWithFrame:CGRectMake(21, 11, 1, 15.5)];
    
    lable.font = [UIFont systemFontOfSize:19];
    if (section == 0) {
        lable.text = @"零利息家居贷";
    } else {
        lable.text = @"低利息家居贷";
    }
    lable.textAlignment = NSTextAlignmentCenter;
    [lable sizeToFit];
    [view addSubview:lable];
    
    UIView *bview = [[UIView alloc] initWithFrame:CGRectMake(0, 36.5, KWidth, 1)];
    bview.backgroundColor = [Comment getColor:@"CECFD0"];
    [view addSubview:bview];
    return view;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (void)startRequest {
    [_activityIndicator startAnimating];
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    
    [manager POST:BYUSER parameters:@{@"userId":[[NSUserDefaults standardUserDefaults] objectForKey:@"userId"]} success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [_activityIndicator stopAnimating];

        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        [self.tableArray removeAllObjects];
        [self.tableArray addObjectsFromArray:[dic objectForKey:@"result"]];
        [_table reloadData];
        NSLog(@"%@",dic);
        
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [_activityIndicator stopAnimating];

        self.alert = [UIAlertController alertControllerWithTitle:@"网络异常" message:nil preferredStyle:UIAlertControllerStyleAlert];
        [self presentViewController:_alert animated:true completion:nil];
        [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(dismissViewController) userInfo:nil repeats:NO];
    }];
}
- (void)dismissViewController {
    [_alert dismissViewControllerAnimated:YES completion:nil];
}


@end
