//
//  ForgetViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/23.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "ForgetViewController.h"
#import "PushPasswordViewController.h"
#import "AFNetworking.h"
@interface ForgetViewController ()<UITextFieldDelegate>
@property (strong, nonatomic) IBOutlet UITextField *textfield;
@property (strong, nonatomic) IBOutlet UIButton *button;
@property (strong, nonatomic) IBOutlet UILabel *lable;
@property (nonatomic) NSInteger num;

@end

@implementation ForgetViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.lable.text = _phoneNum;
    self.button.enabled = NO;
    _num = 60;
    [self startHTTP];
    [_button setTitle:[NSString stringWithFormat:@"%ld后可重新发送",_num] forState:UIControlStateNormal];
    [self createTimer];
    _textfield.delegate = self;
    // Do any additional setup after loading the view.
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [self.textfield resignFirstResponder];
    return NO;
}

- (void)createTimer {
    [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(timerAction) userInfo:nil repeats:NO];
}
- (void)timerAction {
    _num--;
    [_button setTitle:[NSString stringWithFormat:@"%ld后可重新发送",_num] forState:UIControlStateNormal];
    if (_num == 0) {
       [_button setTitle:@"获取验证码" forState:UIControlStateNormal];
        _button.enabled = YES;
    }
    if (!_button.enabled) {
        [self createTimer];
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[Comment imageWithColor:[UIColor groupTableViewBackgroundColor]] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    navL.textAlignment = NSTextAlignmentCenter;
    navL.text = @"忘记密码";
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
//    UIView *newView = [[UIView alloc] initWithFrame:CGRectMake(0, -20, KWidth, 20)];
//    newView.backgroundColor = [UIColor blackColor];
//    newView.tag = 1000;
//    [self.navigationController.navigationBar addSubview:newView];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    UIView *newView = [self.navigationController.navigationBar viewWithTag:1000];
    [newView removeFromSuperview];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    [self.navigationController.navigationBar setTintColor:[Comment getColor:@"4999F5"]];

}
- (IBAction)nextAction:(id)sender {
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Login" bundle:nil];
    PushPasswordViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"PushPasswordViewController"];
    if (_textfield.text.length != 0) {
        _button.enabled = YES;
        dev.phoneNum = self.phoneNum;
        dev.authCode = _textfield.text;
        [self.navigationController pushViewController:dev animated:YES];
    } else {
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"请输入验证码" preferredStyle:UIAlertControllerStyleAlert];
        
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
    }

}
- (IBAction)buttonAction:(id)sender {
    [self startHTTP];
}
- (void)startHTTP {
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    [manager POST:CREATESENDURL parameters:@{@"phone":_phoneNum} success:^(AFHTTPRequestOperation *operation, id responseObject) {
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"%@",dic);
        NSString *result = [[NSString alloc] initWithData:responseObject encoding:NSUTF8StringEncoding];
        
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        NSLog(@"1");
    }];
}

@end
