//
//  CostDetailViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/17.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "CostDetailViewController.h"
#import "CostFirstTableViewCell.h"
#import "LastTableViewCell.h"
#import "CostSecondTableViewCell.h"
#import "LoginViewController.h"
#import "ApplicationMaterialsViewController.h"
#import "HeaderView.h"
#import "FBAudioTrack.h"
#import "OtherHeader.h"
@interface CostDetailViewController ()<UITableViewDataSource, UITableViewDelegate, UITextFieldDelegate>

@property (strong, nonatomic) UIView *doneView;

@property (strong, nonatomic) IBOutlet UITableView *table;
@property (strong, nonatomic) HeaderView *headerView;
@property (strong, nonatomic) OtherHeader *otherHeaderView;

@property (strong, nonatomic) UIAlertController *alert;
@property (strong, nonatomic) IBOutlet UIButton *application;
@property (nonatomic) CGFloat detailH;
@property (nonatomic) CGFloat downH;
@property (nonatomic) BOOL resultVHidden;
@property (strong, nonatomic) NSMutableArray *tableArray;
@property (strong, nonatomic) NSMutableDictionary *tableDic;
@property (strong, nonatomic) NSMutableArray *materialArray;
@property (nonatomic, strong) NSMutableDictionary* materialHiddenDic;
@end

@implementation CostDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    UIView *view = [[UIView alloc] initWithFrame:CGRectMake(0, -KHeight, KWidth, KHeight)];
    view.backgroundColor = [Comment getColor:@"4999F5"];
    [_table addSubview:view];
    UIView *selfView = [[UIView alloc] initWithFrame:CGRectMake(0, -64, KWidth, 64)];
    view.backgroundColor = [Comment getColor:@"4999F5"];
    [self.view addSubview:selfView];
    self.application.layer.cornerRadius = 2;
    self.application.layer.masksToBounds = YES;
//    self.application.layer.borderColor = [[UIColor blackColor] CGColor];
//    self.application.layer.borderWidth = 0.5;
    self.tableArray = [NSMutableArray arrayWithObjects:@[],@[@"申请条件",@""],@[],@[@"所需材料",@""], nil];
    self.tableDic = [NSMutableDictionary dictionaryWithObjectsAndKeys:@"",@"money",@"",@"month", nil];
    NSDictionary *dic1 = @{@"name":@"江苏银行",@"material":@"年龄要求：22~59周岁；\n房产要求：本地有房产，业主本人申请；\n社保要求：提供社保缴费证明且不低于6个月\n流水要求：税后打卡工资2000元以上；\n信用要求：信用记录良好。无不良逾期，暂不接受信用空白人士申请",@"condition":@"1.身份证\n2.经鉴定后的房产证或购房合同"};
     NSDictionary *dic2 = @{@"name":@"海尔金融",@"material":@"年龄要求：22~59周岁；\n房产要求：本地有房产，业主本人申请；\n社保要求：提供社保缴费证明且不低于6个月\n流水要求：税后打卡工资2000元以上；\n信用要求：信用记录良好。无不良逾期，暂不接受信用空白人士申请",@"condition":@"1.申请人二代身份证复印件（1份）；\n2.工作证明（1份）；\n3.申请人可验证的收入材料（1份）；\n4.居住地证明（1份）；\n5.申请人名下还款银行卡复印件（1份）；\n6.房产证明复印件（1份）；\n7.自雇人士需提供营业执照副本复印件（1份）"};
    self.materialArray = [NSMutableArray arrayWithObjects:dic1,dic2, nil];
    self.resultVHidden = YES;
    self.materialHiddenDic = [NSMutableDictionary dictionaryWithObjectsAndKeys:@"yes",@"material",@"yes",@"condition", nil];
    [self createHeaderView];
    
    if ([self.returnType isEqualToString:@"1"]) {
        self.returnMonth = @"1";
    }
    [self registerForKeyboardNotifications];
//    self.doneView = [UIView new];
//    _doneView.backgroundColor = [Comment getColor:@"D0D4DA"];
//    _doneView.hidden = YES;
//    _doneView.frame = CGRectMake(0, KHeight - 246, KWidth, 30);
//    [self.view addSubview:_doneView];
//    UIView *upLine = [[UIView alloc] initWithFrame:CGRectMake(0, 0, KWidth, 1)];
//    upLine.backgroundColor = [Comment getColor:@"CECFD0"];
//    [_doneView addSubview:upLine];
//    UIView *downLine = [[UIView alloc] initWithFrame:CGRectMake(0, 29, KWidth, 1)];
//    downLine.backgroundColor = [UIColor lightGrayColor];
//    [_doneView addSubview:downLine];
//    UIButton *doneButton = [[UIButton alloc] initWithFrame:CGRectMake(KWidth - 50, 5, 40, 20)];
//    doneButton.layer.cornerRadius = 2;
//    doneButton.layer.masksToBounds = YES;
//    doneButton.layer.borderColor = [[UIColor blackColor] CGColor];
//    doneButton.layer.borderWidth = 0.5;
//    [doneButton setTitleColor:[Comment getColor:@"007aff"] forState:UIControlStateNormal];
//
//    [doneButton setTitle:@"完成" forState:UIControlStateNormal];
//    [doneButton addTarget:self action:@selector(responderKeyBoard) forControlEvents:UIControlEventTouchUpInside];
//    [_doneView addSubview:doneButton];
    // Do any additional setup after loading the view.
}
- (void)responderKeyBoard {
    _doneView.hidden = YES;
    [self.headerView.moneyField resignFirstResponder];
    [self.headerView.monthField resignFirstResponder];
    [self.otherHeaderView.moneyField resignFirstResponder];
    [self.otherHeaderView.monthField resignFirstResponder];
}

- (void)createHeaderView {
    UIView *tableHeaderView = [UIView new];
    if (_isZore) {
        NSArray *nib = [[NSBundle mainBundle] loadNibNamed:@"OtherHeader" owner:self options:nil];
        self.otherHeaderView = [nib objectAtIndex:0];
        _otherHeaderView.detailL.text = _headerDetails;
        _otherHeaderView.moneyField.placeholder = [NSString stringWithFormat:@"额度范围%@--%@万",self.minAmount,self.maxAmount];
        self.otherHeaderView.monthlyRates.text = self.interest;
        NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:[UIFont systemFontOfSize:12],NSFontAttributeName, nil];
        CGRect rect = [_otherHeaderView.detailL.text boundingRectWithSize:CGSizeMake([[UIScreen mainScreen] bounds].size.width - 72, 10000) options:(NSStringDrawingUsesLineFragmentOrigin | NSStringDrawingUsesFontLeading) attributes:dic context:nil];
        if ([_returnMonthsArray count] != 1) {
            [_otherHeaderView.button addTarget:self action:@selector(createrAlertMessage) forControlEvents:UIControlEventTouchUpInside];
        } else {
            _otherHeaderView.monthField.text = @"6个月";
            self.period = @"6";
        }
        _otherHeaderView.frame = CGRectMake(0,0,KWidth, 344 + rect.size.height);
        _otherHeaderView.monthField.enabled = NO;
        _otherHeaderView.moneyField.delegate = self;
        tableHeaderView.frame = CGRectMake(0,0,KWidth, 344 + rect.size.height);
        [tableHeaderView addSubview:_otherHeaderView];
        self.table.tableHeaderView = tableHeaderView;
        return;
    }
    NSArray *nib = [[NSBundle mainBundle] loadNibNamed:@"HeaderView" owner:self options:nil];
    self.headerView = [nib objectAtIndex:0];
    NSInteger number;
    number = [_returnMonthsArray count];
    
    _headerView.detailL.text = _headerDetails;
    _headerView.moneyField.placeholder = [NSString stringWithFormat:@"额度范围%@--%@万",self.minAmount,self.maxAmount];
    self.headerView.monthlyRates.text = self.interest;
    self.headerView.termT.enabled = NO;
    [self.headerView.button addTarget:self action:@selector(selectPaytype) forControlEvents:UIControlEventTouchUpInside];
    NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:[UIFont systemFontOfSize:12],NSFontAttributeName, nil];
    CGRect rect = [_headerView.detailL.text boundingRectWithSize:CGSizeMake([[UIScreen mainScreen] bounds].size.width - 72, 10000) options:(NSStringDrawingUsesLineFragmentOrigin | NSStringDrawingUsesFontLeading) attributes:dic context:nil];
    if ([self.returnType isEqualToString:@"2"]) {
        _headerView.frame = CGRectMake(0,0,KWidth, 375 + rect.size.height);
        _headerView.monthField.enabled = NO;
        _headerView.moneyField.delegate = self;
        _headerView.monthField.text = @"12个月";
        _period = @"12";
        tableHeaderView.frame = CGRectMake(0,0,KWidth, 375   + rect.size.height);
        [tableHeaderView addSubview:_headerView];
        self.table.tableHeaderView = tableHeaderView;
        _headerView.termT.text = @"月度";
        self.interest = [[_returnMonthsArray objectAtIndex:0] objectForKey:@"interest"];
        _headerView.monthlyRates.text = [NSString stringWithFormat:@"%.2f%%",[[[_returnMonthsArray objectAtIndex:0] objectForKey:@"interest"] floatValue] * 100];
        return;
    } else {
        _headerView.typeMonthStutas.text = @"费率";
    }
    self.returnMonth = @"1";
    FBAudioTrack *slider=[[FBAudioTrack alloc]init];
    slider.frame=CGRectMake(51, 45, KWidth - 102, 30);
    slider.minimumValue = 0;
    slider.maximumValue = number - 1;
    [slider setThumbImage:[Comment OriginImage:[Comment imageWithColor:[UIColor redColor]] scaleToSize:CGSizeMake(4.5,4.5)] forState:UIControlStateNormal];
    slider.value = 0;
    slider.tag = 10000;
    slider.tintColor = [UIColor redColor];

    [self.headerView.scrollView addSubview:slider];
    for (int i = 0; i < number; i++) {
        NSString *string;
    
        string = [NSString stringWithFormat:@"%@",[[_returnMonthsArray objectAtIndex:i] objectForKey:@"period"]];
        _headerView.button.enabled = NO;
        _headerView.termT.text = @"月度";
        UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(51 + i *(KWidth - 102)/number, 73, (KWidth - 102)/number, 18)];
        label.center = CGPointMake(51 + i *(KWidth - 102)/(number - 1), label.center.y);
        label.textAlignment = NSTextAlignmentCenter;
        label.text = string;
        [self.headerView.scrollView addSubview:label];
        UIImageView *imageView = [[UIImageView alloc] initWithFrame:CGRectMake(0, 0, 10, 10)];
        imageView.backgroundColor = [Comment getColor:@"4999F5"];
        imageView.layer.cornerRadius = 5;
        imageView.layer.masksToBounds = YES;
        imageView.center = CGPointMake(51 + i *(KWidth - 102)/(number - 1), 60);
        imageView.tag = i + 10;
        [self.headerView.scrollView addSubview:imageView];

    }
    UISlider *bSlider=[[UISlider alloc]init];
    bSlider.frame=CGRectMake(36, 45, KWidth - 72, 30);
    bSlider.minimumValue = 0;
    bSlider.maximumValue = number - 1;
    bSlider.tintColor = [UIColor clearColor];
    bSlider.value = 0;
    [bSlider addTarget:self action:@selector(getLastValue:) forControlEvents:UIControlEventTouchUpInside];
    [bSlider addTarget:self action:@selector(getValue:) forControlEvents:UIControlEventValueChanged];

    [self.headerView.scrollView addSubview:bSlider];
    [bSlider setThumbImage:[UIImage imageNamed:@"选择控键"] forState:UIControlStateNormal];
    [bSlider setMaximumTrackImage:[Comment OriginImage:[Comment imageWithColor:[UIColor clearColor]] scaleToSize:CGSizeMake(4,4)] forState:UIControlStateNormal];
    _headerView.frame = CGRectMake(0,0,KWidth, 434 + rect.size.height);
    _headerView.monthField.enabled = NO;
    _headerView.moneyField.delegate = self;
    tableHeaderView.frame = CGRectMake(0,0,KWidth, 434 + rect.size.height);
    [tableHeaderView addSubview:_headerView];
    self.table.tableHeaderView = tableHeaderView;

}


#warning selectpaytype

- (void)selectPaytype {
    NSString *cancelButtonTitle = NSLocalizedString(@"月度", nil);
    NSString *otherButtonTitle = NSLocalizedString(@"半年度", nil);
    NSString *anotherButtonTitle = NSLocalizedString(@"年度", nil);
    
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"选择还款方式" message:nil preferredStyle:UIAlertControllerStyleAlert];
    
    // Create the actions.
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        _headerView.typePayStutas.text = @"每月还款（元）";
        _headerView.termT.text = @"月度";
        _headerView.monthlyRates.text = [NSString stringWithFormat:@"%.2f%%",[[[_returnMonthsArray objectAtIndex:0] objectForKey:@"interest"] floatValue] * 100];
        self.interest = [[_returnMonthsArray objectAtIndex:0] objectForKey:@"interest"];
        self.returnMonth = @"1";
        _returnPerMonth = [NSString stringWithFormat:@"%.2f",([self.amount floatValue] *[_interest floatValue]* 10000 * 12 + 10000*[_amount floatValue])/(12 / [_returnMonth integerValue])];
        _headerView.monthlyPayment.text = _returnPerMonth;

    }];
    UIAlertAction *anotherAction = [UIAlertAction actionWithTitle:anotherButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        _headerView.termT.text = @"年度";
        _headerView.typePayStutas.text = @"年还款（元）";
        _headerView.monthlyRates.text = [NSString stringWithFormat:@"%.2f%%",[[[_returnMonthsArray objectAtIndex:2] objectForKey:@"interest"] floatValue] * 100];
        self.interest = [[_returnMonthsArray objectAtIndex:2] objectForKey:@"interest"];
        self.returnMonth = @"12";
          
        _returnPerMonth = [NSString stringWithFormat:@"%.2f",([self.amount floatValue] *[_interest floatValue]* 10000 * 12 + 10000*[_amount floatValue])/(12 / [_returnMonth integerValue])];
        _headerView.monthlyPayment.text = _returnPerMonth;
    }];
    UIAlertAction *otherAction = [UIAlertAction actionWithTitle:otherButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        _headerView.typePayStutas.text = @"半年还款（元）";
        _headerView.termT.text = @"半年度";
        _headerView.monthlyRates.text = [NSString stringWithFormat:@"%.2f%%",[[[_returnMonthsArray objectAtIndex:1] objectForKey:@"interest"] floatValue] * 100];
        self.interest = [[_returnMonthsArray objectAtIndex:1] objectForKey:@"interest"];
        self.returnMonth = @"6";
        _returnPerMonth = [NSString stringWithFormat:@"%.2f",([self.amount floatValue] *[_interest floatValue]* 10000 * 12 + 10000*[_amount floatValue])/(12 / [_returnMonth integerValue])];
        _headerView.monthlyPayment.text = _returnPerMonth;
    }];
    
    [alertController addAction:cancelAction];
    [alertController addAction:otherAction];
    [alertController addAction:anotherAction];

    //弹出提示框；
    [self presentViewController:alertController animated:true completion:nil];
}
- (void)createrAlertMessage {
    //初始化提示框；
    NSString *cancelButtonTitle = NSLocalizedString(@"    6个月    ", nil);
    NSString *otherButtonTitle = NSLocalizedString(@"    12个月    ", nil);
    
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"选择期限" message:nil preferredStyle:UIAlertControllerStyleAlert];
    
    // Create the actions.
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        _otherHeaderView.monthField.text = @"6个月";
        _period = @"6";
        self.otherHeaderView.monthlyPayment.text = [NSString stringWithFormat:@"%.2f",[self.amount floatValue] / [_period integerValue] * 10000];
        self.returnPerMonth = self.otherHeaderView.monthlyPayment.text;

    }];
    
    UIAlertAction *otherAction = [UIAlertAction actionWithTitle:otherButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        _otherHeaderView.monthField.text = @"12个月";
        _period = @"12";
        self.otherHeaderView.monthlyPayment.text = [NSString stringWithFormat:@"%.2f",[self.amount floatValue] / [_period integerValue] * 10000];
        self.returnPerMonth = self.otherHeaderView.monthlyPayment.text;
    }];
    
    [alertController addAction:cancelAction];
    [alertController addAction:otherAction];
    
    //弹出提示框；
    [self presentViewController:alertController animated:true completion:nil];
}

- (void)getLastValue:(id)sender{
    UISlider *slider = (UISlider *)sender;
//    NSInteger number = [[NSString stringWithFormat:@"%0.f",slider.value * 10] integerValue];
    NSInteger d;
    d = [[NSString stringWithFormat:@"%0.f",slider.value] integerValue];
    [slider setValue:d animated:YES];
    for (int i = 0; i < slider.maximumValue; i++) {
        UIImageView *imageView = (UIImageView *)[self.view viewWithTag:i +10];
        if (i < d) {
            imageView.backgroundColor = [UIColor whiteColor];
        } else {
            imageView.backgroundColor = [Comment getColor:@"4999F5"];        }
    }
    UISlider *downSlider = (UISlider *)[self.headerView.scrollView viewWithTag:10000];
    [downSlider setValue:slider.value animated:YES];
    _period = [NSString stringWithFormat:@"%@",[[_returnMonthsArray objectAtIndex:d] objectForKey:@"period"]];
    self.headerView.monthField.text = [NSString stringWithFormat:@"%@个月",_period];
    self.headerView.monthlyRates.text =  _headerView.monthlyRates.text = [NSString stringWithFormat:@"%.2f%%",[[[_returnMonthsArray objectAtIndex:d] objectForKey:@"interest"] floatValue] * 100];
    self.interest = [[_returnMonthsArray objectAtIndex:d] objectForKey:@"interest"];
    
    
    
    if ([_period integerValue] != 0 && [_amount floatValue] != 0) {
        _returnPerMonth = [NSString stringWithFormat:@"%.2f",[self.amount floatValue] / [_period integerValue] * 10000];
        
        _returnPerMonth = [NSString stringWithFormat:@"%.2f",[self.amount floatValue]* (1 + [_interest floatValue]) / [_period integerValue] * 10000];
        
    }
    _headerView.monthlyPayment.text = _returnPerMonth;
}
- (void)getValue:(id)sender {
    UISlider *slider = (UISlider *)sender;
    UISlider *downSlider = (UISlider *)[self.headerView.scrollView viewWithTag:10000];
    [downSlider setValue:slider.value animated:YES];
    NSInteger d;
    d = [[NSString stringWithFormat:@"%0.f",slider.value] integerValue];
    for (int i = 0; i < slider.maximumValue; i++) {
        UIImageView *imageView = (UIImageView *)[self.view viewWithTag:i +10];
        if (i < d) {
            imageView.backgroundColor = [UIColor whiteColor];
        } else {
            imageView.backgroundColor = [Comment getColor:@"4999F5"];
        }
    }
    
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [_tableArray count];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    if (indexPath.row == 1 || indexPath.row == 3) {
        static NSString *CellIdentifier = @"LastTableViewCell";
        LastTableViewCell *cell = (LastTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil)
        {
            cell= (LastTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"LastTableViewCell" owner:self options:nil]  lastObject];
        }
//        if ([self.bankName isEqualToString:@"江苏银行"]) {
            if (indexPath.row == 1) {
                if ([@"yes" isEqualToString:[_materialHiddenDic objectForKey:@"material"]]) {
                    cell.detail.hidden = YES;
                    cell.pic.image = [UIImage imageNamed:@"向下箭头"];
                } else {
                    cell.pic.image = [UIImage imageNamed:@"向上箭头"];
                }
                cell.detail.text = [[_materialArray objectAtIndex:0] objectForKey:@"material"];
            } else {
                if ([@"yes" isEqualToString:[_materialHiddenDic objectForKey:@"condition"]]) {
                    cell.detail.hidden = YES;
                    cell.pic.image = [UIImage imageNamed:@"向下箭头"];
                } else {
                    cell.pic.image = [UIImage imageNamed:@"向上箭头"];
                }
                cell.detail.text = [[_materialArray objectAtIndex:0] objectForKey:@"condition"];
            }
//        } else {
//            if (indexPath.row == 1) {
//                if ([@"yes" isEqualToString:[_materialHiddenDic objectForKey:@"material"]]) {
//                    cell.detail.hidden = YES;
//                }
//                cell.detail.text = [[_materialArray objectAtIndex:1] objectForKey:@"material"];
//            } else {
//                if ([@"yes" isEqualToString:[_materialHiddenDic objectForKey:@"condition"]]) {
//                    cell.detail.hidden = YES;
//                }
//                cell.detail.text = [[_materialArray objectAtIndex:1] objectForKey:@"condition"];
//            }
//        }
        cell.title.text = [[_tableArray objectAtIndex:indexPath.row] firstObject];
        NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:[UIFont systemFontOfSize:14],NSFontAttributeName, nil];
        CGRect rect = [cell.detail.text boundingRectWithSize:CGSizeMake([[UIScreen mainScreen] bounds].size.width - 72, 10000) options:(NSStringDrawingUsesLineFragmentOrigin | NSStringDrawingUsesFontLeading) attributes:dic context:nil];
        _detailH = rect.size.height;
        return cell;
    }
    static NSString *CellIdentifier = @"UITableViewCell";
    UITableViewCell *cell = (UITableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil)
    {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier];
    }
    cell.backgroundColor = [UIColor groupTableViewBackgroundColor];
    return cell;
}
- (void)showRates: (UIButton *)button {
    _downH = 70;
    _resultVHidden = NO;
    [_table reloadData];
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row  == 0 || indexPath.row == 2) {
        return 6;
    }
    if (indexPath.row == 1) {
        if ([@"yes" isEqualToString:[_materialHiddenDic objectForKey:@"material"]]) {
            return 44;
        }
        return 54 + _detailH;
    }
    if (indexPath.row == 3) {
        if ([@"yes" isEqualToString:[_materialHiddenDic objectForKey:@"condition"]]) {
            return 44;
        }
        return 54 + _detailH;
    }
    return 44;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 1) {
        if ([@"yes" isEqualToString:[_materialHiddenDic objectForKey:@"material"]]) {
            [_materialHiddenDic setObject:@"no" forKey:@"material"];
        } else {
            [_materialHiddenDic setObject:@"yes" forKey:@"material"];
        }
        [_table reloadData];
    }
    if (indexPath.row == 3) {
        if ([@"yes" isEqualToString:[_materialHiddenDic objectForKey:@"condition"]]) {
            [_materialHiddenDic setObject:@"no" forKey:@"condition"];
        } else {
            [_materialHiddenDic setObject:@"yes" forKey:@"condition"];
        }
        [_table reloadData];
    }
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
#warning applicationAction
- (IBAction)applicationAction:(id)sender {
    if ([_amount floatValue] >= [_minAmount floatValue] && [_period integerValue] > 0 &&[_amount floatValue] <=
        [_maxAmount floatValue]) {
        
    } else {
         self.alert = [UIAlertController alertControllerWithTitle:@"请输入正确金额或期限" message:nil preferredStyle:  UIAlertControllerStyleAlert];
        
        //弹出提示框；
        [self presentViewController:_alert animated:true completion:nil];
        [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(dismissViewController) userInfo:nil repeats:NO];
        return;
    }
    if ([@"yes" isEqualToString:[[NSUserDefaults standardUserDefaults] objectForKey:@"islogin"]]) {
        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
        ApplicationMaterialsViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"ApplicationMaterialsViewController"];
        dev.bankID = self.bankID;
        dev.bankName = self.bankName;
        dev.storeId = self.storeId;
        if (_isZore) {
            dev.amount = self.otherHeaderView.moneyField.text;
            dev.period = self.period;
            dev.returnType = self.returnType;
            dev.returnMonth = self.returnMonth;
            dev.isZore = true;
        } else {
            dev.amount = self.headerView.moneyField.text;
            dev.period = self.period;
            dev.returnType = self.returnType;
            dev.returnMonth = self.returnMonth;
            dev.isZore = false;
        }
        dev.hasBankPay = _hasBankPay;
        dev.bankName = self.bankName;
        dev.interest = self.interest;
        dev.returnPerMonth = self.returnPerMonth;
        [self.navigationController pushViewController:dev animated:YES];
    } else {
        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Login" bundle:nil];
        LoginViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"LoginViewController"];
        [self.navigationController pushViewController:dev animated:YES];
    }
}
- (void)dismissViewController {
    [_alert dismissViewControllerAnimated:YES completion:nil];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@"nav"] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleBlackTranslucent;
    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    [self.navigationController.navigationBar setTintColor:[UIColor whiteColor]];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    if (_isZore) {
        navL.text = [NSString stringWithFormat:@"%@零利息家居贷",self.bankName];
    } else {
        navL.text = [NSString stringWithFormat:@"%@低利息家居贷",self.bankName];
    }
    navL.textColor = [UIColor whiteColor];
    navL.font = [UIFont systemFontOfSize:16];
    navL.textAlignment = NSTextAlignmentCenter;
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    [self.navigationController.navigationBar setTintColor:[Comment getColor:@"4999F5"]];
}



- (void) registerForKeyboardNotifications
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWasShown:) name:UIKeyboardDidShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter]  addObserver:self selector:@selector(keyboardWasHidden:) name:UIKeyboardDidHideNotification object:nil];
}

- (void) keyboardWasShown:(NSNotification *) notif {
    _doneView.hidden = NO;
    NSDictionary *info = [notif userInfo];
    NSValue *value = [info objectForKey:UIKeyboardFrameBeginUserInfoKey];
    CGSize keyboardSize = [value CGRectValue].size;
    
    NSLog(@"keyBoard:%f", keyboardSize.height);
}
- (void) keyboardWasHidden:(NSNotification *) notif {
    _doneView.hidden = YES;
    if (_isZore) {
        _amount =[NSString stringWithFormat:@"%.2f",[self.otherHeaderView.moneyField.text floatValue]*1.0];
        self.otherHeaderView.totalRepayment.text = _amount;
    } else {
        if ([_returnType isEqualToString:@"1"]) {
            _amount = [NSString stringWithFormat:@"%.2f",[self.headerView.moneyField.text floatValue]*1.0];
            self.headerView.totalRepayment.text = _amount;
        } else {
            _amount = [NSString stringWithFormat:@"%.2f",[self.headerView.moneyField.text floatValue]*1.0];
            self.headerView.totalRepayment.text = _amount;
        }

    }
    
    if (_isZore) {
        if ([_period integerValue] == 0) {
            self.otherHeaderView.monthlyPayment.text = @"0";
        } else {
            self.otherHeaderView.monthlyPayment.text = [NSString stringWithFormat:@"%.2f",[self.amount floatValue] / [_period integerValue] * 10000];
        }
        self.returnPerMonth = self.otherHeaderView.monthlyPayment.text;
    } else {
        if ([_period integerValue] == 0) {
            self.headerView.monthlyPayment.text = @"0";
        } else {
//            self.headerView.monthlyPayment.text = [NSString stringWithFormat:@"%.2f",[self.amount floatValue] / [_period integerValue] * 10000];
            if ([_returnType isEqualToString:@"2"]) {
                CGFloat raye = [_interest floatValue];
                if (raye != 0) {
                    self.headerView.monthlyPayment.text = [NSString stringWithFormat:@"%.2f",([self.amount floatValue] *[_interest floatValue]* 10000 * 12 + 10000 * [_amount floatValue])/(12 / [_returnMonth integerValue])];
                    self.headerView.totalRepayment.text = _amount;
                }
            } else {
                CGFloat raye = [_interest floatValue];
                if (raye != 0) {
                    self.headerView.monthlyPayment.text = [NSString stringWithFormat:@"%.2f",(raye + 1)* [_amount floatValue]  / [_period integerValue]*10000];
                }
            }
        }
        self.returnPerMonth = self.headerView.monthlyPayment.text;
    }
    NSDictionary *info = [notif userInfo];
    NSValue *value = [info objectForKey:UIKeyboardFrameBeginUserInfoKey];
    CGSize keyboardSize = [value CGRectValue].size;
    NSLog(@"keyboardWasHidden keyBoard:%f", keyboardSize.height);
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [self.headerView.moneyField resignFirstResponder];
    [self.otherHeaderView.moneyField resignFirstResponder];
    return NO;
}
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string {
    NSArray *array = [NSArray arrayWithObjects:@"0",@"1",@"2",@"3",@"4",@"5",@"6",@"7",@"8",@"9",@".",@"", nil];
    for (NSString *str in array) {
        if ([string isEqualToString:str]) {
            return YES;
        }
    }
    UIAlertView* alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"请输入数字" delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil];
    [alert show];
    return NO;
}
@end
