//
//  ApplicationStatusViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/18.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "ApplicationStatusViewController.h"
#import "AppDelegate.h"
@interface ApplicationStatusViewController ()<UITableViewDataSource, UITableViewDelegate>
@property (strong, nonatomic) IBOutlet UILabel *returnMoneyType;
@property (strong, nonatomic) IBOutlet UILabel *bank;
@property (strong, nonatomic) IBOutlet UILabel *money;
@property (strong, nonatomic) IBOutlet UILabel *term;
@property (strong, nonatomic) IBOutlet UILabel *interest;
@property (strong, nonatomic) IBOutlet UILabel *repayment;
@property (strong, nonatomic) IBOutlet UILabel *status;
@property (strong, nonatomic) IBOutlet UILabel *time;
@property (strong, nonatomic) IBOutlet UILabel *shopAddress;
@property (strong, nonatomic) IBOutlet UIImageView *result;
@property (strong, nonatomic) NSMutableArray *resultArray;
@property (strong, nonatomic) IBOutlet UILabel *fukL;
@property (strong, nonatomic) IBOutlet UIImageView *statusPic;
@property (strong, nonatomic) IBOutlet UILabel *fukXY;
@property (strong, nonatomic) IBOutlet UILabel *fukXB;

@end

@implementation ApplicationStatusViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.resultArray = [NSMutableArray array];
    
    NSDate *  senddate=[NSDate date];
    NSDateFormatter  *formatter=[[NSDateFormatter alloc] init];
    [formatter setDateStyle:NSDateFormatterMediumStyle];
    [formatter setTimeStyle:NSDateFormatterShortStyle];
    [formatter setDateFormat:@"yyyy-MM-dd hh:mm"];

    NSString *nowtimeStr = [formatter stringFromDate:senddate];
    if (self.dateformatter.length == 0) {
        self.dateformatter = nowtimeStr;
    }
    
    _time.text = _dateformatter;
//    AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
//    if (_store.length == 0) {
//        _store = myDelegate.shop;
//    }
//    if (_storeAddress.length == 0) {
//        _shopAddress.text = [NSString stringWithFormat:@"商场地址：%@",myDelegate.shopAddress];
//        [_resultArray addObject:[NSString stringWithFormat:@"商场地址：%@",myDelegate.shopAddress]];
//    } else {
//        _shopAddress.text = [NSString stringWithFormat:@"商场地址：%@",self.storeAddress];
//        [_resultArray addObject:[NSString stringWithFormat:@"商场地址：%@",self.storeAddress]];
//    }
    [_resultArray addObject:@"客服电话：400-8213213"];
    if (_isZore) {
        self.status.text = [NSString stringWithFormat:@"%@零利息家居贷",_store];
    } else {
        self.status.text = [NSString stringWithFormat:@"%@低利息家居贷",_store];
    }
    self.money.text = [NSString stringWithFormat:@"%@",self.amount];
    self.term.text = [NSString stringWithFormat:@"%@",self.period];
    self.repayment.text = self.returnPerMonth;
    if ([_returnMonth isEqualToString:@"1"]) {
        self.interest.text = [NSString stringWithFormat:@"%.2f",([_returnPerMonth floatValue] * [_period integerValue] / 10000) - [_amount floatValue]];
    } else {
        switch ([_returnMonth integerValue]) {
            case 1:
                _returnMoneyType.text = @"每月还款：（元）";
                break;
            case 6:
                _returnMoneyType.text = @"半年还款：（元）";
                break;
            case 12:
                _returnMoneyType.text = @"年度还款：（元）";
                break;
                
            default:
                break;
        }        self.interest.text = [NSString stringWithFormat:@"%.2f",[_returnPerMonth floatValue] * [_period integerValue] / 10000/[_returnMonth integerValue] - [_amount floatValue]];
    }
    self.bank.text = [NSString stringWithFormat:@"合作金融机构：%@",self.bankName];
    if (_isNH) {
        switch (_appStatus) {
            case 0:
                _result.image = [UIImage imageNamed:@"结果1"];
                [_resultArray addObject:@"结果1"];
                self.fukL.hidden = YES;
                self.fukXY.hidden = YES;
                self.statusPic.image = [UIImage imageNamed:@"失败"];
                self.fukXB.text = @"付款失败！";
                break;
            case 1:
                _result.image = [UIImage imageNamed:@"结果2"];
                self.fukXB.hidden = YES;
                self.statusPic.image = [UIImage imageNamed:@"支付成功"];
                [_resultArray addObject:@"结果2"];
                break;
                
            default:
                _result.image = [UIImage imageNamed:@"结果0"];
                self.fukL.hidden = YES;
                self.fukXY.hidden = YES;
                self.statusPic.image = [UIImage imageNamed:@"支付成功"];
                self.fukXB.text = @"提交成功！";
                [_resultArray addObject:@"结果0"];
                break;
        }
    } else {
    switch (_appStatus) {
        case 1:
            _result.image = [UIImage imageNamed:@"结果1"];
            [_resultArray addObject:@"结果1"];
            self.fukL.hidden = YES;
            self.fukXY.hidden = YES;
            self.statusPic.image = [UIImage imageNamed:@"失败"];
            self.fukXB.text = @"付款失败！";
            break;
        case 2:
            _result.image = [UIImage imageNamed:@"结果2"];
            self.fukXB.hidden = YES;
            self.statusPic.image = [UIImage imageNamed:@"支付成功"];
            [_resultArray addObject:@"结果2"];
            break;
            
        default:
            _result.image = [UIImage imageNamed:@"结果0"];
            self.fukL.hidden = YES;
            self.fukXY.hidden = YES;
            self.statusPic.image = [UIImage imageNamed:@"支付成功"];
            self.fukXB.text = @"提交成功！";
            [_resultArray addObject:@"结果0"];
            break;
    }}
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 2;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellName = @"cell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellName];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellName];
    }
    
    UIView *upLine = [UIView new];
    if (indexPath.row == 1) {
        upLine.frame = CGRectMake(0, 89, KWidth, 1);
        UIImageView *image = [[UIImageView alloc] initWithFrame:CGRectMake(40, 5, KWidth - 80, 79)];
        image.image = [UIImage imageNamed:[_resultArray objectAtIndex:indexPath.row]];
        image.contentMode = UIViewContentModeScaleAspectFit;
        [cell addSubview:image];
    } else {
        upLine.frame = CGRectMake(0, 44, KWidth, 1);
        UILabel *lable = [[UILabel alloc] initWithFrame:CGRectMake(40, 0, KWidth - 80, 44)];
        lable.font = [UIFont systemFontOfSize:14];
        lable.text = [_resultArray objectAtIndex:indexPath.row];
        [cell addSubview:lable];
    }
    upLine.backgroundColor = [UIColor lightGrayColor];
    [cell addSubview:upLine];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 1) {
        return 90;
    }
    return 45;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
 */
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
//    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@"nav"] forBarMetrics:UIBarMetricsDefault];
//    self.navigationController.navigationBar.barStyle = UIBarStyleBlackTranslucent;
//    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    [self.navigationController.navigationBar setTintColor:[Comment getColor:@"4999F5"]];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    navL.text = @"申请结果";
//    navL.textColor = [UIColor whiteColor];
    navL.textAlignment = NSTextAlignmentCenter;
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithImage:[UIImage imageNamed:@"删除图标"] style:UIBarButtonItemStylePlain target:self action:@selector(backRoot:)];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
//    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
//    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
//    [self.navigationController.navigationBar setTintColor:[Comment getColor:@"4999F5"]];
    
}
- (IBAction)backRoot:(id)sender {
    [self.navigationController popToRootViewControllerAnimated:YES];
}

@end
