//
//  ApplicationMaterialsViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/18.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "ApplicationMaterialsViewController.h"
#import "ApplicationStatusViewController.h"
#import "ApplicationMaterialsFirstTableViewCell.h"
#import "ApplicationMaterialsForthTableViewCell.h"
#import "ApplicationMaterialsLastTableViewCell.h"
#import "ApplicationMaterialsSecondTableViewCell.h"
#import "ApplicationMaterialsThirdTableViewCell.h"
#import "AFNetworking.h"
#import "AppDelegate.h"
#import "WebViewController.h"

@interface ApplicationMaterialsViewController ()<UITableViewDataSource, UITableViewDelegate,UITextFieldDelegate>
@property (strong, nonatomic) IBOutlet UIButton *button;
@property (nonatomic) BOOL isAction;
@property (strong, nonatomic) IBOutlet UITableView *table;
@property (strong, nonatomic) NSMutableArray *tableArray;
@property (nonatomic, strong) NSMutableArray *occupationArray;
@property (nonatomic, strong) NSMutableDictionary *valueDic;
@property (nonatomic, strong)UIAlertController *alertController;
@property (strong, nonatomic) UIView *doneView;
@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;
@property (strong, nonatomic) IBOutlet UIButton *kuaiSuButton;

@end

@implementation ApplicationMaterialsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    if (!_hasBankPay) {
        self.kuaiSuButton.enabled = NO;
    } else {
        self.kuaiSuButton.enabled = YES;
    }
    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    if ([[NSUserDefaults standardUserDefaults] objectForKey:@"valueDic"]) {
        NSDictionary *tempDic = [[NSUserDefaults standardUserDefaults] objectForKey:@"valueDic"];
        self.valueDic = [NSMutableDictionary dictionaryWithObjects:tempDic.allValues forKeys:tempDic.allKeys];
    } else {
        NSString *str = [[NSUserDefaults standardUserDefaults] objectForKey:@"userId"];
        AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
        self.storeId = myDelegate.shopId;
        self.valueDic = [NSMutableDictionary dictionaryWithObjectsAndKeys:str,@"userId",[NSNumber numberWithBool:_isZore],@"isZero",[NSNumber numberWithInteger:[_storeId integerValue]],@"storeId",@"",@"name",@"",@"idNumber",@"",@"companyType",[NSNumber numberWithFloat:0],@"income",@false,@"hasSocialSec",@false,@"hasAccumulation",@false,@"hasHouse",@false,@"hasCar",@false,@"hasCreditCard",[NSNumber numberWithFloat:[_amount floatValue]],@"amount",[NSNumber numberWithInteger:[_period integerValue]],@"period",[NSNumber numberWithFloat:[_interest floatValue]],@"interest",[NSNumber numberWithFloat:[_returnPerMonth floatValue]],@"returnPerMonth",[NSNumber numberWithInteger:[_bankID integerValue]],@"bankId",[NSNumber numberWithInteger:[_returnType integerValue]],@"returnType",[NSNumber numberWithInteger:[_returnMonth integerValue]],@"returnMonth", nil];
    }
    self.button.layer.cornerRadius = 2;
    self.button.layer.masksToBounds = YES;
    self.occupationArray = [NSMutableArray arrayWithObjects:@"请选择",@"",@"", nil];
    self.tableArray = [NSMutableArray arrayWithObjects:@[@"姓名"],@[@"身份证"],@[@"就职公司类型"],@[@"是否有本地社保"],@[@"是否有本地公积金"],@[@"是否有房产"],@[@"是否有私家车"],@[@"是否有信用卡"], nil];
    
    // Do any additional setup after loading the view.
    [self registerForKeyboardNotifications];
    self.doneView = [UIView new];
    _doneView.backgroundColor = [Comment getColor:@"D0D4DA"];
    _doneView.hidden = YES;
    _doneView.frame = CGRectMake(0, KHeight - 246, KWidth, 30);
    [self.view addSubview:_doneView];
    UIView *upLine = [[UIView alloc] initWithFrame:CGRectMake(0, 0, KWidth, 1)];
    upLine.backgroundColor = [Comment getColor:@"CECFD0"];
    [_doneView addSubview:upLine];
    UIView *downLine = [[UIView alloc] initWithFrame:CGRectMake(0, 29, KWidth, 1)];
    downLine.backgroundColor = [UIColor lightGrayColor];
    [_doneView addSubview:downLine];
    UIButton *doneButton = [[UIButton alloc] initWithFrame:CGRectMake(KWidth - 50, 5, 40, 20)];
//    doneButton.layer.cornerRadius = 2;
//    doneButton.layer.masksToBounds = YES;
//    doneButton.layer.borderColor = [[UIColor blackColor] CGColor];
    [doneButton setTitleColor:[Comment getColor:@"007aff"] forState:UIControlStateNormal];
//    doneButton.layer.borderWidth = 0.5;
    [doneButton setTitle:@"完成" forState:UIControlStateNormal];
    [doneButton addTarget:self action:@selector(responderKeyBoard) forControlEvents:UIControlEventTouchUpInside];
    [_doneView addSubview:doneButton];
    // Do any additional setup after loading the view.
}
- (void)responderKeyBoard {
    _doneView.hidden = YES;
    UITextField *textField = (UITextField *)[self.view viewWithTag:3];
    [textField resignFirstResponder];
    
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#warning 提交
- (IBAction)showStatusVC:(id)sender {
    
    [self startRequest];
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [_tableArray count];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        static NSString *CellIdentifier = @"ApplicationMaterialsFirstTableViewCell";
        ApplicationMaterialsFirstTableViewCell *cell = (ApplicationMaterialsFirstTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil)
        {
            cell= (ApplicationMaterialsFirstTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"ApplicationMaterialsFirstTableViewCell" owner:self options:nil]  lastObject];
        }
        cell.name.tag = 1;
        cell.name.text = [_valueDic objectForKey:@"name"];
        cell.mark.text = [NSString stringWithFormat:@"%ld",indexPath.row + 1];
        return cell;
    }
    if (indexPath.row == 1) {
        static NSString *CellIdentifier = @"ApplicationMaterialsSecondTableViewCell";
        ApplicationMaterialsSecondTableViewCell *cell = (ApplicationMaterialsSecondTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil)
        {
            cell= (ApplicationMaterialsSecondTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"ApplicationMaterialsSecondTableViewCell" owner:self options:nil]  lastObject];
        }
        cell.textField.text = [_valueDic objectForKey:@"idNumber"];
        cell.textField.tag = 2;
        cell.textField.delegate = self;
        cell.mark.text = [NSString stringWithFormat:@"%ld",indexPath.row + 1];
        return cell;
    }
    if (indexPath.row == 2) {
        static NSString *CellIdentifier = @"ApplicationMaterialsThirdTableViewCell";
        ApplicationMaterialsThirdTableViewCell *cell = (ApplicationMaterialsThirdTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil)
        {
            cell= (ApplicationMaterialsThirdTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"ApplicationMaterialsThirdTableViewCell" owner:self options:nil]  lastObject];
        }
        [cell.button setTitle:[_occupationArray firstObject] forState:UIControlStateNormal];
        cell.title.text = [_occupationArray objectAtIndex:1];
        cell.unit.text = [_occupationArray objectAtIndex:2];
        [cell.button addTarget:self action:@selector(changeHeight) forControlEvents:UIControlEventTouchUpInside];
        cell.mark.text = [NSString stringWithFormat:@"%ld",indexPath.row + 1];
        if ([@"0" isEqualToString:[NSString stringWithFormat:@"%@",[_valueDic objectForKey:@"income"]]]) {
            cell.textField.text = @"";
        } else {
            cell.textField.text = [NSString stringWithFormat:@"%@",[_valueDic objectForKey:@"income"]];
        }
        cell.textField.delegate = self;
        cell.textField.tag = 3;
        return cell;
    }

    if (indexPath.row == [_tableArray count] - 1) {
        static NSString *CellIdentifier = @"ApplicationMaterialsLastTableViewCell";
        ApplicationMaterialsLastTableViewCell *cell = (ApplicationMaterialsLastTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil)
        {
            cell= (ApplicationMaterialsLastTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"ApplicationMaterialsLastTableViewCell" owner:self options:nil]  lastObject];
        }
        if ([[_valueDic objectForKey:@"hasCreditCard"] boolValue]) {
            [cell.select setOn:YES animated:NO];
        }
        
        [cell.select addTarget:self action:@selector(getValue:) forControlEvents:UIControlEventValueChanged];
        cell.select.tag = indexPath.row + 1;
        cell.mark.text = [NSString stringWithFormat:@"%ld",indexPath.row + 1];
        return cell;
    }
    static NSString *CellIdentifier = @"ApplicationMaterialsForthTableViewCell";
    ApplicationMaterialsForthTableViewCell *cell = (ApplicationMaterialsForthTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil)
    {
        cell= (ApplicationMaterialsForthTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"ApplicationMaterialsForthTableViewCell" owner:self options:nil]  lastObject];
    }
    switch (indexPath.row) {
        case 3:
            if ([[_valueDic objectForKey:@"hasSocialSec"] boolValue]) {
                [cell.select setOn:YES animated:NO];
            }
            break;
        case 4:
            if ([[_valueDic objectForKey:@"hasAccumulation"] boolValue]) {
                [cell.select setOn:YES animated:NO];
            }
            
            break;
        case 5:
            if ([[_valueDic objectForKey:@"hasHouse"] boolValue]) {
                [cell.select setOn:YES animated:NO];
            }
            
            break;
        case 6:
            if ([[_valueDic objectForKey:@"hasCar"] boolValue]) {
                [cell.select setOn:YES animated:NO];
            }
            
            break;
        default:
            break;
    }

    [cell.select addTarget:self action:@selector(getValue:) forControlEvents:UIControlEventTouchUpInside];
    cell.select.tag = indexPath.row + 1;
    cell.mark.text = [NSString stringWithFormat:@"%ld",indexPath.row + 1];
    cell.title.text = [[_tableArray objectAtIndex:indexPath.row] firstObject];
    return cell;
}

- (void)createrAlertMessage: (NSString *)message {
    //初始化提示框；
    NSString *cancelButtonTitle = NSLocalizedString(@"自雇人员（企业主/工商户/自由职业）", nil);
    NSString *otherButtonTitle = NSLocalizedString(@"非自雇人员（上班族/企事业单位/公务员）", nil);
    
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:message message:nil preferredStyle:UIAlertControllerStyleAlert];
    
    // Create the actions.
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        [_occupationArray removeAllObjects];
        [_occupationArray addObjectsFromArray:@[@"自雇人员",@"经营流水",@"万元"]];
        [_valueDic setObject:@"自雇人员" forKey:@"companyType"];
        [_table reloadData];
    }];
    
    UIAlertAction *otherAction = [UIAlertAction actionWithTitle:otherButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        [_occupationArray removeAllObjects];
        [_occupationArray addObjectsFromArray:@[@"非自雇人员",@"月薪",@"元"]];
        [_valueDic setObject:@"非自雇人员" forKey:@"companyType"];
        [_table reloadData];
    }];
    
    [alertController addAction:cancelAction];
    [alertController addAction:otherAction];
    
    //弹出提示框；
    [self presentViewController:alertController animated:true completion:nil];
//    [NSTimer scheduledTimerWithTimeInterval:2 target:alert selector:@selector(dismissViewControllerAnimated:completion:) userInfo:nil repeats:NO];
}
- (void) changeHeight {
    if (_isAction) {
        
    } else {
        _isAction = YES;
    }
    UITextField *name = (UITextField *)[self.view viewWithTag:1];
    UITextField *idNumber = (UITextField *)[self.view viewWithTag:2];

    [_valueDic setObject:idNumber.text forKey:@"idNumber"];
    [_valueDic setObject:name.text forKey:@"name"];

    [self createrAlertMessage:@"就职公司类型："];
}
- (void) getValue :(UISwitch*)sender{
    BOOL reminded = sender.on;
    switch (sender.tag) {
        case 4:
            [_valueDic setObject:[NSNumber numberWithBool:reminded] forKey:@"hasSocialSec"];
            break;
        case 5:
            [_valueDic setObject:[NSNumber numberWithBool:reminded] forKey:@"hasAccumulation"];
            break;
        case 6:
            [_valueDic setObject:[NSNumber numberWithBool:reminded] forKey:@"hasHouse"];
            break;
        case 7:
            [_valueDic setObject:[NSNumber numberWithBool:reminded] forKey:@"hasCar"];
            break;
        case 8:
            [_valueDic setObject:[NSNumber numberWithBool:reminded] forKey:@"hasCreditCard"];
            break;
            
        default:
            break;
    }
    NSLog(@"%d",reminded);
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 2) {
        if (!_isAction) {
            return 45;
        }
        return 90;
    }
    return 45;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[Comment imageWithColor:[UIColor whiteColor]] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    navL.text = @"申请人资质";
    navL.textAlignment = NSTextAlignmentCenter;
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
//    UIView *newView = [[UIView alloc] initWithFrame:CGRectMake(0, -20, KWidth, 20)];
//    newView.backgroundColor = [UIColor blackColor];
//    newView.tag = 1000;
//    [self.navigationController.navigationBar addSubview:newView];
//    [[UIApplication sharedApplication] setStatusBarStyle:UIStatusBarStyleDefault];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    UIView *newView = [self.navigationController.navigationBar viewWithTag:1000];
    [newView removeFromSuperview];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
}
- (void)startRequest {
    UITextField *income = (UITextField *)[self.view viewWithTag:3];
    [_valueDic setObject:[NSNumber numberWithFloat:[income.text floatValue]] forKey:@"income"];
    UITextField *name = (UITextField *)[self.view viewWithTag:1];
    [_valueDic setObject:name.text forKey:@"name"];
    UITextField *idNumber = (UITextField *)[self.view viewWithTag:2];
    [_valueDic setObject:idNumber.text forKey:@"idNumber"];
    UITextField *textField = (UITextField *)[self.view viewWithTag:2];
    if (textField.text.length != 18) {
        UIAlertView* alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"请输入18位有效身份证号码" delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil];
        [alert show];
        return;
    }
    
    if ([(NSString *)[_valueDic objectForKey:@"name"] length] == 0 || [(NSString *)[_valueDic objectForKey:@"idNumber"] length] == 0 || [(NSString *)[_valueDic objectForKey:@"companyType"] length] == 0 || [(NSNumber *)[_valueDic objectForKey:@"income"] floatValue] == 0) {
        self.alertController = [UIAlertController alertControllerWithTitle:@"请填写完信息" message:nil preferredStyle:UIAlertControllerStyleAlert];
        [self presentViewController:_alertController animated:true completion:nil];
        [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(dismissViewController) userInfo:nil repeats:NO];
        return;
    }
    [self.activityIndicator startAnimating];

    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    
    [manager POST:APPLYURL parameters:_valueDic success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [self.activityIndicator stopAnimating];

        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
        ApplicationStatusViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"ApplicationStatusViewController"];
        dev.bankName = self.bankName;
        dev.amount = self.amount;
        dev.period = self.period;
        dev.isZore = self.isZore;
        dev.returnMonth = self.returnMonth;
        dev.returnPerMonth = self.returnPerMonth;
        
        [self.navigationController pushViewController:dev animated:YES];
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        [[NSUserDefaults standardUserDefaults] setObject:self.valueDic forKey:@"valueDic"];
        NSLog(@"%@",dic);

    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [self.activityIndicator stopAnimating];

        self.alertController = [UIAlertController alertControllerWithTitle:@"网络异常" message:nil preferredStyle:UIAlertControllerStyleAlert];
        [self presentViewController:_alertController animated:true completion:nil];
        [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(dismissViewController) userInfo:nil repeats:NO];
    }];
    
}
- (void)dismissViewController {
    [_alertController dismissViewControllerAnimated:YES completion:nil];
}
- (void) registerForKeyboardNotifications
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWasShown:) name:UIKeyboardDidShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter]  addObserver:self selector:@selector(keyboardWasHidden:) name:UIKeyboardDidHideNotification object:nil];
}

- (void) keyboardWasShown:(NSNotification *) notif {
    _doneView.hidden = NO;
    NSDictionary *info = [notif userInfo];
    NSValue *value = [info objectForKey:UIKeyboardFrameBeginUserInfoKey];
    CGSize keyboardSize = [value CGRectValue].size;
    if (keyboardSize.height != 216) {
        _doneView.hidden = YES;
    }
    
    NSLog(@"keyBoard:%f", keyboardSize.height);
}
- (void) keyboardWasHidden:(NSNotification *) notif {
    _doneView.hidden = YES;
    NSDictionary *info = [notif userInfo];
    NSValue *value = [info objectForKey:UIKeyboardFrameBeginUserInfoKey];
    CGSize keyboardSize = [value CGRectValue].size;
    NSLog(@"keyboardWasHidden keyBoard:%f", keyboardSize.height);
}
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string {
    if (textField.tag != 2) {
        return YES;
    }
    if (range.location > 17) {
        return NO;
    }
    if (range.location == 17) {
        NSArray *array = [NSArray arrayWithObjects:@"0",@"1",@"2",@"3",@"4",@"5",@"6",@"7",@"8",@"9",@"X",@"x",@"", nil];
        for (NSString *str in array) {
            if ([string isEqualToString:str]) {
                return YES;
            }
        }
        UIAlertView* alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"请输入数字或x" delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil];
        [alert show];
        return NO;
    }
    NSArray *array = [NSArray arrayWithObjects:@"0",@"1",@"2",@"3",@"4",@"5",@"6",@"7",@"8",@"9",@"", nil];
    for (NSString *str in array) {
        if ([string isEqualToString:str]) {
            return YES;
        }
    }
    UIAlertView* alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"请输入数字" delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil];
    [alert show];
    return NO;
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    UITextField *idNumber = (UITextField *)[self.view viewWithTag:2];
    [idNumber resignFirstResponder];
    return NO;
}
- (void)textFieldDidEndEditing:(UITextField *)textField {
    if (textField.tag == 2) {
        if (textField.text.length != 18) {
            UIAlertView* alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"请输入18位有效身份证号码" delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil];
            [textField resignFirstResponder];
            [alert show];
        }
    }
}
- (IBAction)payNongYeYingHang:(id)sender {
    UITextField *income = (UITextField *)[self.view viewWithTag:3];
    [_valueDic setObject:[NSNumber numberWithFloat:[income.text floatValue]] forKey:@"income"];
    UITextField *name = (UITextField *)[self.view viewWithTag:1];
    [_valueDic setObject:name.text forKey:@"name"];
    UITextField *idNumber = (UITextField *)[self.view viewWithTag:2];
    [_valueDic setObject:idNumber.text forKey:@"idNumber"];
    UITextField *textField = (UITextField *)[self.view viewWithTag:2];
    if (textField.text.length != 18) {
        UIAlertView* alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"请输入18位有效身份证号码" delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil];
        [alert show];
        return;
    }
    
    if ([(NSString *)[_valueDic objectForKey:@"name"] length] == 0 || [(NSString *)[_valueDic objectForKey:@"idNumber"] length] == 0 || [(NSString *)[_valueDic objectForKey:@"companyType"] length] == 0 || [(NSNumber *)[_valueDic objectForKey:@"income"] floatValue] == 0) {
        self.alertController = [UIAlertController alertControllerWithTitle:@"请填写完信息" message:nil preferredStyle:UIAlertControllerStyleAlert];
        [self presentViewController:_alertController animated:true completion:nil];
        [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(dismissViewController) userInfo:nil repeats:NO];
        return;
    }
    NSMutableDictionary *pamarDic = [NSMutableDictionary dictionaryWithObjects:[_valueDic allValues] forKeys:[_valueDic allKeys]];
    [pamarDic setObject:[[NSUserDefaults standardUserDefaults] objectForKey:@"userId"] forKey:@"userId"];
    [pamarDic setObject:@YES forKey:@"hasBankPay"];
    [_activityIndicator startAnimating];
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    
    [manager POST:APPLYTOPAY parameters:pamarDic success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [_activityIndicator stopAnimating];
        
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        WebViewController *web = [[WebViewController alloc] init];
        web.payUrl = [dic objectForKey:@"payUrl"];
        web.applyId = [dic objectForKey:@"applyId"];
        [self.navigationController pushViewController:web animated:YES];
        
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [_activityIndicator stopAnimating];
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"网络异常" preferredStyle:UIAlertControllerStyleAlert];
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
    }];

}
@end
