//
//  AccountsViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/14.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "AccountsViewController.h"
#import "AFNetworking.h"
#import "AccountsTableViewCell.h"
#import "LoanViewController.h"
#import "WalletViewController.h"
#import "PaymentViewController.h"
#import "AppDelegate.h"
#import "LoginViewController.h"
#import "SettingViewController.h"
#import "NHViewController.h"

@interface AccountsViewController ()<UITableViewDataSource, UITableViewDelegate,UITextFieldDelegate>
{
    NSMutableArray *dataSource;
}
@property (strong, nonatomic) IBOutlet UIButton *loginButton;
@property (strong, nonatomic) IBOutlet UITextField *textField;
@property (nonatomic, strong)NSMutableArray *tableArray;
@property (strong, nonatomic) IBOutlet UITableView *table;
@property (nonatomic, strong)UIView *doneView;
@property (nonatomic, strong) NSMutableArray *tableDicArray;
@end

@implementation AccountsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.tableDicArray = [NSMutableArray array];
    self.allMoney = @"0";
    self.loginButton.layer.cornerRadius = 4;
    self.loginButton.layer.masksToBounds = YES;
    self.tableArray = [NSMutableArray arrayWithObjects:@[@""],@[@"我的贷款",@"（查看贷款进度）"],@[@"我的钱包"],@[@"通汇卡付款"],@[@"贷款待支付订单"],@[@""],@[@"设置"], nil];
    self.navigationItem.title = @"";
    self.textField.delegate = self;
    dataSource = [[NSMutableArray alloc] initWithCapacity:10];
    // Do any additional setup after loading the view.
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [_tableArray count];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0 || indexPath.row == 5) {
        static NSString *CellIdentifier = @"UITableViewCell";
        UITableViewCell *cell = (UITableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil)
        {
            cell= [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier];
        }
        cell.backgroundColor = [UIColor clearColor];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }

    static NSString *CellIdentifier = @"AccountsTableViewCell";
    AccountsTableViewCell *cell = (AccountsTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil)
    {
        cell= (AccountsTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"AccountsTableViewCell" owner:self options:nil]  lastObject];
    }
    if (indexPath.row > 0 && indexPath.row < 5) {
        cell.pic.image = [UIImage imageNamed:[NSString stringWithFormat:@"accounts%ld",(long)indexPath.row]];
    }
    if (indexPath.row == 4 || indexPath.row == 6) {
        cell.firstView.hidden = YES;
        cell.lastView.hidden = NO;
    }
    if (indexPath.row == 6) {
        cell.pic.image = [UIImage imageNamed:[NSString stringWithFormat:@"accounts%d",5]];
    }
    cell.title.text = [[_tableArray objectAtIndex:indexPath.row] firstObject];
    if (indexPath.row == 1) {
        cell.titleL.text = [[_tableArray objectAtIndex:indexPath.row] lastObject];
        
    } else if (indexPath.row == 2) {
        cell.details.text = [NSString stringWithFormat:@"¥%@元", self.allMoney];
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;

}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        return 17.5;
    }
    if (indexPath.row == 5) {
        return 27;
    }
    if (indexPath.row == 6) {
        return 77.5;
    }
    return 58;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Accounts" bundle:nil];
    LoanViewController *loanDev = [storyboard instantiateViewControllerWithIdentifier:@"LoanViewController"];
    WalletViewController *walletDev = [storyboard instantiateViewControllerWithIdentifier:@"WalletViewController"];
    NHViewController *NHDev = [storyboard instantiateViewControllerWithIdentifier:@"NHViewController"];
    NSDictionary *dic = [[[_tableDicArray firstObject] objectForKey:@"balance"] objectForKey:@"sumByStore"];
    NSString *allMoney = [NSString stringWithFormat:@"¥%@元",_allMoney];
    walletDev.allMoney = allMoney;
    walletDev.tableDic = [NSMutableDictionary dictionaryWithObjects:dic.allValues forKeys:dic.allKeys];
    PaymentViewController *payDev = [storyboard instantiateViewControllerWithIdentifier:@"PaymentViewController"];
    SettingViewController *setDev = [storyboard instantiateViewControllerWithIdentifier:@"SettingViewController"];
    if (![@"yes" isEqualToString:[[NSUserDefaults standardUserDefaults] objectForKey:@"islogin"]]) {
        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Login" bundle:nil];
        LoginViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"LoginViewController"];
        [self.navigationController pushViewController:dev animated:YES];
        return;
    }
    switch (indexPath.row) {
        case 0:
            
            break;
        case 1:
            [self.navigationController pushViewController:loanDev animated:YES];
            break;
        case 2:
            [self.navigationController pushViewController:walletDev animated:YES];
            break;
        case 3:
            [self.navigationController pushViewController:payDev animated:YES];
            break;
        case 4:
            [self.navigationController pushViewController:NHDev animated:YES];
            break;
        case 5:
//            [self.navigationController pushViewController:setDev animated:YES];
            break;
        case 6:
            [self.navigationController pushViewController:setDev animated:YES];
            break;
        default:
            break;
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
- (IBAction)buttonAction:(id)sender {
    if ([@"yes" isEqualToString:[[NSUserDefaults standardUserDefaults] objectForKey:@"islogin"]]) {
        return;
    }
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Login" bundle:nil];
    LoginViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"LoginViewController"];
    [self.navigationController pushViewController:dev animated:YES];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (void)viewWillAppear:(BOOL)animated {
    if ([@"yes" isEqualToString:[[NSUserDefaults standardUserDefaults] objectForKey:@"islogin"]]) {
        [self startRequest];
    } else {
        _allMoney = @"0";
        [_table reloadData];
    }

    [super viewWillAppear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@"nav"] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleBlackTranslucent;
    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
    if ([@"yes" isEqualToString:[[NSUserDefaults standardUserDefaults] objectForKey:@"islogin"]]) {
        [_loginButton setTitle:[[NSUserDefaults standardUserDefaults] objectForKey:@"phoneNum"] forState:UIControlStateNormal];
    } else {
        [_loginButton setTitle:@"点击登录>>" forState:UIControlStateNormal];
    }
    [self.navigationController.navigationBar setTintColor:[Comment getColor:@"4999F5"]];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
}
- (void) registerForKeyboardNotifications
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWasShown:) name:UIKeyboardDidShowNotification object:nil];
}

- (void) keyboardWasShown:(NSNotification *) notif {
    AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
    for (int i = 1; i < 10; i++) {
        UIView *view = [myDelegate.window viewWithTag:10000 + i];
        view.hidden = NO;
        
    }
    _doneView.hidden = NO;
    NSDictionary *info = [notif userInfo];
    NSValue *value = [info objectForKey:UIKeyboardFrameBeginUserInfoKey];
    CGSize keyboardSize = [value CGRectValue].size;
    
    NSLog(@"keyBoard:%f", keyboardSize.height);
}
- (void)startRequest {
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    NSDictionary *dic = @{@"id":[NSNumber numberWithInteger:[[[NSUserDefaults standardUserDefaults] objectForKey:@"userId"] integerValue]],@"userCardId":[[NSUserDefaults standardUserDefaults] objectForKey:@"userCardId"]};
    [manager POST:GETACCOUNTBALANCE parameters:dic success:^(AFHTTPRequestOperation *operation, id responseObject) {
        
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        self.allMoney = [[dic objectForKey:@"balance"] objectForKey:@"accountBalance"];
        NSNull *null = [[NSNull alloc] init];
        if (_allMoney == null) {
            _allMoney = @"0";
        }
        [_tableDicArray removeAllObjects];
        [_tableDicArray addObject:dic];
        [_table reloadData];
        NSLog(@"%@",dic);
        
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        //        self.alertController = [UIAlertController alertControllerWithTitle:@"网络异常" message:nil preferredStyle:UIAlertControllerStyleAlert];
        //        [self presentViewController:_alertController animated:true completion:nil];
        //        [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(dismissViewController) userInfo:nil repeats:NO];
    }];
}
@end
