//
//  ScrollViewCycleImage.m
//  epinzhenDoctor
//
//  Created by 焦钟培 on 15/11/20.
//  Copyright © 2015年 epz. All rights reserved.
//

#import "ScrollViewCycleImage.h"
#define kScreenWidth [[UIScreen mainScreen] bounds].size.width
#define RGBA_COLOR(r,g,b,a) [UIColor colorWithRed:r/255.0 green:g/255.0 blue:b/255.0 alpha:a]

@implementation ScrollViewCycleImage
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self creatScroll];
    }
    return self;
}
- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super initWithCoder:aDecoder];
    if (self) {
        [self creatScroll];
    }
    return self;
}

- (id)initWithDelegate:(id<ScrollViewCycleImageDelegate>)delegate
{
    self = [super init];
    if (self) {
        self.delegate = delegate;
        [self creatScroll];
    }
    return self;
}


/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/
//- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
//{
//    if ([keyPath isEqualToString:@"bounds"]) {
//        [self creatScroll];
//    }
//}
-(void)creatScroll{
    [_scroll removeFromSuperview];
    [_pageControl removeFromSuperview];
    [_pageView removeFromSuperview];
    if (self.frame.size.width > kScreenWidth) {
        _height = kScreenWidth / self.frame.size.width * self.frame.size.height;
    }else{
        _height = self.frame.size.height;
    }
    self.scroll = [UIScrollView new];
    _scroll.frame = CGRectMake(0, 0, kScreenWidth, _height);
    _scroll.showsHorizontalScrollIndicator = NO;
    _scroll.backgroundColor = [UIColor whiteColor];
    _scroll.tag = 1000;
    [self addSubview:_scroll];
    if (_numberImage == 0) {
    } else if (_numberImage == 1){
        _scroll.contentSize = CGSizeMake( kScreenWidth, 0);
        _scroll.contentOffset = CGPointMake(0, 0);
        UIImageView *imageView = [[UIImageView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth,_height)];
        [self.delegate scrollImagePlayerView:self loadImageForImageView:imageView index:0];
        imageView.tag = 1;
        [_scroll addSubview:imageView];
        return;
    } else if (_numberImage > 1) {
        for (int i = 0; i < _numberImage + 2; i++) {
            int temp ;
            if (i == 0) {
                temp = (int)_numberImage - 1;
            }else if (i == _numberImage + 1){
                temp = 0;
            }else{
                temp = i - 1;
            }
            _scroll.contentSize = CGSizeMake((_numberImage + 2) * kScreenWidth, 0);
            _scroll.contentOffset = CGPointMake(kScreenWidth, 0);
            UIImageView *imageView = [[UIImageView alloc] initWithFrame:CGRectMake(kScreenWidth * i, 0, kScreenWidth,_height)];
            [self.delegate scrollImagePlayerView:self loadImageForImageView:imageView index:temp];
            imageView.tag = i + 1;
            [_scroll addSubview:imageView];
        }
        NSInteger pageWidth;
        if (_numberImage * 20 > kScreenWidth) {
            pageWidth = kScreenWidth;
        }else{
            pageWidth = _numberImage * 20;
        }
        switch (_pageControlPosition) {
            case PageControlPosition_Center:
                
                _pageView = [[UIView alloc] initWithFrame:CGRectMake(0, _height - 20,kScreenWidth, 20)];
                
                break;
                case PageControlPosition_Left:
                _pageView = [[UIView alloc] initWithFrame:CGRectMake(0, _height - 20,pageWidth, 20)];
                break;
                case PageControlPosition_Right:
                _pageView = [[UIView alloc] initWithFrame:CGRectMake(kScreenWidth - pageWidth, _height - 20,pageWidth, 20)];
                break;
            default:
                _pageView = [[UIView alloc] initWithFrame:CGRectMake(0, _height - 20,kScreenWidth, 20)];
                break;
        }
        [self addSubview:_pageView];
        self.pageControl = [[UIPageControl alloc] initWithFrame:CGRectMake(0, 0,_pageView.frame.size.width, 20)];
        [self.pageControl addTarget:self action:@selector(handleClickPageControl:) forControlEvents:UIControlEventTouchUpInside];
        [_pageView addSubview:_pageControl];
        _pageControl.currentPageIndicatorTintColor = [UIColor whiteColor];
        _pageControl.pageIndicatorTintColor = RGBA_COLOR(255,255,255,0.4);
        _pageControl.numberOfPages = _numberImage;
        _pageControl.currentPage = 0;
        [self closeTimer];
        [self scrollTime];
    }
    UITapGestureRecognizer *singleTap1 = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(buttonpress:)];
    [_scroll addGestureRecognizer:singleTap1];
    _scroll.pagingEnabled = YES;
    _scroll.delegate = self;
    _scroll.bounces = NO;
}
- (void)handleClickPageControl:(UIPageControl *)sender
{
    [_timer invalidate];
    [UIView animateWithDuration:0.5 animations:^{
        _scroll.contentOffset = CGPointMake((sender.currentPage + 1) * kScreenWidth, 0);
    }];
    [self scrollTime];
}

- (void)scrollTime{
    self.timer =  [NSTimer scheduledTimerWithTimeInterval:4.0f target:self selector:@selector(changePage) userInfo:nil repeats:NO];
}
- (void)closeTimer{
    [_timer invalidate];
    _timer = nil;
}

- (void)changePage{
    NSLog(@"%f",_scroll.contentOffset.x);
    [UIView animateWithDuration:0.5 animations:^{
        _scroll.contentOffset = CGPointMake(_scroll.contentOffset.x + kScreenWidth, 0);
    }];
    if (_scroll.contentOffset.x == (_numberImage + 1) * kScreenWidth) {
        _scroll.contentOffset = CGPointMake(kScreenWidth, 0);
    }else if (_scroll.contentOffset.x == 0){
        _scroll.contentOffset = CGPointMake(kScreenWidth * _numberImage, 0);
    }
    
    _pageControl.currentPage = _scroll.contentOffset.x/kScreenWidth - 1;
    [self scrollTime];
}
- (void)scrollViewDidEndDecelerating:
(UIScrollView *)scrollView{
    [self scrollTime];
    if (scrollView.tag == 1000) {
        if (_scroll.contentOffset.x == (_numberImage + 1) * kScreenWidth) {
            _scroll.contentOffset = CGPointMake(kScreenWidth, 0);
        }else if (_scroll.contentOffset.x == 0){
            _scroll.contentOffset = CGPointMake(kScreenWidth * _numberImage, 0);
        }
    }
    _pageControl.currentPage = _scroll.contentOffset.x/kScreenWidth - 1;
}

- (void)buttonpress:(UIGestureRecognizer *)tapGesture{
    UIScrollView *imageView = (UIScrollView *)tapGesture.view;
    NSInteger index;
    if (imageView.contentOffset.x == 0) {
        index = 0;
    } else {
        index = imageView.contentOffset.x/kScreenWidth - 1;
    }
    [self.delegate scrollImagePlayerView:self didTapAtIndex:index];
}
- (void)scrollViewWillBeginDragging:(UIScrollView *)scrollView{
    [_timer invalidate];
}



@end
