//
//  GroupTabBar.m
//  垂直TabBar
//
//  Created by admin on 15/11/14.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "GroupTabBar.h"
#import "GroupItems.h"
#define kScreenWidth [UIScreen mainScreen].bounds.size.width
#define kScreenHeight [UIScreen mainScreen].bounds.size.height


#define kSelfWidth self.frame.size.width
#define kSelfHeight self.frame.size.height

#define kBtnTag 38341034

@interface GroupTabBar ()
@property (strong) NSMutableArray *buttons; // 存放所有button的数组
@end

@implementation GroupTabBar

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.buttons = [NSMutableArray array];
    }
    return self;
}

- (void)setItems:(NSArray *)items
{
    _items = items;
    CGFloat buttonHeight = kSelfHeight / _items.count;
    for (int i = 0; i < _items.count; i++) {
        GroupItems *item = _items[i];
        UIButton *button = [[UIButton alloc] init];
        button.tag = kBtnTag + i;
        button.titleLabel.font = [UIFont systemFontOfSize:15.0];
        button.titleLabel.numberOfLines = 0;
        [button setTitleColor:kLightBlack forState:UIControlStateNormal];
        button.frame = CGRectMake(0, i * buttonHeight, kSelfWidth, buttonHeight);
        [button setTitle:item.title forState:UIControlStateNormal];
        button.titleEdgeInsets = UIEdgeInsetsMake(0, 5, 0, 5);
        [button addTarget:self action:@selector(touchDownForButton:) forControlEvents:UIControlEventTouchDown];
        [button addTarget:self action:@selector(touchUpForButton:) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:button];
        [self.buttons addObject:button];
    }
}


- (void)showIndex:(NSInteger) index
{
    [self touchDownForButton:[self.buttons objectAtIndex:index]];
    [self touchUpForButton:[self.buttons objectAtIndex:index]];
}

- (void)touchDownForButton:(UIButton *)button{
    button.selected = YES;
    NSInteger i = [self.buttons indexOfObject:button];
    
    UIView *view = [[self.items objectAtIndex:i] view];
    
    if (_delegate) {
        [_delegate switchView:view];
    }
    
    for (UIButton * b in self.buttons) {
        b.selected = NO;
    }
    
}
- (void)touchUpForButton:(UIButton *)button {
    self.selectNumber = (int)button.tag - kBtnTag;
    for (UIButton * b in self.buttons) {
        b.selected = NO;
        b.backgroundColor = kSectionBackGroundColor;
    }
    button.selected = YES;
    button.backgroundColor = [UIColor whiteColor];
}



@end
