//
//  SOPTableView.m
//  redstar
//
//  Created by admin on 15/12/25.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "SOPTableView.h"

@interface SOPTableView () <UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) NSArray *titleArray;
@end


@implementation SOPTableView

- (instancetype)initWithFrame:(CGRect)frame style:(UITableViewStyle)style titleArray:(NSArray *)titleArray
{
    self = [super initWithFrame:frame style:style];
    if (self) {
        _titleArray = titleArray;
        [self setup];
    }
    return self;
}

- (instancetype)initWithTitleArray:(NSArray *)titleArray
{
    self = [super init];
    if (self) {
        _titleArray = titleArray;
        [self setup];
    }
    return self;
}

- (void)setup
{
    self.delegate = self;
    self.dataSource = self;
}


#pragma mark - UItableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _titleArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:@"cell333"];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:@"cell333"];
    }
    cell.textLabel.text = _titleArray[indexPath.row];
    cell.textLabel.font = [UIFont systemFontOfSize:15.0];
    cell.textLabel.textColor = kLightBlack;
    cell.textLabel.numberOfLines = 0;
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (_sop_delegate && [_sop_delegate respondsToSelector:@selector(selectRowWithDetailRow:)]) {
        [_sop_delegate selectRowWithDetailRow:indexPath.row];
    }
}

@end
