//
//  AddQuestionTableCell.m
//  redstar
//
//  Created by admin on 15/12/4.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AddQuestionTableCell.h"

@interface AddQuestionTableCell ()

@property (nonatomic, strong) UIImageView *backImageView1;
@property (nonatomic, strong) UIImageView *backImageView2;

@property (nonatomic, strong) UILabel *pictureLabel;

@end

@implementation AddQuestionTableCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    self.contentView.backgroundColor = kFootViewBackGroundColor;
    UILabel *contentLabel = [[UILabel alloc] init];
    contentLabel.translatesAutoresizingMaskIntoConstraints = NO;
    contentLabel.font = [UIFont systemFontOfSize:16.0];
    contentLabel.text = @"标题";
    contentLabel.textColor = kOnLineCellTitleColor;
    [self.contentView addSubview:contentLabel];
    
    NSLayoutConstraint *contentLabelTop = [NSLayoutConstraint constraintWithItem:contentLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [self.contentView addConstraint:contentLabelTop];
    
    NSLayoutConstraint *contentLabelLeft = [NSLayoutConstraint constraintWithItem:contentLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self.contentView addConstraint:contentLabelLeft];
    
    NSLayoutConstraint *contentLabelRight = [NSLayoutConstraint constraintWithItem:contentLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self.contentView addConstraint:contentLabelRight];
    
    NSLayoutConstraint *contentLabelHeight = [NSLayoutConstraint constraintWithItem:contentLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
    [self.contentView addConstraint:contentLabelHeight];
    
    
    
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    titleLabel.font = [UIFont systemFontOfSize:16.0];
    titleLabel.text = @"问题与建议描述";
    titleLabel.textColor = kOnLineCellTitleColor;
    [self.contentView addSubview:titleLabel];
    
    NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:110];
    [self.contentView addConstraint:titleTop];
    
    NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self.contentView addConstraint:titleLeft];
    
    NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self.contentView addConstraint:titleRight];
    
    NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
    [self.contentView addConstraint:titleHeight];
    
    
    UIImage *image = [UIImage imageNamed:@"textbox"];
    UIImage *resizingName = [image resizableImageWithCapInsets:UIEdgeInsetsMake(1, 1, 24, 24) resizingMode:UIImageResizingModeStretch];
    self.backImageView2.image = resizingName;
    self.backImageView1.image = resizingName;
    
    self.contentTextView.backgroundColor = [UIColor clearColor];
    self.placeholderLabel2.text = @"请输入文字...";
    self.titleTextView.backgroundColor = [UIColor clearColor];
    self.placeholderLabel1.text = @"请输入文字...";
    
    self.pictureLabel.text = @"现场照片";
    
}

#pragma mark - lazy loading


- (UIImageView *)backImageView2
{
    if (!_backImageView2) {
        _backImageView2 = [[UIImageView alloc] init];
        _backImageView2.userInteractionEnabled = YES;
        _backImageView2.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_backImageView2];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:45];
        [self.contentView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self.contentView addConstraint:contentHeight];
    }
    return _backImageView2;
}

- (UITextView *)contentTextView
{
    if (!_contentTextView) {
        _contentTextView = [[UITextView alloc] init];
        _contentTextView.tag = 1002;
        _contentTextView.font = [UIFont systemFontOfSize:15.0];
        _contentTextView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.backImageView2 addSubview:_contentTextView];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.backImageView2 addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [self.backImageView2 addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
        [self.backImageView2 addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.backImageView2 addConstraint:contentHeight];
    }
    return _contentTextView;
}

- (UIImageView *)backImageView1
{
    if (!_backImageView1) {
        _backImageView1 = [[UIImageView alloc] init];
        _backImageView1.userInteractionEnabled = YES;
        _backImageView1.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_backImageView1];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:155];
        [self.contentView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:120];
        [self.contentView addConstraint:contentHeight];
        
    }
    return _backImageView1;
}

- (UILabel *)placeholderLabel2
{
    if (!_placeholderLabel2) {
        _placeholderLabel2 = [[UILabel alloc] init];
        _placeholderLabel2.translatesAutoresizingMaskIntoConstraints = NO;
        _placeholderLabel2.font = [UIFont systemFontOfSize:15.0];
        _placeholderLabel2.textColor = kOnLineCellDetailColor;
        [self.contentTextView addSubview:_placeholderLabel2];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [self.contentTextView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:5];
        [self.contentTextView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentTextView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentTextView addConstraint:contentHeight];
    }
    return _placeholderLabel2;
}


- (UITextView *)titleTextView
{
    if (!_titleTextView) {
        _titleTextView = [[UITextView alloc] init];
        _titleTextView.tag = 1001;
        _titleTextView.font = [UIFont systemFontOfSize:15.0];
        _titleTextView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.backImageView1 addSubview:_titleTextView];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.backImageView1 addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [self.backImageView1 addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
        [self.backImageView1 addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.backImageView1 addConstraint:contentHeight];
    }
    return _titleTextView;
}



- (UILabel *)placeholderLabel1
{
    if (!_placeholderLabel1) {
        _placeholderLabel1 = [[UILabel alloc] init];
        _placeholderLabel1.translatesAutoresizingMaskIntoConstraints = NO;
        _placeholderLabel1.font = [UIFont systemFontOfSize:15.0];
        _placeholderLabel1.textColor = kOnLineCellDetailColor;
        [self.titleTextView addSubview:_placeholderLabel1];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [self.titleTextView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:5];
        [self.titleTextView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.titleTextView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.titleTextView addConstraint:contentHeight];
    }
    return _placeholderLabel1;
}


- (UILabel *)pictureLabel
{
    if (!_pictureLabel) {
        _pictureLabel = [[UILabel alloc] init];
        _pictureLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _pictureLabel.font = [UIFont systemFontOfSize:16.0];
        _pictureLabel.textColor = kOnLineCellTitleColor;
        [self.contentView addSubview:_pictureLabel];

        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:contentLeft];
        
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self.contentView addConstraint:contentHeight];
        
        NSLayoutConstraint *contentBottom = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:contentBottom];
    }
    return _pictureLabel;
}


- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    [self.contentView endEditing:YES];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
