//
//  PictureTableCell.m
//  redstar
//
//  Created by admin on 15/11/1.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "PictureTableCell.h"
#import <UIImageView+WebCache.h>

@interface PictureTableCell ()
@property (nonatomic, strong) UILabel *hotLabel;
@end

@implementation PictureTableCell


- (void)setPictureList:(PictureListModel *)pictureList
{
    _pictureList = pictureList;
    if (pictureList.attachments.count != 0) {
        NSDictionary *dict = pictureList.attachments[0];
        NSURL *imageUrl = [NSURL URLWithString:[NSString stringWithFormat:@"%@%@", kRedStarURL ,dict[@"fileUrl"]]];
        [self.titleImageView sd_setImageWithURL:imageUrl placeholderImage:[UIImage imageNamed:@"default_pic"]];
        
    } else {
        self.titleImageView.image = [UIImage imageNamed:@"default_pic"];
    }


    self.titleLabel.text = [NSString stringWithFormat:@"%@", pictureList.title];
    self.detailsLabel.text = [NSString stringWithFormat:@"%@", pictureList.content];
    if (pictureList.submitTime == nil || pictureList.submitTime == NULL || [pictureList.submitTime isEqual:[NSNull null]]) {
        self.dateLabel.text = [NSString stringWithFormat:@""];
    } else {
        self.dateLabel.text = [[NSString stringWithFormat:@"%@",pictureList.submitTime] substringToIndex:10];
    }
    self.adressLabel.text = [NSString stringWithFormat:@"%@", pictureList.store_name];
    
    if (pictureList.hotspot) {
        self.hotLabel.hidden = NO;
    } else {
        self.hotLabel.hidden = YES;
    }
    
    if (pictureList.myLike) {
        self.thumbBtn.selected = YES;
    } else {
        self.thumbBtn.selected = NO;
    }
    
    [self.thumbBtn setTitle:[NSString stringWithFormat:@"%d", pictureList.likeCount] forState:UIControlStateNormal];
    [self.commentBtn setTitle:[NSString stringWithFormat:@"%d", pictureList.commentCount] forState:UIControlStateNormal];
}


//裁剪图片
- (UIImage *)cutImage:(UIImage*)image
{
    //压缩图片
    CGSize newSize;
    CGImageRef imageRef = nil;
    
    if ((image.size.width / image.size.height) < (((kScreenWidth - 20 * 3) / 2) / 90)) {
        newSize.width = image.size.width;
        newSize.height = image.size.width * 90 / ((kScreenWidth - 20 * 3) / 2);
        
        imageRef = CGImageCreateWithImageInRect([image CGImage], CGRectMake(0, fabs(image.size.height - newSize.height) / 2, newSize.width, newSize.height));
        
    } else {
        newSize.height = image.size.height;
        newSize.width = image.size.height * ((kScreenWidth - 20 * 3) / 2) / 90;
        
        imageRef = CGImageCreateWithImageInRect([image CGImage], CGRectMake(fabs(image.size.width - newSize.width) / 2, 0, newSize.width, newSize.height));
        
    }
    
    return [UIImage imageWithCGImage:imageRef];
}


#pragma mark - Lazy loading
- (UIImageView *)titleImageView
{
    if (!_titleImageView) {
        _titleImageView = [[UIImageView alloc] init];
        _titleImageView.translatesAutoresizingMaskIntoConstraints = NO;
        _titleImageView.contentMode = UIViewContentModeScaleAspectFill;
        _titleImageView.clipsToBounds = YES;
        [self.contentView addSubview:_titleImageView];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_titleImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:28];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageLeft = [NSLayoutConstraint constraintWithItem:_titleImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:15];
        [self.contentView addConstraint:titleImageLeft];
        
        NSLayoutConstraint *titleImageWidth = [NSLayoutConstraint constraintWithItem:_titleImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:85];
        [self.contentView addConstraint:titleImageWidth];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_titleImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self.contentView addConstraint:titleImageHeight];
    }
    return _titleImageView;
}

- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.textColor = kPictureCellTitleColor;

        _titleLabel.font = [UIFont systemFontOfSize:17.0];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_titleLabel];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:16];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:10];
        [self.contentView addConstraint:titleImageLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.hotLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:titleImageHeight];
    }
    return _titleLabel;
}
- (UILabel *)hotLabel
{
    if (!_hotLabel) {
        _hotLabel = [[UILabel alloc] init];
        _hotLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _hotLabel.backgroundColor = kHotBackGroundColor;
        _hotLabel.textColor = [UIColor whiteColor];
        _hotLabel.font = [UIFont boldSystemFontOfSize:12.0];
        _hotLabel.text = @"HOT";
        _hotLabel.textAlignment = NSTextAlignmentCenter;
        _hotLabel.layer.cornerRadius = 3;
        [self.contentView addSubview:_hotLabel];
        
        // 顶端
        NSLayoutConstraint *hotTop = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:20];
        [self.contentView addConstraint:hotTop];
        
        // 左边
        NSLayoutConstraint *hotWidth = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:34];
        [self.contentView addConstraint:hotWidth];
        
        NSLayoutConstraint *hotRight = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:hotRight];
        
        NSLayoutConstraint *hotHeight = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:15];
        [self.contentView addConstraint:hotHeight];
    }
    return _hotLabel;
}
- (UILabel *)detailsLabel
{
    if (!_detailsLabel) {
        _detailsLabel = [[UILabel alloc] init];
        _detailsLabel.font = [UIFont systemFontOfSize:15.0];
        _detailsLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _detailsLabel.numberOfLines = 0;
        _detailsLabel.textColor = kPictureCellDetailsColor;

        [self.contentView addSubview:_detailsLabel];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageLeft = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:10];
        [self.contentView addConstraint:titleImageLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-15];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:23];
        [self.contentView addConstraint:titleImageHeight];
    }
    return _detailsLabel;
}

- (UILabel *)adressLabel
{
    if (!_adressLabel) {
        _adressLabel = [[UILabel alloc] init];
        _adressLabel.font = [UIFont systemFontOfSize:14.0];
        _adressLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _adressLabel.numberOfLines = 0;
        _adressLabel.textColor = kLightGray;
        
        [self.contentView addSubview:_adressLabel];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_adressLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.detailsLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageLeft = [NSLayoutConstraint constraintWithItem:_adressLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:10];
        [self.contentView addConstraint:titleImageLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_adressLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-15];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_adressLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:23];
        [self.contentView addConstraint:titleImageHeight];
    }
    return _adressLabel;
}

- (UILabel *)dateLabel
{
    if (!_dateLabel) {
        _dateLabel = [[UILabel alloc] init];
        _dateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _dateLabel.font = [UIFont systemFontOfSize:14.0];
        _dateLabel.textColor = kPictureCellDateColor;

        [self.contentView addSubview:_dateLabel];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:7];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageLeft = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:5];
        [self.contentView addConstraint:titleImageLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.thumbBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:titleImageHeight];
        
        NSLayoutConstraint *titleImageBottom = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-5];
        [self.contentView addConstraint:titleImageBottom];
    }
    return _dateLabel;
}

- (ZanButton *)thumbBtn
{
    if (!_thumbBtn) {
        _thumbBtn = [[ZanButton alloc] init];
        [_thumbBtn setImage:[UIImage imageNamed:@"commend"] forState:UIControlStateNormal];
        [_thumbBtn setImage:[UIImage imageNamed:@"commend_after"] forState:UIControlStateSelected];
        _thumbBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_thumbBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        _thumbBtn.titleLabel.font = [UIFont systemFontOfSize:15.0];
        [self.contentView addSubview:_thumbBtn];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:8];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageWidth = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.commentBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleImageWidth];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.commentBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-3];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleImageHeight];
    }
    return _thumbBtn;
}

- (ZanButton *)commentBtn
{
    if (!_commentBtn) {
        _commentBtn = [[ZanButton alloc] init];
        [_commentBtn setImage:[UIImage imageNamed:@"comment"] forState:UIControlStateNormal];
        _commentBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_commentBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        _commentBtn.titleLabel.font = [UIFont systemFontOfSize:15.0];
        [self.contentView addSubview:_commentBtn];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_commentBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:8];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageWidth = [NSLayoutConstraint constraintWithItem:_commentBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self.contentView addConstraint:titleImageWidth];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_commentBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-8];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_commentBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleImageHeight];
    }
    return _commentBtn;
}
- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
