//
//  AddPictureViewController.m
//  redstar
//
//  Created by admin on 15/12/7.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AddPictureViewController.h"
#import "AddPictureTableCell.h"
#import "AddButtonTableViewCell.h"
#import "AddPicTextTableViewCell.h"
#import "CheckPicViewController.h"
#import "LargePictureViewController.h"

#import "HttpClient.h"
#import "UIImage+Fit.h"
#import "CommonFunc.h"

#import <MBProgressHUD.h>

#define kAddPicTableViewCell @"addPicTableCell"
#define kAddPicTextTableViewCell @"addPicTextTableCell"
#define kAddButtonCell @"addButtonTableViewCell"

@interface AddPictureViewController () <UITableViewDelegate, UITableViewDataSource, UINavigationControllerDelegate, UIImagePickerControllerDelegate, UIActionSheetDelegate, UIAlertViewDelegate, UITextViewDelegate>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSMutableArray *imageNameArray;
@property (nonatomic, strong) NSMutableArray *textArray;


@property (nonatomic, assign) int rowNumber;
@property (nonatomic, strong) UIView *footView;
@property (nonatomic, strong) UIButton *reportButton;
@property (nonatomic, strong) UIActionSheet *selectActionSheet;

@property (nonatomic, copy) NSString *praiseUuid;

@end

@implementation AddPictureViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"新增口碑"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
    
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    _tableView.tableFooterView = self.footView;
    
    [self.reportButton addTarget:self action:@selector(uploadInspect:) forControlEvents:UIControlEventTouchUpInside];

    _rowNumber = 2;
    self.imageNameArray = [NSMutableArray array];
    self.textArray = [NSMutableArray array];
}

#pragma mark - Private Mothods
- (void)uploadInspect:(UIButton *)sender
{
    if (_imageNameArray.count == 0) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"请至少添加一组图片和文字！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
        return;
    }
    // 提示框
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您确定要上报口碑吗？" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确定", nil];
    alert.tag = 334281;
    alert.delegate = self;
    [alert show];
}

- (void)doBack:(id)sender
{
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您确定要放弃编辑当前图说口碑吗？" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确定", nil];
    alert.tag = 9211232;
    [alert show];
    
}

- (void)createImagePicker:(UIButton *)sender
{
    self.selectActionSheet = [[UIActionSheet alloc] initWithTitle:nil delegate:self cancelButtonTitle:@"取消" destructiveButtonTitle:nil otherButtonTitles:@"直接拍照上传", @"从本地相册选择", nil];
    _selectActionSheet.delegate = self;
    _selectActionSheet.tag = 999283;
    [_selectActionSheet showInView:self.view];
    
    
    if (sender.tag == 2201) {
        _rowNumber++;
    }
}

- (void)addPicText:(UIButton *)sender
{
    NSDate *date = [NSDate date];
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"YYYY-MM-dd+hh:mm:ss"];
    NSString *dateString = [dateFormatter stringFromDate:date];
    
    NSString *operId = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_code"];
    NSString *operName = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"];
    
    if (_rowNumber == 2) {
        AddPictureTableCell *cell = [_tableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:0]];
        cell.titleTextView.delegate = self;
        cell.contentTextView.delegate = self;
        if (cell.titleTextView.text.length == 0 || cell.contentTextView.text.length == 0) {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"标题、问题与建议描述不能为空！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
            [alert show];
            return;
        } else {
            [MBProgressHUD showHUDAddedTo:self.view animated:YES];
            NSString *url = [NSString stringWithFormat:@"%@%@%@&operId=%@&operName=%@", kRedStarURL, kSavePicturePraiseURL,dateString, operId, operName];
            url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
            HttpClient *http1 = [[HttpClient alloc] initWithUrl:url];
            NSDictionary *parameters = @{
                                         @"title":cell.contentTextView.text,
                                         @"content":cell.titleTextView.text,
                                         @"type":self.category
                                         };
            [http1 savePicturePraiseWithParameters:parameters completion:^(id response, NSError *error) {
                _praiseUuid = response[@"data"];
                if ([response[@"success"] boolValue]) {
                    NSLog(@"失败");
                }
                [MBProgressHUD hideHUDForView:self.view animated:YES];

            }];
        }
        _rowNumber++;
        [self.tableView reloadData];
        
    } else {
        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:(_rowNumber - 2) inSection:0];
        AddPicTextTableViewCell *cell = [_tableView cellForRowAtIndexPath:indexPath];
        
        NSString *url = [NSString stringWithFormat:@"%@%@%@/submit_attachment?time=%@&operId=%@&operName=%@", kRedStarURL, kUpLoadPictureURL, _praiseUuid ,dateString, operId, operName];
        url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
        HttpClient *http1 = [[HttpClient alloc] initWithUrl:url];
        
        if ((_imageNameArray.count == _rowNumber - 2) && cell.titleTextView.text.length != 0 ) {
            
            [self.textArray addObject:cell.titleTextView.text];
            
            NSString *imageName = _imageNameArray[_rowNumber - 3];
            NSString *fullPath = [[NSHomeDirectory() stringByAppendingPathComponent:@"Documents"] stringByAppendingPathComponent:imageName];
            UIImage *image = [UIImage imageWithContentsOfFile:fullPath];
            NSData *imageData = UIImageJPEGRepresentation(image, 0.01);
            NSString *imageBase64 = [imageData base64EncodedStringWithOptions:0];
            NSDictionary *parameters = @{
                                         @"description":cell.titleTextView.text,
                                         @"fileName":imageName,
                                         @"fileContent":imageBase64
                                         };
            [MBProgressHUD showHUDAddedTo:self.view animated:YES];
            [http1 upLoadPraisePictureWithParameters:parameters completion:^(id response, NSError *error) {
                [MBProgressHUD hideAllHUDsForView:self.view animated:YES];
                
                if ([response[@"success"] boolValue]) {
                    _rowNumber++;
                    [self.tableView reloadData];
                } else {
                    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"当前图片上传失败，请重新上传！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
                    [alert show];
                    return ;
                }

            }];
            
        } else {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"必须有图片和图片说明！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
            [alert show];
        }
    }
    
        
}

- (void)saveImage:(UIImage *)currentImage {
    NSData *imageData = UIImageJPEGRepresentation(currentImage, 0.01);
    NSString *imageName = [CommonFunc md5Data:imageData];
    [_imageNameArray addObject:imageName];
    
    // 获取沙盒目录
    NSString *fullPath = [[NSHomeDirectory() stringByAppendingPathComponent:@"Documents"] stringByAppendingPathComponent:imageName];
    // 将图片写入文件
    [imageData writeToFile:fullPath atomically:NO];
}

- (void)showBigPic:(UIButton *)sender
{
    AddPicTextTableViewCell *cell = (AddPicTextTableViewCell *)sender.superview.superview;
    NSIndexPath *indexPath = [_tableView indexPathForCell:cell];
    NSInteger index = indexPath.row - 1;
    
    LargePictureViewController *largeVC = [[LargePictureViewController alloc] init];
    largeVC.index = index;
    largeVC.pictureSaveMode = PictureLocalMode;
    largeVC.allImageArray = _imageNameArray;
    [self.navigationController pushViewController:largeVC animated:YES];
    
//    CheckPicViewController *checkVC = [[CheckPicViewController alloc] init];
//    checkVC.checkImage = sender.imageView.image;
//    [self.navigationController pushViewController:checkVC animated:YES];
}

#pragma mark - UItextView
- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{
     AddPictureTableCell *cell = [_tableView cellForRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:0]];
    if (![text isEqualToString:@""]) {
        if (textView.tag == 9991) {
            cell.placeholderLabel1.hidden = YES;
        } else {
            cell.placeholderLabel2.hidden = YES;
        }
    }
    
    if ([text isEqualToString:@""] && range.location == 0 && range.length == 1) {
        if (textView.tag == 9991) {
            cell.placeholderLabel1.hidden = NO;
        } else {
            cell.placeholderLabel2.hidden = NO;
        }
    }
    
    if ([text isEqualToString:@"\n"]) {
        [cell.titleTextView resignFirstResponder];
        [cell.contentTextView resignFirstResponder];
        
        if (textView.tag == 9991) {
            if (textView.text.length != 0) {
                cell.placeholderLabel1.hidden = YES;
            } else {
                cell.placeholderLabel1.hidden = NO;
            }
        } else {
            if (textView.text.length != 0) {
                cell.placeholderLabel2.hidden = YES;
            } else {
                cell.placeholderLabel2.hidden = NO;
            }
        }
        return NO;
    }
    
    return YES;
}


#pragma mark - UIImagePickerController 代理方法
- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info
{
    UIImage *image = [info objectForKey:UIImagePickerControllerOriginalImage];
    [self saveImage:image];
    
    // 退出图片选择控制器
    [picker dismissViewControllerAnimated:YES completion:^{
        [self.tableView reloadData];
    }];
    
}



#pragma mark - UIActionSheetDelegate

- (void)actionSheet:(UIActionSheet *)actionSheet didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    if (actionSheet.tag == 999283) {
        if (buttonIndex == 0) {
            if (![UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
                UIAlertView *alert = [[UIAlertView alloc] initWithTitle:nil message:@"找不到相机" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
                [alert show];
            } else {
                UIImagePickerController *picker = [[UIImagePickerController alloc] init];
                picker.delegate = self;
                picker.sourceType = UIImagePickerControllerSourceTypeCamera;
                picker.modalTransitionStyle=UIModalTransitionStyleFlipHorizontal;
                picker.videoQuality = UIImagePickerControllerQualityTypeLow;
                [self presentViewController:picker animated:YES completion:nil];
            }
        } else if (buttonIndex == 1){
            UIImagePickerController *picker = [[UIImagePickerController alloc] init];
            picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
            picker.delegate = self;
            //设置选择后的图片可被编辑
            picker.allowsEditing = YES;
            [self presentViewController:picker animated:YES completion:nil];
        }
    }
}

#pragma mark - UIAlertViewDelegte
- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (alertView.tag == 334281) {
        if (buttonIndex == 1) {
            
            [MBProgressHUD showHUDAddedTo:self.view animated:YES];
            NSDate *date = [NSDate date];
            NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
            [dateFormatter setDateFormat:@"YYYY-MM-dd+hh:mm:ss"];
            NSString *dateString = [dateFormatter stringFromDate:date];
            
            NSString *operId = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_code"];
            NSString *operName = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"];

            NSIndexPath *indexPath = [NSIndexPath indexPathForRow:(_rowNumber - 2) inSection:0];
            AddPicTextTableViewCell *cell = [_tableView cellForRowAtIndexPath:indexPath];
            if (_imageNameArray.count == _rowNumber - 2 || cell.titleTextView.text.length != 0) {
                
                NSString *urlStr = [NSString stringWithFormat:@"%@%@%@/submit_attachment?time=%@&operId=%@&operName=%@", kRedStarURL, kUpLoadPictureURL, _praiseUuid ,dateString, operId, operName];
                urlStr = [urlStr stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
                HttpClient *httpClinet = [[HttpClient alloc] initWithUrl:urlStr];
                
                NSString *imageName = _imageNameArray[_rowNumber - 3];
                NSString *fullPath = [[NSHomeDirectory() stringByAppendingPathComponent:@"Documents"] stringByAppendingPathComponent:imageName];
                UIImage *image = [UIImage imageWithContentsOfFile:fullPath];
                NSData *imageData = UIImageJPEGRepresentation(image, 0.01);
                NSString *imageBase64 = [imageData base64EncodedStringWithOptions:0];
                NSDictionary *parameters = @{
                                             @"description":cell.titleTextView.text,
                                             @"fileName":imageName,
                                             @"fileContent":imageBase64
                                             };
                [httpClinet upLoadPraisePictureWithParameters:parameters completion:^(id response, NSError *error) {
                    
                    
                    NSString *url = [NSString stringWithFormat:@"%@%@%@/submit?time=%@&operId=%@&operName=%@", kRedStarURL, kSubmitPicturePraiseURL,_praiseUuid, dateString, operId, operName];
                    url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
                    HttpClient *http1 = [[HttpClient alloc] initWithUrl:url];
                    [http1 submitPicturePraiseWithCompletion:^(id response, NSError *error) {
                        if ([response[@"success"] boolValue]) {
                            UIAlertView *alertt = [[UIAlertView alloc] initWithTitle:@"提示" message:@"新增口碑成功！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
                            alertt.tag = 893323;
                            [alertt show];
                        } else {
                            UIAlertView *alertt = [[UIAlertView alloc] initWithTitle:@"警告" message:@"新增口碑失败！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
                            [alertt show];
                        }
                        [MBProgressHUD hideHUDForView:self.view animated:YES];
                    }];
                }];
            }
        }
    }
    
    if (alertView.tag == 9211232) {
        if (buttonIndex == 1) {
            [self.navigationController popViewControllerAnimated:YES];
        }
    }
    
    if (alertView.tag == 893323) {
        if (buttonIndex == 0) {
            if (_delegate && [_delegate respondsToSelector:@selector(reloadList)]) {
                [_delegate reloadList];
            }
            [self.navigationController popViewControllerAnimated:YES];
        }
    }
    
}



#pragma mark - UITableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _rowNumber;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        AddPictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kAddPicTableViewCell];
        if (!cell) {
            cell = [[AddPictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kAddPicTableViewCell];
        }
        cell.titleTextView.delegate = self;
        cell.contentTextView.delegate = self;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    } else if (indexPath.row == _rowNumber - 1) {
        AddButtonTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kAddButtonCell];
        if (!cell) {
            cell = [[AddButtonTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kAddButtonCell];
        }
        [cell.addButton addTarget:self action:@selector(addPicText:) forControlEvents:UIControlEventTouchUpInside];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    } else {
        AddPicTextTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kAddPicTextTableViewCell];
        if (!cell) {
            cell = [[AddPicTextTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kAddPicTextTableViewCell];
        }
        
        if (_rowNumber - 2 == _imageNameArray.count) {
            
            if (indexPath.row == _rowNumber - 2) {
                
                NSString *imageName = _imageNameArray[indexPath.row - 1];
                NSString *fullPath = [[NSHomeDirectory() stringByAppendingPathComponent:@"Documents"] stringByAppendingPathComponent:imageName];
                UIImage *image = [UIImage imageWithContentsOfFile:fullPath];
                UIImage *image00 = [UIImage image:image fillSize:CGSizeMake((kScreenWidth - 60) / 2, 90)];
                [cell.photoButton setImage:image00 forState:UIControlStateNormal];
                [cell.photoButton removeTarget:self action:@selector(createImagePicker:) forControlEvents:UIControlEventTouchUpInside];
                [cell.photoButton addTarget:self action:@selector(showBigPic:) forControlEvents:UIControlEventTouchUpInside];
                cell.titleTextView.userInteractionEnabled = YES;
                cell.titleTextView.text = @"";
            } else {
                NSString *imageName = _imageNameArray[indexPath.row - 1];
                NSString *fullPath = [[NSHomeDirectory() stringByAppendingPathComponent:@"Documents"] stringByAppendingPathComponent:imageName];
                UIImage *image = [UIImage imageWithContentsOfFile:fullPath];
                UIImage *image00 = [UIImage image:image fillSize:CGSizeMake((kScreenWidth - 60) / 2, 90)];
                [cell.photoButton setImage:image00 forState:UIControlStateNormal];
                [cell.photoButton removeTarget:self action:@selector(createImagePicker:) forControlEvents:UIControlEventTouchUpInside];
                [cell.photoButton addTarget:self action:@selector(showBigPic:) forControlEvents:UIControlEventTouchUpInside];
                NSString *textStr = _textArray[indexPath.row - 1];
                cell.titleTextView.text = textStr;
                
            }
            
        } else {
            if (indexPath.row == _rowNumber - 2) {
                [cell.photoButton setImage:[UIImage imageNamed:@"add-photo_icon"] forState:UIControlStateNormal];
                [cell.photoButton removeTarget:self action:@selector(showBigPic:) forControlEvents:UIControlEventTouchUpInside];
                [cell.photoButton addTarget:self action:@selector(createImagePicker:) forControlEvents:UIControlEventTouchUpInside];
                cell.titleTextView.text = @"";

            } else {
                NSString *imageName = _imageNameArray[indexPath.row - 1];
                NSString *fullPath = [[NSHomeDirectory() stringByAppendingPathComponent:@"Documents"] stringByAppendingPathComponent:imageName];
                UIImage *image = [UIImage imageWithContentsOfFile:fullPath];
                UIImage *image00 = [UIImage image:image fillSize:CGSizeMake((kScreenWidth - 60) / 2, 110)];
                [cell.photoButton setImage:image00 forState:UIControlStateNormal];
                [cell.photoButton removeTarget:self action:@selector(createImagePicker:) forControlEvents:UIControlEventTouchUpInside];
                [cell.photoButton addTarget:self action:@selector(showBigPic:) forControlEvents:UIControlEventTouchUpInside];
                cell.titleTextView.userInteractionEnabled = NO;
                NSString *textStr = _textArray[indexPath.row - 1];
                cell.titleTextView.text = textStr;
            }
        }
        return cell;
    }   
}

#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 100.0;
        [_tableView registerClass:[AddPictureTableCell class] forCellReuseIdentifier:kAddPicTableViewCell];
        [_tableView registerClass:[AddPicTextTableViewCell class] forCellReuseIdentifier:kAddPicTextTableViewCell];
        [_tableView registerClass:[AddButtonTableViewCell class] forCellReuseIdentifier:kAddButtonCell];
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (UIView *)footView
{
    if (!_footView) {
        _footView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 60)];
    }
    return _footView;
}

- (UIButton *)reportButton
{
    if (!_reportButton) {
        _reportButton = [[UIButton alloc] init];
        _reportButton.translatesAutoresizingMaskIntoConstraints = NO;
        _reportButton.backgroundColor = kNavigationBarColor;
        [_reportButton setTitle:@"上报口碑" forState:UIControlStateNormal];
        [self.footView addSubview:_reportButton];
        
        NSLayoutConstraint *reportTop = [NSLayoutConstraint constraintWithItem:_reportButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.footView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.footView addConstraint:reportTop];
        
        NSLayoutConstraint *reportLeft = [NSLayoutConstraint constraintWithItem:_reportButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.footView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.footView addConstraint:reportLeft];
        
        NSLayoutConstraint *reportWidth = [NSLayoutConstraint constraintWithItem:_reportButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:kScreenWidth - 40];
        [self.footView addConstraint:reportWidth];
        
        NSLayoutConstraint *tableHeight = [NSLayoutConstraint constraintWithItem:_reportButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self.footView addConstraint:tableHeight];
    }
    return _reportButton;
}


@end
