//
//  SelectYetTableViewCell.m
//  redstar
//
//  Created by admin on 15/12/21.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "SelectYetTableViewCell.h"
#import "TreeNodeModel.h"

@implementation SelectYetTableViewCell

- (void)setSelectTreeArray:(NSMutableArray *)selectTreeArray
{
    for (UIButton *button in self.contentView.subviews) {
        [button removeFromSuperview];
    }
    
    _selectTreeArray = selectTreeArray;
    for (int i = 0; i < selectTreeArray.count; i++) {
        TreeNodeModel *model = selectTreeArray[i];
        
        UIButton *button = [[UIButton alloc] init];
        button.tag = 6666687 + i;
        button.translatesAutoresizingMaskIntoConstraints = NO;
        [button setTitle:model.name forState:UIControlStateNormal];
        button.titleLabel.font = [UIFont systemFontOfSize:14.0];
        button.backgroundColor = kSelectStoreColor;
        button.titleEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 8);
        [self.contentView addSubview:button];
        
        CGFloat x,y;
        
        CGFloat marginX = 5;
        CGFloat marginY = 5;
        CGFloat w = (kScreenWidth - 80) / 2 - marginX;
        CGFloat h = 25;
        NSInteger row;
        if ((i + 1)  % 2 == 0) {
            x = -20;
            row = (i - 1) / 2;
            y = 10 + (i / 2) * (h + marginY);
            
            NSLayoutConstraint *imageViewRight = [NSLayoutConstraint constraintWithItem:button attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:x];
            [self.contentView addConstraint:imageViewRight];
        } else {
            x = 60;
            row = i / 2;
            y = 10 + (i / 2) * (h + marginY);
            
            NSLayoutConstraint *imageViewLeft = [NSLayoutConstraint constraintWithItem:button attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:x];
            [self.contentView addConstraint:imageViewLeft];
        }
        
        
        NSLayoutConstraint *imageViewTop = [NSLayoutConstraint constraintWithItem:button attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:y];
        [self.contentView addConstraint:imageViewTop];
        
        
        NSLayoutConstraint *imageViewHeight = [NSLayoutConstraint constraintWithItem:button attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:h];
        [self.contentView addConstraint:imageViewHeight];
        
        NSLayoutConstraint *imageViewWidth = [NSLayoutConstraint constraintWithItem:button attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:w];
        [self.contentView addConstraint:imageViewWidth];
        
        if (i == (_selectTreeArray.count - 1)) {
            NSLayoutConstraint *imageViewBootom = [NSLayoutConstraint constraintWithItem:button attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-5];
            [self.contentView addConstraint:imageViewBootom];
        }
        
        // 删除按钮
        UIButton *deleteBtn = [[UIButton alloc] init];
        deleteBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [deleteBtn setImage:[UIImage imageNamed:@"delete_box"] forState:UIControlStateNormal];
        [deleteBtn addTarget:self action:@selector(deleteBox:) forControlEvents:UIControlEventTouchUpInside];
        [button addSubview:deleteBtn];
        
        NSLayoutConstraint *deleteTop = [NSLayoutConstraint constraintWithItem:deleteBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:button attribute:NSLayoutAttributeTop multiplier:1.0 constant:3];
        [button addConstraint:deleteTop];
        
        NSLayoutConstraint *deleteHeight = [NSLayoutConstraint constraintWithItem:deleteBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:7.5];
        [button addConstraint:deleteHeight];
        
        NSLayoutConstraint *deleteWidth = [NSLayoutConstraint constraintWithItem:deleteBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:7.5];
        [button addConstraint:deleteWidth];
        
        NSLayoutConstraint *deleteRight = [NSLayoutConstraint constraintWithItem:deleteBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:button attribute:NSLayoutAttributeRight multiplier:1.0 constant:-3];
        [button addConstraint:deleteRight];
        
    }
}

- (void)deleteBox:(UIButton *)sender
{
    if (_delegate && [_delegate respondsToSelector:@selector(removeCurrentWithButton:)]) {
        [_delegate removeCurrentWithButton:sender];
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
}

@end
