//
//  OnLineCompleteCell.m
//  redstar
//
//  Created by admin on 15/11/30.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineCompleteCell.h"

@implementation OnLineCompleteCell

#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        //[self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setupWithScore:(int)score
{
    CGFloat imageW = 16.5;
    CGFloat imageH = 16;
    CGFloat spaceX = 7;
    
    for (int i = 0; i < score; i++) {
        UIImageView *imageView = [[UIImageView alloc] init];
        imageView.image = [UIImage imageNamed:@"star_after"];
        imageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:imageView];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopName attribute:NSLayoutAttributeBottom multiplier:1.0 constant:2];
        [self.contentView  addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.iconImageView  attribute:NSLayoutAttributeRight multiplier:1.0 constant:11 + i * (imageW + spaceX)];
        [self.contentView  addConstraint:Left];
        
        NSLayoutConstraint *width = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:imageW];
        [self.contentView  addConstraint:width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:imageH];
        [self.contentView  addConstraint:Height];
    }
}

- (void)setStoreDetail:(StoreDetailModel *)storeDetail
{
    _storeDetail = storeDetail;
    self.iconImageView.image = [UIImage imageNamed:@"default_pic"];
    self.shopName.text = [NSString stringWithFormat:@"%@", storeDetail.store_name];
    
    if (storeDetail.reportTime == nil || storeDetail.reportTime == NULL || [storeDetail.reportTime isEqual:[NSNull null]] || storeDetail.reportTime == Nil || [storeDetail.reportTime isEqualToString:@"(null)"]) {
        self.reportTime.text = [NSString stringWithFormat:@"上报时间："];
    } else {
        self.reportTime.text = [[NSString stringWithFormat:@"上报时间：%@", storeDetail.reportTime] substringToIndex:15];
    }
    
    [self setupWithScore:[storeDetail.score intValue]];
}

- (UIImageView *)iconImageView
{
    if (!_iconImageView) {
        _iconImageView = [[UIImageView alloc] init];
        _iconImageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView  addSubview:_iconImageView];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_iconImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:13];
        [self.contentView  addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_iconImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView  attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView  addConstraint:Left];
        
        NSLayoutConstraint *width = [NSLayoutConstraint constraintWithItem:_iconImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:90];
        [self.contentView  addConstraint:width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_iconImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:64];
        [self.contentView  addConstraint:Height];
        
        NSLayoutConstraint *Bottom = [NSLayoutConstraint constraintWithItem:_iconImageView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-13];
        [self.contentView  addConstraint:Bottom];
    }
    return _iconImageView;
}

- (UILabel *)shopName
{
    if (!_shopName) {
        _shopName = [[UILabel alloc] init];
        _shopName.font = [UIFont systemFontOfSize:17.0];
        _shopName.textColor = kLightBlack;
        _shopName.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_shopName];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_shopName attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:12];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_shopName attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.iconImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:10];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_shopName attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_shopName attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:Height];
    }
    return _shopName;
}



- (UILabel *)reportTime
{
    if (!_reportTime) {
        _reportTime = [[UILabel alloc] init];
        _reportTime.font = [UIFont systemFontOfSize:13.0];
        _reportTime.textColor = kLightGray;
        _reportTime.textAlignment = NSTextAlignmentLeft;
        _reportTime.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_reportTime];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_reportTime attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopName attribute:NSLayoutAttributeBottom multiplier:1.0 constant:23];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_reportTime attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.iconImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:10];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_reportTime attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_reportTime attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:Height];
    }
    return _reportTime;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
