//
//  OnLineViewController.m
//  redstar
//
//  Created by admin on 15/11/1.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineViewController.h"
#import "OnLineTableViewCell.h"
#import "OnLineFooterView.h"
#import "SpotCheckOnLineViewController.h"
#import "SelectStoreViewController.h"
#import "HttpClient.h"
#import "TreeNodeModel.h"

#define kOnLineTableViewCell @"onlineTableViewCell"

@interface OnLineViewController () <UITableViewDelegate, UITableViewDataSource, UIAlertViewDelegate, SelectStoreDelegate>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSArray *titleArray;
@property (nonatomic, strong) NSMutableArray *uuidArray;
@property (nonatomic, strong) OnLineFooterView *footView;
@property (nonatomic, strong) NSString *storeName;
@property (nonatomic, strong) NSString *dateStr;

@property (nonatomic, strong) UIView *backGroundView;
@property (nonatomic, strong) UIView *pickBackView;
@property (nonatomic, strong) UIDatePicker *datePicker;
@end

@implementation OnLineViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    _uuidArray = [NSMutableArray array];

    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"发起抽查任务"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    self.titleArray = [NSArray arrayWithObjects:@"商场名称", @"截止时间", nil];
    
    [self addTableView];
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
    _storeName = @"全部";
    _dateStr = @"";
}

- (void)doBack:(id)sender
{
    if ([[self.navigationController.viewControllers objectAtIndex:0] isKindOfClass:[SpotCheckOnLineViewController class]]) {
        SpotCheckOnLineViewController *spotCheckVC = (SpotCheckOnLineViewController *)[self.navigationController.viewControllers objectAtIndex:0];
        [self.navigationController popToViewController:spotCheckVC animated:YES];
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#pragma mark - Private Methods
- (void)addTableView
{
    [self.tableView registerClass:[OnLineTableViewCell class] forCellReuseIdentifier:kOnLineTableViewCell];
    self.tableView.tableFooterView = self.footView;
}

- (void)saveClick:(UIButton *)sender
{
    
    if (_dateStr.length == 0) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"请选择截止时间！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
        return;
    }
    
    if (self.footView.titleTextView.text.length == 0 || self.footView.contentTextView.text.length == 0) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"任务标题和任务内容不能为空！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
        return;
    }

    
    // 提示框
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您确定要下达新的抽查任务吗？" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确定", nil];
    alert.tag = 334281;
    alert.delegate = self;
    [alert show];
}

- (void)closeBackGroundView
{
    [UIView animateWithDuration:0.3 animations:^{
        _backGroundView.alpha = .0f;
        _pickBackView.alpha = 0.0f;
    } completion:^(BOOL finished) {
        [_backGroundView removeFromSuperview];
        [_datePicker removeFromSuperview];
        [_pickBackView removeFromSuperview];
        _backGroundView = nil;
        _datePicker = nil;
        _pickBackView = nil;
    }];
}

- (void)okClick:(UIButton *)sender
{
    NSDate *select = [_datePicker date];
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd"];
    
    NSDate *now = [NSDate date];
    NSDate *anDayAgo = [now dateByAddingTimeInterval:-60*60*24];
    NSDate *result2 = [now earlierDate:anDayAgo];
    NSComparisonResult result3 = [select compare:result2];
    if (result3 == -1) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"截止时间不能小于当前时间！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    } else {
        _dateStr = [dateFormatter stringFromDate:select];
        [self closeBackGroundView];
        [self.tableView reloadData];
    }
}

#pragma mark - SelectStoreDelegate
- (void)deliverWithArray:(NSMutableArray *)array
{
    NSString *nameStr = @"";
    _uuidArray = [NSMutableArray array];
    
    if (array.count == 0) {
        _storeName = @"全部";
    } else {
        for (TreeNodeModel *model in array) {
            nameStr = [nameStr stringByAppendingString:[NSString stringWithFormat:@"%@,", model.name]];
            NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:model.uuid , @"store_uuid", model.code , @"store_code", model.name , @"store_name", nil];
            [_uuidArray addObject:dict];
        }
        _storeName = nameStr;
    }
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    [self.tableView reloadRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
}

#pragma mark - TableView Delegate/DateSource
- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (alertView.tag == 334281) {
        if (buttonIndex == 1) {
            
            
            NSDate *date = [NSDate date];
            NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
            [dateFormatter setDateFormat:@"YYYY-MM-dd hh:mm:ss"];
            NSString *dateString = [dateFormatter stringFromDate:date];
            
            NSString *operId = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_code"];
            NSString *operName = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"];
            
            
            NSString *url = [NSString stringWithFormat:@"%@%@%@&operId=%@&operName=%@", kRedStarURL, kSaveSportcheckURL, dateString, operId, operName];
            url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
            HttpClient *httpClient= [[HttpClient alloc] initWithUrl:url];
            
            NSLog(@"_uuid == %@", _uuidArray);
            NSDictionary *parameters = @{@"title":self.footView.titleTextView.text,
                                         @"content":self.footView.contentTextView.text,
                                         @"endDate":_dateStr,
                                         @"state":@"initial",
                                         @"stores":_uuidArray};
            
            [httpClient saveSportCheckWithParameters:parameters completion:^(id response, NSError *error) {
            
                if ([response[@"message"] isEqualToString:@"ok"]) {
                    
                    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"下达任务成功！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
                    alert.tag = 334285;
                    [alert show];
                }

            }];
        }
    }
    
    
    if (alertView.tag == 334285) {
        if (buttonIndex == 0) {
            [self.navigationController popViewControllerAnimated:YES];
        }
    }

}

#pragma mark - TableView Delegate/DateSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _titleArray.count;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    OnLineTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kOnLineTableViewCell];
    if (!cell) {
        cell = [[OnLineTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kOnLineTableViewCell];
    }
    cell.titleLabel.text = [NSString stringWithFormat:@"%@", _titleArray[indexPath.row]];
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    if (indexPath.row == 0) {
        cell.selectLabel.text = [NSString stringWithFormat:@"%@", _storeName];
    } else {
        cell.selectLabel.text = [NSString stringWithFormat:@"%@", _dateStr];
    }
    
    return cell;
    
    
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 50;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        SelectStoreViewController *select = [[SelectStoreViewController alloc] init];
        select.delegate = self;
        [self.navigationController pushViewController:select animated:YES];
    } else {
        
        if (!_backGroundView) {
            _backGroundView = [[UIView alloc] initWithFrame:self.view.bounds];
            UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeBackGroundView)];
            [_backGroundView addGestureRecognizer:tapGR];
        }
        
        
        if (!_pickBackView) {
            _pickBackView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 280, 190)];
            _pickBackView.backgroundColor = [UIColor whiteColor];
            _pickBackView.center = CGPointMake(self.view.center.x, self.view.center.y - 120);
            _pickBackView.alpha = 0.0;
            
            UIButton *okButton = [[UIButton alloc] initWithFrame:CGRectMake(140, 150, 140, 40)];
            [okButton setTitle:@"确定" forState:UIControlStateNormal];
            okButton.titleLabel.font = [UIFont systemFontOfSize:15.0];
            [okButton setTitleColor:kLightBlack forState:UIControlStateNormal];
            [okButton addTarget:self action:@selector(okClick:) forControlEvents:UIControlEventTouchUpInside];
            [_pickBackView addSubview:okButton];
            
            UIButton *quitButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 150, 140, 40)];
            [quitButton setTitle:@"取消" forState:UIControlStateNormal];
            quitButton.titleLabel.font = [UIFont systemFontOfSize:15.0];
            [quitButton setTitleColor:kLightBlack forState:UIControlStateNormal];
            [quitButton addTarget:self action:@selector(closeBackGroundView) forControlEvents:UIControlEventTouchUpInside];
            [_pickBackView addSubview:quitButton];
            
        }
        
        if (!_datePicker) {
            _datePicker = [[UIDatePicker alloc] initWithFrame:CGRectMake(0, 0, 280, 150)];
            _datePicker.datePickerMode = UIDatePickerModeDate;
            [_pickBackView addSubview:_datePicker];
        }
        _backGroundView.alpha = 0;
        _backGroundView.backgroundColor = [UIColor blackColor];
        [self.view insertSubview:_backGroundView aboveSubview:_tableView];
        [self.view insertSubview:_pickBackView aboveSubview:_backGroundView];
        
       
        
        [UIView animateWithDuration:0.3 animations:^{
            _backGroundView.alpha = 0.6;
            _pickBackView.alpha = 1.0;
        }];
    }
    
    
}

#pragma mark - lazy loading

- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (OnLineFooterView *)footView
{
    if (!_footView) {
        if (kScreenHeight == 480) {
            _footView = [[OnLineFooterView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 400)];
        } else {
            _footView = [[OnLineFooterView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, (kScreenHeight - 100 - 64))];
        }
        [_footView.saveButton addTarget:self action:@selector(saveClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _footView;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
