//
//  LargePictureViewController.m
//  redstar
//
//  Created by admin on 16/1/8.
//  Copyright © 2016年 ZWF. All rights reserved.
//

#import "LargePictureViewController.h"
#import <UIImageView+WebCache.h>

@interface LargePictureViewController ()

@property float scale_;

@end

@implementation LargePictureViewController

@synthesize imageScrollView;
@synthesize scale_;

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    offset = 0.0;
    scale_ = 1.0;
    
    self.view.backgroundColor = [UIColor whiteColor];
    self.imageScrollView = [[UIScrollView alloc] initWithFrame:CGRectMake(-20, 0, (kScreenWidth + 40), (kScreenHeight - 20))];
    self.imageScrollView.backgroundColor = [UIColor whiteColor];
    self.imageScrollView.scrollEnabled = YES;
    self.imageScrollView.pagingEnabled = YES;
    self.imageScrollView.delegate = self;
    //self.imageScrollView.contentSize = CGSizeMake((kScreenWidth + 40) * _allImageArray.count, (kScreenHeight - 20));
    self.imageScrollView.contentSize = CGSizeMake((kScreenWidth + 40) * _allImageArray.count, 0);

    self.imageScrollView.contentOffset = CGPointMake(self.index * (kScreenWidth + 40), 0);
    
    for (int i = 0; i < _allImageArray.count; i++){
        UITapGestureRecognizer *doubleTap =[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(handleDoubleTap:)];
        [doubleTap setNumberOfTapsRequired:2];
        
        UIScrollView *s = [[UIScrollView alloc] initWithFrame:CGRectMake((kScreenWidth + 40) * i, 0, (kScreenWidth + 40), (kScreenHeight - 20))];
        s.backgroundColor = [UIColor whiteColor];
        s.contentSize = CGSizeMake((kScreenWidth + 40), 0);

        s.showsHorizontalScrollIndicator = NO;
        s.showsVerticalScrollIndicator = NO;
        s.delegate = self;
        s.minimumZoomScale = 1.0;
        s.maximumZoomScale = 3.0;
        s.tag = i+1;
        [s setZoomScale:1.0];
        
        UIImageView *imageview = [[UIImageView alloc] init];
        
        [imageview setContentMode:UIViewContentModeScaleAspectFit];

        if (self.pictureSaveMode == PictureLocalMode) {
            NSString *imageName = _allImageArray[i];
            NSString *fullPath = [[NSHomeDirectory() stringByAppendingPathComponent:@"Documents"] stringByAppendingPathComponent:imageName];
            UIImage *image = [UIImage imageWithContentsOfFile:fullPath];
            imageview.image = image;
        } else if (self.pictureSaveMode == PictureNetWorkMode) {
            [imageview sd_setImageWithURL:_allImageArray[i] placeholderImage:[UIImage imageNamed:@"default_pic"]];
        } else {
            NSString *imageName = _allImageArray[i];
            NSString *fullPath = [[[NSHomeDirectory() stringByAppendingPathComponent:@"Documents"] stringByAppendingPathComponent:_uuid] stringByAppendingPathComponent:imageName];
            UIImage *image = [UIImage imageWithContentsOfFile:fullPath];
            imageview.image = image;
        }
        imageview.frame = CGRectMake(20, 0, kScreenWidth, (kScreenHeight - 20));
        imageview.userInteractionEnabled = YES;
        imageview.tag = i+1;
        [imageview addGestureRecognizer:doubleTap];
        [s addSubview:imageview];
      
        
        [self.imageScrollView addSubview:s];
       
    }
    
    [self.view addSubview:self.imageScrollView];
    
}


#pragma mark - ScrollView delegate
-(UIView *)viewForZoomingInScrollView:(UIScrollView *)scrollView{
    
    for (UIView *v in scrollView.subviews){
        return v;
    }
    return nil;
}

-(void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView{
    
    if (scrollView == self.imageScrollView){
        CGFloat x = scrollView.contentOffset.x;
        if (x==offset){
            
        }
        else {
            offset = x;
            for (UIScrollView *s in scrollView.subviews){
                if ([s isKindOfClass:[UIScrollView class]]){
                    [s setZoomScale:1.0];
                    UIImageView *image = [[s subviews] objectAtIndex:0];
                    image.frame = CGRectMake(20, 0, kScreenWidth, (kScreenHeight - 20));
                }
            }
        }
    }
}



-(void)scrollViewDidZoom:(UIScrollView *)scrollView{
    UIView *v = [scrollView.subviews objectAtIndex:0];
    if ([v isKindOfClass:[UIImageView class]]){
        if (scrollView.zoomScale<1.0){
            //         v.center = CGPointMake(scrollView.frame.size.width/2.0, scrollView.frame.size.height/2.0);
        }
    }
}

#pragma mark -
- (void)handleDoubleTap:(UIGestureRecognizer *)gesture{
    
    float newScale = [(UIScrollView*)gesture.view.superview zoomScale] * 1.5;
    CGRect zoomRect = [self zoomRectForScale:newScale  inView:(UIScrollView*)gesture.view.superview withCenter:[gesture locationInView:gesture.view]];
    UIView *view = gesture.view.superview;
    if ([view isKindOfClass:[UIScrollView class]]){
        UIScrollView *s = (UIScrollView *)view;
        [s zoomToRect:zoomRect animated:YES];
    }
}

#pragma mark - Utility methods

-(CGRect)zoomRectForScale:(float)scale inView:(UIScrollView*)scrollView withCenter:(CGPoint)center {
    
    CGRect zoomRect;
    
    zoomRect.size.height = [scrollView frame].size.height / scale;
    zoomRect.size.width  = [scrollView frame].size.width  / scale;
    
    zoomRect.origin.x    = center.x - (zoomRect.size.width  / 2.0);
    zoomRect.origin.y    = center.y - (zoomRect.size.height / 2.0);
    
    return zoomRect;
}

-(CGRect)resizeImageSize:(CGRect)rect{
    CGRect newRect;
    
    CGSize newSize;
    CGPoint newOri;
    
    CGSize oldSize = rect.size;
    if (oldSize.width>=kScreenWidth || oldSize.height>=(kScreenHeight - 20)){
        float scale = (oldSize.width/kScreenWidth>oldSize.height/(kScreenHeight - 20)?oldSize.width/kScreenWidth:oldSize.height/(kScreenHeight - 20));
        newSize.width = oldSize.width/scale;
        newSize.height = oldSize.height/scale;
    }
    else {
        newSize = oldSize;
    }
    newOri.x = (kScreenWidth-newSize.width)/2.0;
    newOri.y = ((kScreenHeight - 20)-newSize.height)/2.0;
    
    newRect.size = newSize;
    newRect.origin = newOri;
    
    return newRect;
}

@end
