//
//  CheckPicViewController.m
//  PTools
//
//  Created by 侯振兴 on 15/8/11.
//  Copyright (c) 2015年 moobox. All rights reserved.
//

#import "CheckPicViewController.h"

@interface CheckPicViewController ()<UIScrollViewDelegate> {
    CGFloat _imageViewW;
    CGFloat _imageViewH;

}

@property (nonatomic, strong) UIImageView *takeImageView;
@property (nonatomic, strong) UIScrollView *scrollView;
@end

@implementation CheckPicViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    CGFloat imageW = self.checkImage.size.width;
    CGFloat imageH = self.checkImage.size.height;
    
    //CGFloat imageViewW,imageViewH;
    
    if ((imageH / imageW) > (kScreenHeight / kScreenWidth)) {
        _imageViewH = kScreenHeight;
        _imageViewW = imageW * (kScreenHeight / imageH);
    } else {
        _imageViewH = imageH * (kScreenWidth / imageW);
        _imageViewW = kScreenWidth;
    }
    
    
    self.takeImageView = [[UIImageView alloc] initWithFrame:CGRectMake(0, 0, _imageViewW, _imageViewH)];
    _takeImageView.center = CGPointMake(kScreenWidth / 2, (kScreenHeight - 64) / 2);
    _takeImageView.image = _checkImage;
    _takeImageView.userInteractionEnabled = YES;
    [self.view addSubview:_takeImageView];
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
//    self.scrollView.frame = CGRectMake(0, 0, _imageViewW, _imageViewH);
//    _scrollView.center = CGPointMake(kScreenWidth / 2, (kScreenHeight - 64) / 2);
//    self.scrollView.contentSize = CGSizeMake(_imageViewW, _imageViewH);


}
-(void)doBack:(id)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}


- (void) addGestureRecognizerToView:(UIView *)view {
    // 缩放手势
    UIPinchGestureRecognizer *pinchGestureRecognizer = [[UIPinchGestureRecognizer alloc] initWithTarget:self action:@selector(pinchView:)];
    [view addGestureRecognizer:pinchGestureRecognizer];
    
    // 移动手势
    UIPanGestureRecognizer *panGestureRecognizer = [[UIPanGestureRecognizer alloc] initWithTarget:self action:@selector(panView:)];
    [view addGestureRecognizer:panGestureRecognizer];
}

// 处理缩放手势
- (void) pinchView:(UIPinchGestureRecognizer *)pinchGestureRecognizer {
    UIView *view = pinchGestureRecognizer.view;
    if (pinchGestureRecognizer.state == UIGestureRecognizerStateBegan || pinchGestureRecognizer.state == UIGestureRecognizerStateChanged) {
        view.transform = CGAffineTransformScale(view.transform, pinchGestureRecognizer.scale, pinchGestureRecognizer.scale);
        if (_takeImageView.frame.size.width < _imageViewW) {
            _takeImageView.frame = CGRectMake(0, (kScreenHeight - 64 - _imageViewH) / 2 , _imageViewW, _imageViewH);
            //让图片无法缩得比原图小
        }
        if (_takeImageView.frame.size.width > 2 * _imageViewW) {
            _takeImageView.frame = CGRectMake(-_imageViewW, -_imageViewH, 2 * _imageViewW, 2 * _imageViewH);
        }
        pinchGestureRecognizer.scale = 1;
    }
    
}

// 处理拖拉手势
- (void) panView:(UIPanGestureRecognizer *)panGestureRecognizer
{
    UIView *view = panGestureRecognizer.view;
    if (panGestureRecognizer.state == UIGestureRecognizerStateBegan || panGestureRecognizer.state == UIGestureRecognizerStateChanged) {
        CGPoint translation = [panGestureRecognizer translationInView:view.superview];
        [view setCenter:(CGPoint){view.center.x + translation.x, view.center.y + translation.y}];
        [panGestureRecognizer setTranslation:CGPointZero inView:view.superview];
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


- (UIScrollView *)scrollView
{
    if (!_scrollView) {
        _scrollView = [[UIScrollView alloc] init];
        _scrollView.delegate = self;
        _scrollView.maximumZoomScale = 2.0;
        _scrollView.minimumZoomScale = 1.0;
        [self.view addSubview:_scrollView];
    }
    return _scrollView;
}


-(UIView *)viewForZoomingInScrollView:(UIScrollView *)scrollView
{
    return _takeImageView;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
