//
//  StarBar.m
//  redstar
//
//  Created by admin on 15/11/6.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "StarBar.h"

#define ZOOM 0.7f

@interface StarBar ()

@property (nonatomic,strong) UIView *bottomView;
@property (nonatomic,strong) UIView *topView;
@property (nonatomic,assign) CGFloat starWidth;
@end

@implementation StarBar

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        
        self.backgroundColor = [UIColor whiteColor];
        self.userInteractionEnabled = YES;
        
        self.bottomView = [[UIView alloc] initWithFrame:self.bounds];
        self.bottomView.userInteractionEnabled = NO;
        [self addSubview:self.bottomView];

        self.topView = [[UIView alloc] initWithFrame:CGRectZero];
        self.topView.clipsToBounds = YES;
        self.topView.userInteractionEnabled = NO;
        [self addSubview:self.topView];
        
        // 添加手势
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tap:)];
        UIPanGestureRecognizer *pan = [[UIPanGestureRecognizer alloc] initWithTarget:self action:@selector(pan:)];
        [self addGestureRecognizer:tap];
        [self addGestureRecognizer:pan];
        
        CGFloat width = frame.size.width/7.0;
        self.starWidth = width;
        for(int i = 0;i<5;i++){
            UIImageView *img = [[UIImageView alloc] initWithFrame:CGRectMake(0, 0, frame.size.height * ZOOM, frame.size.height * ZOOM)];
            img.center = CGPointMake((i+1.5)*width, frame.size.height/2);
            img.image = [UIImage imageNamed:@"star_before"];
            [self.bottomView addSubview:img];
            UIImageView *img2 = [[UIImageView alloc] initWithFrame:img.frame];
            img2.center = img.center;
            img2.image = [UIImage imageNamed:@"star_after"];
            [self.topView addSubview:img2];
        }
        self.enable = YES;
    }
    return self;
}

- (void)setStarNumber:(NSInteger)starNumber
{
    if (_starNumber != starNumber) {
        _starNumber = starNumber;
        self.topView.frame = CGRectMake(0, 0, self.starWidth*(starNumber+1), self.bounds.size.height);
    }
}

- (void)tap:(UITapGestureRecognizer *)gesture
{
    if (self.enable) {
        CGPoint point = [gesture locationInView:self];
        NSInteger count = (int)(point.x / self.starWidth)+1;
        self.topView.frame = CGRectMake(0, 0, self.starWidth * count, self.bounds.size.height);
        if (count > 5) {
            _starNumber = 5;
        } else {
            _starNumber = count - 1;
        }
    }
}

- (void)pan:(UIPanGestureRecognizer *)gesture
{
    if (self.enable) {
        CGPoint point = [gesture locationInView:self];
        NSInteger count = (int)(point.x/self.starWidth);
        if (count >= 0 && count <= 5 && _starNumber != count) {
            self.topView.frame = CGRectMake(0, 0, self.starWidth * (count + 1), self.bounds.size.height);
            _starNumber = count;
        }
    }
}


@end
