//
//  CustomDropMenuView.m
//  redstar
//
//  Created by admin on 15/10/25.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "CustomDropMenuView.h"

@interface CustomDropMenuView ()
/**
 *  将来用来显示具体内容的容器
 */
@property (nonatomic, weak) UIView *showView;
@end

@implementation CustomDropMenuView

// 便利构造器
+ (instancetype)defaultMenuView
{
    return [[self alloc] init];
}

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // 清除颜色
        self.backgroundColor = [UIColor clearColor];
    }
    return self;
}

/**
 *  重写setter方法
 */
- (void)setContent:(UIView *)content
{
    _content = content;
    
    // 调整内容的位置
    content.x = 10;
    content.y = 15;

    // 添加内容到灰色图片中
    [self.showView addSubview:content];
    
    // 顶端
    NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:content attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.showView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [self.showView addConstraint:contentTop];
    
    // 左边
    NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:content attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.showView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [self.showView addConstraint:contentLeft];
    
    // 右边
    NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:content attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.showView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self.showView addConstraint:contentRight];
    
    // 高度
    NSLayoutConstraint *contentBottom = [NSLayoutConstraint constraintWithItem:content attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.showView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self.showView addConstraint:contentBottom];
    
}

- (void)setContentController:(UIViewController *)contentController
{
    _contentController = contentController;
    self.content = contentController.view;
}

/**
 *  显示
 */
- (void)showFrom:(UIView *)from
{
    // 1.获得最上面的窗口
    UIWindow *window = [[UIApplication sharedApplication].windows lastObject];
    
    // 2.添加自己到窗口上
    [window addSubview:self];
    
    // 3.设置尺寸
    self.frame = window.bounds;
    
    // 通知外界，自己显示了
    if ([self.delegate respondsToSelector:@selector(dropdownMenuDidShow:)]) {
        [self.delegate dropdownMenuDidShow:self];
    }
}

/**
 *  销毁
 */
- (void)dismiss
{
    [self removeFromSuperview];
    
    // 通知外界，自己被销毁了
    if ([self.delegate respondsToSelector:@selector(dropdownMenuDidDismiss:)]) {
        [self.delegate dropdownMenuDidDismiss:self];
    }
}

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{
    [self dismiss];
}

- (UIView *)showView
{
    if (!_showView) {
        // 添加一个灰色图片控件
        UIView *showView = [[UIView alloc] init];
        showView.backgroundColor = [UIColor clearColor];
        showView.userInteractionEnabled = YES; // 开启交互
        showView.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:showView];
        
        
        // 顶端
        NSLayoutConstraint *showTop = [NSLayoutConstraint constraintWithItem:showView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:self.showTop];
        [self addConstraint:showTop];
        
        // 左边
        NSLayoutConstraint *showViewLeft = [NSLayoutConstraint constraintWithItem:showView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:self.showLeft];
        [self addConstraint:showViewLeft];
        
        // 右边
        NSLayoutConstraint *showViewRight = [NSLayoutConstraint constraintWithItem:showView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:self.showRight];
        [self addConstraint:showViewRight];
        
        // 高度
        NSLayoutConstraint *showViewHeight = [NSLayoutConstraint constraintWithItem:showView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:self.showHeight];
        [showView addConstraint:showViewHeight];
        
        self.showView = showView;

    }
    
    
    return _showView;
}



/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
