//
//  RankScreenTableViewCell.m
//  redstar
//
//  Created by admin on 15/12/16.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankScreenTableViewCell.h"

@implementation RankScreenTableViewCell

- (UILabel *)queryLabel
{
    if (!_queryLabel) {
        _queryLabel = [[UILabel alloc] init];
        _queryLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _queryLabel.textAlignment = NSTextAlignmentLeft;
        [self.contentView addSubview:_queryLabel];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_queryLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_queryLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_queryLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.screenButton attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_queryLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:55];
        [self.contentView addConstraint:contentHeight];
        
        NSLayoutConstraint *contentBottom = [NSLayoutConstraint constraintWithItem:_queryLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:contentBottom];
    }
    return _queryLabel;
}
- (UIButton *)screenButton
{
    if (!_screenButton) {
        _screenButton = [[UIButton alloc] init];
        _screenButton.translatesAutoresizingMaskIntoConstraints = NO;
        _screenButton.titleLabel.font = [UIFont systemFontOfSize:17.0];
        [_screenButton setTitle:@"确定" forState:UIControlStateNormal];
        [_screenButton setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        _screenButton.layer.borderWidth = 1.0;
        _screenButton.layer.borderColor = kNavigationBarCGColor;
        _screenButton.layer.cornerRadius = 4.0;
        [self.contentView addSubview:_screenButton];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_screenButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.contentView addConstraint:contentTop];
        
        NSLayoutConstraint *contentWidth = [NSLayoutConstraint constraintWithItem:_screenButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:120];
        [self.contentView addConstraint:contentWidth];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_screenButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_screenButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
        [self.contentView addConstraint:contentHeight];
        
        
    }
    return _screenButton;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
