//
//  RankHeadView.m
//  redstar
//
//  Created by admin on 15/11/12.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankHeadView.h"
#import "TaskGroup.h"

@interface RankHeadView ()
{
    UIButton *_bgButton;
    UIImageView *_arrowImageView;
    UILabel *_scoreLabel; // 分数
    UILabel *_gradeLabel; // 排名
    UIView *_lineView;
}
@end

@implementation RankHeadView

+ (instancetype)headViewWithTableView:(UITableView *)tableView
{
    static NSString *headIdentifier = @"header";
    
    RankHeadView *headView = (RankHeadView *)[tableView dequeueReusableCellWithIdentifier:headIdentifier];
    if (headView == nil) {
        headView = [[RankHeadView alloc] initWithReuseIdentifier:headIdentifier];
    }
    
    return headView;
}

- (id)initWithReuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithReuseIdentifier:reuseIdentifier]) {
        UIButton *bgButton = [UIButton buttonWithType:UIButtonTypeCustom];
        bgButton.backgroundColor = [UIColor whiteColor];
        bgButton.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
        bgButton.contentEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 10);
        bgButton.titleEdgeInsets = UIEdgeInsetsMake(0, 20, 0, 0);
        bgButton.titleLabel.font = [UIFont systemFontOfSize:18.0];
        [bgButton setTitleColor:kAnnounceTextColor forState:UIControlStateNormal];
        [bgButton addTarget:self action:@selector(headBtnClick) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:bgButton];
        _bgButton = bgButton;
        
        UIImageView *arrowIMView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"arrow_down"]];
        [self addSubview:arrowIMView];
        _arrowImageView = arrowIMView;
        
        UILabel *scoreLabel = [[UILabel alloc] init];
        scoreLabel.textAlignment = NSTextAlignmentCenter;
        [self addSubview:scoreLabel];
        _scoreLabel = scoreLabel;
        
        UILabel *gradeLabel = [[UILabel alloc] init];
        gradeLabel.textAlignment = NSTextAlignmentCenter;
        [self addSubview:gradeLabel];
        _gradeLabel = gradeLabel;
        
        UIView *lineView = [[UIView alloc] init];
        lineView.backgroundColor = kSeparateLineColor;
        [self addSubview:lineView];
        _lineView = lineView;
    }
    return self;
}

- (void)headBtnClick
{
    _taskGroup.opened = !_taskGroup.isOpened;
    if ([_delegate respondsToSelector:@selector(clickRankHeadView)]) {
        [_delegate clickRankHeadView];
    }
}

- (void)setTaskGroup:(TaskGroup *)taskGroup
{
    _taskGroup = taskGroup;
    
    [_bgButton setTitle:taskGroup.category forState:UIControlStateNormal];
    NSString *scoreStr = nil;
    if (taskGroup.score == NULL || taskGroup.score == nil) {
        scoreStr = @"0 分";
    } else {
        scoreStr = [NSString stringWithFormat:@"%@ 分", taskGroup.score];
    }
    
    NSMutableAttributedString *scoreAttr = [[NSMutableAttributedString alloc] initWithString:scoreStr];
    [scoreAttr addAttributes:@{NSForegroundColorAttributeName:kNavigationBarColor,NSFontAttributeName:[UIFont systemFontOfSize:19.0f]} range:NSMakeRange(0,scoreAttr.length - 1)];
    [scoreAttr addAttributes:@{NSForegroundColorAttributeName:kDetailSmallTitleColor, NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(scoreAttr.length - 1,1)];
    [_scoreLabel setAttributedText:scoreAttr];
    
    NSString *rankStr = nil;
    if (taskGroup.score == NULL || taskGroup.score == nil) {
        rankStr = @"0 分";
    } else {
        rankStr = [NSString stringWithFormat:@"第 %@ 名", taskGroup.ranking];
    }
    NSMutableAttributedString *rankAttr = [[NSMutableAttributedString alloc] initWithString:rankStr];
    [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,1)];
    [rankAttr addAttributes:@{NSForegroundColorAttributeName:kGradeNumberTextColor} range:NSMakeRange(1,rankStr.length - 2)];
    [rankAttr addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"Arial-BoldMT" size:18.0] range:NSMakeRange(1,rankStr.length - 2)];
    [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(rankStr.length - 1,1)];
    [_gradeLabel setAttributedText:rankAttr];
}



- (void)didMoveToSuperview
{
    _arrowImageView.transform = _taskGroup.isOpened ? CGAffineTransformMakeRotation(M_PI) : CGAffineTransformMakeRotation(0);
    _lineView.hidden = _taskGroup.isOpened ? YES : NO;
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    
    _bgButton.frame = self.bounds;
    _scoreLabel.frame = CGRectMake(self.frame.size.width - 193, 0, 80, self.frame.size.height);
    _gradeLabel.frame = CGRectMake(self.frame.size.width - 113, 0, 80, self.frame.size.height);
    _arrowImageView.frame = CGRectMake(self.frame.size.width - 33, (self.frame.size.height - 8) / 2, 13, 8);
    _lineView.frame = CGRectMake(0, self.frame.size.height - 1, self.frame.size.width, 1);
}


@end
