//
//  QuestionListTableCell.m
//  redstar
//
//  Created by admin on 15/11/2.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "QuestionListTableCell.h"

@implementation QuestionListTableCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setup
{
    self.titleLabel.textColor = kQuestionCellTitleColor;
    
}

- (void)setQuestion:(QuestionModel *)question
{
    _question = question;
    
    // 标题
    self.titleLabel.text = [NSString stringWithFormat:@"%@",question.title];
    // 反馈(副标题)
    self.detailsLabel.text = [NSString stringWithFormat:@"%@", question.content];
    // 服务类型
    self.stateLabel.text = [NSString stringWithFormat:@"%@", question.category];
    // 提报时间
    self.dateLabel.text = [NSString stringWithFormat:@"提报时间：%@", question.submitTime];
    // 点赞数
    [self.thumbBtn setTitle:[NSString stringWithFormat:@"%d", question.likeCount] forState:UIControlStateNormal];
    
    if (question.hotspot) {
        self.hotLabel.hidden = NO;
    } else {
        self.hotLabel.hidden = YES;
    }
    
    if (question.myLike) {
        self.thumbBtn.selected = YES;
    } else {
        self.thumbBtn.selected = NO;
    }
}

#pragma mark - lazy laoding
- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.font = [UIFont boldSystemFontOfSize:17.0];
        [self.contentView addSubview:_titleLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.hotLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-15];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentView addConstraint:titleHeight];
    }
    return _titleLabel;
}

- (UILabel *)hotLabel
{
    if (!_hotLabel) {
        _hotLabel = [[UILabel alloc] init];
        _hotLabel.font = [UIFont boldSystemFontOfSize:12.0];
        _hotLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _hotLabel.backgroundColor = kHotBackGroundColor;
        _hotLabel.textColor = [UIColor whiteColor];
        _hotLabel.text = @"HOT";
        _hotLabel.textAlignment = NSTextAlignmentCenter;
        _hotLabel.layer.cornerRadius = 3;
        [self.contentView addSubview:_hotLabel];
        
        // 顶端
        NSLayoutConstraint *hotTop = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:15];
        [self.contentView addConstraint:hotTop];
        
        // 左边
        NSLayoutConstraint *hotWidth = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:34];
        [self.contentView addConstraint:hotWidth];
        
        // 右边
        NSLayoutConstraint *hotRight = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:hotRight];
        
        // 高度
        NSLayoutConstraint *hotHeight = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:15];
        [self.contentView addConstraint:hotHeight];
    }
    return _hotLabel;
}

- (UILabel *)detailsLabel
{
    if (!_detailsLabel) {
        _detailsLabel = [[UILabel alloc] init];
        _detailsLabel.font = [UIFont systemFontOfSize:15.0];
        _detailsLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _detailsLabel.textColor = kQuestionCellTitleColor;
        [self.contentView addSubview:_detailsLabel];
        
        // 顶端
        NSLayoutConstraint *detailsTop = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:detailsTop];
        
        // 左边
        NSLayoutConstraint *detailsLeft = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:detailsLeft];
        
        // 右边
        NSLayoutConstraint *detailsRight = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:detailsRight];
        
        // 高度
        NSLayoutConstraint *detailsHeight = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:detailsHeight];
    }
    return _detailsLabel;
}

- (UILabel *)stateLabel
{
    if (!_stateLabel) {
        _stateLabel = [[UILabel alloc] init];
        _stateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _stateLabel.textColor = kQuestionStateColor;
        _stateLabel.font = [UIFont systemFontOfSize:14.0];

        [self.contentView addSubview:_stateLabel];
        
        // 顶端
        NSLayoutConstraint *stateTop = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.detailsLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:3];
        [self.contentView addConstraint:stateTop];
        
        // 左边
        NSLayoutConstraint *stateLeft = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:stateLeft];
        
        // 右边
        NSLayoutConstraint *stateRight = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:stateRight];
        
        // 高度
        NSLayoutConstraint *stateHeight = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:16];
        [self.contentView addConstraint:stateHeight];
    }
    return _stateLabel;
}

- (UILabel *)dateLabel
{
    if (!_dateLabel) {
        _dateLabel = [[UILabel alloc] init];
        _dateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _dateLabel.textColor = kQuestionStateColor;
        _dateLabel.font = [UIFont systemFontOfSize:14.0];
        [self.contentView addSubview:_dateLabel];
        
        // 顶端
        NSLayoutConstraint *stateTop = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.stateLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:stateTop];
        
        // 左边
        NSLayoutConstraint *stateLeft = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:stateLeft];
        
        // 右边
        NSLayoutConstraint *stateRight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.thumbBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:stateRight];
        
        // 高度
        NSLayoutConstraint *stateHeight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:16];
        [self.contentView addConstraint:stateHeight];
        // 高度
        NSLayoutConstraint *stateBottom = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-8];
        [self.contentView addConstraint:stateBottom];
        
    }
    return _dateLabel;
}

- (ZanButton *)thumbBtn
{
    if (!_thumbBtn) {
        _thumbBtn = [[ZanButton alloc] init];
        _thumbBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _thumbBtn.titleLabel.font = [UIFont systemFontOfSize:15.0];
        [_thumbBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        [_thumbBtn setImage:[UIImage imageNamed:@"commend"] forState:UIControlStateNormal];
        [_thumbBtn setImage:[UIImage imageNamed:@"commend_after"] forState:UIControlStateSelected];
        [self.contentView addSubview:_thumbBtn];
        
        // 顶端
        NSLayoutConstraint *stateTop = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.stateLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:2];
        [self.contentView addConstraint:stateTop];
        
        // 左边
        NSLayoutConstraint *stateWidth = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.contentView addConstraint:stateWidth];
        
        // 右边
        NSLayoutConstraint *stateRight = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-15];
        [self.contentView addConstraint:stateRight];
        
        // 高度
        NSLayoutConstraint *stateHeight = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:stateHeight];
    }
    return _thumbBtn;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
