//
//  QuestionDetailFooterView.m
//  redstar
//
//  Created by admin on 15/11/5.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "QuestionDetailFooterView.h"

@implementation QuestionDetailFooterView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setup
{
    [self.addButon setTitle:@"添加评论" forState:UIControlStateNormal];
}

#pragma mark - lazy loading

- (UIButton *)addButon
{
    if (!_addButon) {
        _addButon = [[UIButton alloc] init];
        
        // 设置圆角
        _addButon.layer.cornerRadius = 5;
        _addButon.translatesAutoresizingMaskIntoConstraints = NO;
        _addButon.backgroundColor = kLoginButtonBackGroundColor;
        [_addButon setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        _addButon.titleLabel.font = [UIFont systemFontOfSize:20.0];
        [self addSubview:_addButon];
        
        // 顶端
        NSLayoutConstraint *loginBottom = [NSLayoutConstraint constraintWithItem:_addButon attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-20];
        [self addConstraint:loginBottom];
        
        // 左边
        NSLayoutConstraint *loginLeft = [NSLayoutConstraint constraintWithItem:_addButon attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:loginLeft];
        
        // 右边
        NSLayoutConstraint *loginRight = [NSLayoutConstraint constraintWithItem:_addButon attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:loginRight];
        
        // 高度
        NSLayoutConstraint *loginHeight = [NSLayoutConstraint constraintWithItem:_addButon attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self addConstraint:loginHeight];
    }
    
    return _addButon;
}

@end
