//
//  PictureViewController.m
//  redstar
//
//  Created by admin on 15/11/1.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "PictureViewController.h"
#import "MenuButton.h"
#import "PictureTableCell.h"

#import "PictureStoryViewController.h"
#import "AddPictureViewController.h"

#import "TaxisView.h"
#import "PicScreenView.h"
#import "MenuView.h"
#import "NoDataView.h"

#import "HttpClient.h"
#import <MBProgressHUD.h>

#import <MJRefresh.h>
#import "PictureListModel.h"


#define kPictureTableViewCell @"pictureTabelViewCell"

@interface PictureViewController () <UITableViewDelegate, UITableViewDataSource, TaxisViewDelegate,ScopeTableViewDelegate, TimeTableViewDelegate >
@property (nonatomic, strong) MenuView *menuView;

@property (nonatomic, strong) TaxisView *taxisView;
@property (nonatomic, strong) PicScreenView *screenView;
@property (nonatomic, strong) MenuButton *selctedButton;

@property (nonatomic, strong) UIView *bgView;
@property (nonatomic, assign) NSInteger selectRow;
@property (nonatomic, assign) NSInteger timeSelectNum;



@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) NoDataView *noDataView;

@property (nonatomic, assign) NSInteger scopeRow;
@property (nonatomic, assign) NSInteger stateRow;
@property (nonatomic, assign) NSInteger timeRow;

@property (nonatomic, strong) NSMutableArray *allPraiseListArray;
@property (nonatomic, assign) int page;
@end

@implementation PictureViewController

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self requestPicturePraise];

}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self setupNav];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    self.menuView.backgroundColor = kInspectSectionBackGroundColor;
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    _page = 0;
}


#pragma mark - Private Methods
- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:self.titleStr];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *rightButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, 60, 20)];
    [rightButton setTitle:@"我要新增" forState:UIControlStateNormal];
    [rightButton addTarget:self action:@selector(addClick:) forControlEvents:UIControlEventTouchUpInside];
    [rightButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    rightButton.titleLabel.font = [UIFont systemFontOfSize:15];
    UIBarButtonItem *rightButtonItem = [[UIBarButtonItem alloc] initWithCustomView:rightButton];
    self.navigationItem.rightBarButtonItem = rightButtonItem;
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
}

-(void)doBack:(id)sender
{
    if ([self.come isEqualToString:@"首页"]) {
        [self.navigationController dismissViewControllerAnimated:YES completion:nil];
    } else {
        [self.navigationController popViewControllerAnimated:YES];
    }
}

- (void)addClick:(UIButton *)sender
{
    
//    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"当前功能正在开发！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
//    [alert show];
    
    NSArray *permissions = [[NSUserDefaults standardUserDefaults] objectForKey:@"permissions"];
    if ([permissions containsObject:@"500303"]) {
        AddPictureViewController *addPic = [[AddPictureViewController alloc] init];
        addPic.category = self.category;
        [self.navigationController pushViewController:addPic animated:YES];

    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您没有新增图说口碑的权限！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
}

- (void)requestPicturePraise
{
    self.allPraiseListArray = [NSMutableArray array];

    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQueryPicturePraiseURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSNumber *pageSize = [[NSUserDefaults standardUserDefaults] objectForKey:@"requestNumber"];

    NSDictionary *parameters = @{
                                 @"scope":@"all",
                                 @"user":user_uuid,
                                 @"type":self.category,
                                 @"pageNumber":@(0),
                                 @"pageSize":pageSize
                                 };
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    __block PictureViewController *weakSelf = self;
    // 请求问题列表
    [httpClient queryPicturePraiseWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *dict in dataArray) {
            PictureListModel *picList = [[PictureListModel alloc] init];
            [picList setValuesForKeysWithDictionary:dict];
            [tempArray addObject:picList];
        }
        _allPraiseListArray = tempArray;
        if (_allPraiseListArray.count == 0) {
            weakSelf.noDataView.backgroundColor = [UIColor whiteColor];
        } else {
            weakSelf.menuView.backgroundColor = kInspectSectionBackGroundColor;
            
            weakSelf.tableView.footer = [MJRefreshBackNormalFooter footerWithRefreshingBlock:^{
                [self requestMoreList];
            }];
            
            
            [weakSelf.tableView reloadData];
        }
        
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];

}

- (void)requestMoreList
{
    _page++;
    
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQueryPicturePraiseURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSNumber *pageSize = [[NSUserDefaults standardUserDefaults] objectForKey:@"requestNumber"];

    NSDictionary *parameters = @{
                                 @"scope":@"all",
                                 @"user":user_uuid,
                                 @"type":self.category,
                                 @"pageNumber":@(_page),
                                 @"pageSize":pageSize
                                 };
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    
    // 请求问题列表
    [httpClient queryPicturePraiseWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *dict in dataArray) {
            PictureListModel *picList = [[PictureListModel alloc] init];
            [picList setValuesForKeysWithDictionary:dict];
            [tempArray addObject:picList];
        }
        [_allPraiseListArray addObjectsFromArray:tempArray];
        
        if (tempArray.count < 10) {
            [self.tableView.footer noticeNoMoreData];
        } else {
            [self.tableView.footer endRefreshing];
        }
        self.menuView.backgroundColor = kInspectSectionBackGroundColor;
        [self.tableView reloadData];
        
    }];

}


- (void)dropCilck:(MenuButton *)sender
{
    sender.isDrop = !sender.isDrop;
    
    if (_selctedButton.tag == sender.tag) {
        if (sender.isDrop) {
            if (sender.tag == 4001) {
                [self showRedView];
            } else {
                [self showGreenView];
            }
            sender.selected = YES;
            
        } else {
            if (sender.tag == 4001) {
                [self closeRedView];
            } else {
                [self closeGreenView];
            }
            sender.selected = NO;
        }
    } else {
        // 前一次选中的按钮 选中状态置为NO
        _selctedButton.selected = NO;
        _selctedButton.isDrop = NO;
        // 进行选中状态为NO 的操作
        //   2.判断当前是否有bgView 有->移除， 没有->跳过
        if (_bgView) {
            // _bgView存在
            [_bgView removeFromSuperview];
            _bgView = nil;
        }
        
        if (_taxisView) {
            [_taxisView removeFromSuperview];
            _taxisView = nil;
        }
        
        if (_screenView) {
            [_screenView removeFromSuperview];
            _screenView = nil;
        }
        
        
        // 将当前选中的按钮设置 选中状态为YES;
        sender.selected = YES;
        // 对选中按钮 进行相关操作
        _selctedButton = (MenuButton *)sender;
        
        if (sender.tag == 4001) {
            [self showRedView];
        } else {
            [self showGreenView];
        }
    }
}

- (void)showRedView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:CGRectMake(0, 45, kScreenWidth,  kScreenHeight - 45)];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeRedView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_taxisView) {
        _taxisView = [[TaxisView alloc] init];
        _taxisView.backgroundColor = [UIColor whiteColor];
    }
    
    _taxisView.delegate = self;
    [self.view addSubview:_bgView];
    [self.view insertSubview:_taxisView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, kTaxisViewHeight);
    _taxisView.alpha = 0.0;
    _taxisView.frame = toFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _taxisView.alpha = 1.0;
    }];
    
}

- (void)closeRedView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _taxisView.alpha = 0.0;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_taxisView removeFromSuperview];
    }];
}


- (void)showGreenView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:CGRectMake(0,64 + 45, kScreenWidth,  kScreenHeight - 64 - 45)];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeGreenView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_screenView) {
        _screenView = [[PicScreenView alloc] init];
        _screenView.scopeTableView.scopeDeleagte = self;
        _screenView.timeTableView.timeDeleagte = self;
        _screenView.backgroundColor = [UIColor whiteColor];
    }
    [_screenView.resetBtn addTarget:self action:@selector(resetClick:) forControlEvents:UIControlEventTouchUpInside];
    [_screenView.submitBtn addTarget:self action:@selector(submitClick:) forControlEvents:UIControlEventTouchUpInside];
    
    [self.view addSubview:_bgView];
    [self.view insertSubview:_screenView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, 260);
    _screenView.alpha = 0.0;
    _screenView.frame = toFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _screenView.alpha = 1.0;
    }];
    
}

- (void)closeGreenView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _screenView.alpha = 0.0;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_screenView removeFromSuperview];
    }];
}

// 重置按钮
- (void)resetClick:(UIButton *)sender
{
    NSInteger selectedIndex = 0;
    NSIndexPath *selectedIndexPath = [NSIndexPath indexPathForRow:selectedIndex inSection:0];
    [_screenView.scopeTableView selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [_screenView.timeTableView selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    
    _screenView.textView1.text = @"";
    _screenView.textView2.text = @"";
    
    
}
// 提交按钮
- (void)submitClick:(UIButton *)sender
{
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQueryPicturePraiseURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSNumber *pageSize = [[NSUserDefaults standardUserDefaults] objectForKey:@"requestNumber"];
    
    NSMutableDictionary *parameters = [NSMutableDictionary dictionaryWithObjectsAndKeys:
                                       user_uuid,@"user",
                                       @(0),@"pageNumber",
                                       pageSize,@"pageSize",
                                       self.category,@"type",
                                       @"all",@"scope",
                                       nil];
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    //
    __block PictureViewController *weakSelf = self;
    
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    if (_screenView.groupTabBar.selectNumber == 0) {
        if (_scopeRow == 0) {
            [parameters setObject:@"all" forKey:@"scope"];
        } else {
            [parameters setObject:@"mine" forKey:@"scope"];
        }
        NSArray *array = @[@{@"field":@"scope",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];
    } else if (_screenView.groupTabBar.selectNumber == 1) {
        [parameters setObject:_screenView.textView1.text forKey:@"contentLike"];
        NSArray *array = @[@{@"field":@"title",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];
        
    } else if (_screenView.groupTabBar.selectNumber == 2) {
        [parameters setObject:_screenView.textView2.text forKey:@"keyword"];
        NSArray *array = @[@{@"field":@"keyword",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];
        
    } else if (_screenView.groupTabBar.selectNumber == 3) {
        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
        
        // 当前时间
        NSDate *today = [NSDate date];
        NSString *todayStr = [dateFormatter stringFromDate:today];
        if (_timeRow == 0) {
            
        } else if (_timeRow == 1) {
            
            NSDate *week = [today dateByAddingTimeInterval:-60*60*24*7];
            NSString *weekStr = [dateFormatter stringFromDate:week];
            
            [parameters setObject:weekStr forKey:@"submitTimeFrom"];
            [parameters setObject:todayStr forKey:@"submitTimeTo"];
        } else if (_timeRow == 2) {
            
            NSDate *oneMonth = [self getPriousorLaterDateFromDate:today withMonth:-1];
            NSString *oneMonthStr = [dateFormatter stringFromDate:oneMonth];
            
            [parameters setObject:oneMonthStr forKey:@"submitTimeFrom"];
            [parameters setObject:todayStr forKey:@"submitTimeTo"];
            
        } else if (_timeRow == 3) {
            NSDate *threeMonth = [self getPriousorLaterDateFromDate:today withMonth:-3];
            NSString *threeMonthStr = [dateFormatter stringFromDate:threeMonth];
            
            [parameters setObject:threeMonthStr forKey:@"submitTimeFrom"];
            [parameters setObject:todayStr forKey:@"submitTimeTo"];
        } else if (_timeRow == 4) {
            NSDate *oneYear = [self getPriousorLaterDateFromDate:today withMonth:-12];
            NSString *oneYearStr = [dateFormatter stringFromDate:oneYear];
            
            [parameters setObject:oneYearStr forKey:@"submitTimeFrom"];
            [parameters setObject:todayStr forKey:@"submitTimeTo"];
        } else {
            NSDate *oneYear = [self getPriousorLaterDateFromDate:today withMonth:-12];
            NSString *oneYearStr = [dateFormatter stringFromDate:oneYear];
            [parameters setObject:oneYearStr forKey:@"submitTimeTo"];
        }
        
        NSArray *array = @[@{@"field":@"submitTime",
                             @"direction":@"asc"}];
        [parameters setObject:array forKey:@"queryOrders"];
    }
    
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *pictureDict in recordsDict) {
            PictureListModel *picture = [[PictureListModel alloc] init];
            [picture setValuesForKeysWithDictionary:pictureDict];
            [tempArray addObject:picture];
        }
        _allPraiseListArray = tempArray;
        
        if (_allPraiseListArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            weakSelf.noDataView.backgroundColor = [UIColor whiteColor];
            [weakSelf closeGreenView];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            weakSelf.tableView.delegate = weakSelf;
            weakSelf.tableView.dataSource = weakSelf;
            [weakSelf.tableView reloadData];
            [weakSelf closeGreenView];
        }
        [MBProgressHUD hideHUDForView:weakSelf.view animated:YES];
        self.menuView.backgroundColor = kInspectSectionBackGroundColor;
        
    }];

}

- (NSDate *)getPriousorLaterDateFromDate:(NSDate *)date withMonth:(int)month
{
    NSDateComponents *comps = [[NSDateComponents alloc] init];
    [comps setMonth:month];
    NSCalendar *calender = [[NSCalendar alloc] initWithCalendarIdentifier:NSGregorianCalendar];
    NSDate *mDate = [calender dateByAddingComponents:comps toDate:date options:0];
    return mDate;
}


#pragma mark - MoreScreenDelegate
- (void)scopeTableViewClick:(NSInteger)row
{
    _scopeRow = row;
}


- (void)timeTableViewClick:(NSInteger)row
{
    _timeRow = row;
}


#pragma mark - TaxisDelegate
- (void)timeChange:(UIButton *)sender
{
    _page = 0;
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQueryPicturePraiseURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    
    NSArray *queryOrders;
    if (sender.tag - kTAxisBtnTag == 1) {
        queryOrders = @[];
        
    } else if (sender.tag - kTAxisBtnTag == 2) {
        
        queryOrders = @[@{@"field":@"likeCount",
                          @"direction":@"desc"}];
        
    } else {
        queryOrders = @[@{@"field":@"likeCount",
                          @"direction":@"asc"}];
    }
    NSNumber *pageSize = [[NSUserDefaults standardUserDefaults] objectForKey:@"requestNumber"];
    NSDictionary *parameters = @{@"user":user_uuid,
                                 @"pageNumber":@(_page),
                                 @"pageSize":pageSize,
                                 @"queryOrders":queryOrders,
                                 @"type":self.category,
                                 @"scope":@"all"
                                 };
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    
    // 请求问题列表
    [httpClient queryPicturePraiseWithParameters:parameters completion:^(id response, NSError *error) {
        
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *pictureDict in recordsDict) {
            PictureListModel *picture = [[PictureListModel alloc] init];
            [picture setValuesForKeysWithDictionary:pictureDict];
            [tempArray addObject:picture];
        }
        _allPraiseListArray = tempArray;
        
        if (_allPraiseListArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            self.noDataView.backgroundColor = [UIColor whiteColor];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            self.tableView.delegate = self;
            self.tableView.dataSource = self;
            [self.tableView reloadData];
        }
        self.menuView.backgroundColor = kInspectSectionBackGroundColor;
        [MBProgressHUD hideHUDForView:self.view animated:YES];

    }];
    
    
    [self closeRedView];
}



#pragma mark - UITableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.allPraiseListArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kPictureTableViewCell];
    if (!cell) {
        cell = [[PictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kPictureTableViewCell];
    }

    cell.pictureList = _allPraiseListArray[indexPath.row];
    return cell;
}


// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    PictureListModel *picList = _allPraiseListArray[indexPath.row];
    PictureStoryViewController *storyVC = [[PictureStoryViewController alloc] init];
    storyVC.uuid = picList.uuid;
    storyVC.titleStr = self.titleStr;
    [self.navigationController pushViewController:storyVC animated:YES];
}


#pragma mark - lazy loading
- (MenuView *)menuView
{
    if (!_menuView) {
        _menuView = [[MenuView alloc] init];
        _menuView.translatesAutoresizingMaskIntoConstraints = NO;
        [_menuView.taxiButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
        [_menuView.screenButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
        [self.view addSubview:_menuView];
        
        NSLayoutConstraint *menuTop = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:menuTop];
        
        NSLayoutConstraint *menuLeft = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:menuLeft];
        
        NSLayoutConstraint *menuRight = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:menuRight];
        
        NSLayoutConstraint *menuHeight = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self.view addConstraint:menuHeight];
    }
    return _menuView;
}

- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
//        _tableView.tableFooterView = [[UIView alloc] init];
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 150.0;
        [_tableView registerClass:[PictureTableCell class] forCellReuseIdentifier:kPictureTableViewCell];
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:45];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (NoDataView *)noDataView
{
    if (!_noDataView) {
        _noDataView = [[NoDataView alloc] init];
        _noDataView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.view addSubview:_noDataView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:45];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _noDataView;
}


@end
