//
//  TreeView.m
//  redstar
//
//  Created by admin on 15/12/18.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "TreeView.h"
#import "TreeNodeCell.h"
#import "SelectYetTableViewCell.h"

#define kTreeNodeCell @"nodelCell"

@interface TreeView () <SelectYetDelegate>
@property (nonatomic) NSArray *nodeArray;
@end

@implementation TreeView
#pragma mark - 初始化函数
-(instancetype)init {
    self = [super init];
    if (self) {
        [self configSelf];
    }
    return self;
}

-(id)initWithCoder:(NSCoder *)aDecoder {
    self = [super initWithCoder:aDecoder];
    if (self) {
        [self configSelf];
    }
    return self;
}

-(instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self configSelf];
    }
    return self;
}

-(instancetype)initWithFrame:(CGRect)frame style:(UITableViewStyle)style {
    self = [super initWithFrame:frame style:style];
    if (self) {
        [self configSelf];
    }
    return self;
}

-(void)configSelf {
    self.dataSource = self;
    self.delegate = self;
    [self registerClass:[TreeNodeCell class] forCellReuseIdentifier:kTreeNodeCell];
    self.rowHeight = UITableViewAutomaticDimension;
    self.estimatedRowHeight = 50.0;
}
#pragma mark - SelectYetDelegate
- (void)removeCurrentWithButton:(UIButton *)sender
{
    UIButton *button = (UIButton *)sender.superview;
    NSInteger index = button.tag - 6666687;
    TreeNodeModel *treeM = _selectTreeArray[index];
    treeM.isChoose = NO;
    [button removeFromSuperview];
    button = nil;
    [self.selectTreeArray removeObject:treeM];
    
    [self reloadData];
}

#pragma mark - 表格代理
-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    self.nodeArray = [self.nodeData nodeArray:NO];
    return self.nodeArray.count + 1;
}


-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        SelectYetTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"11nodeCell"];
        if (cell == nil) {
            cell = [[SelectYetTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"11nodeCell"];
        }
        cell.delegate = self;
        cell.selectTreeArray = self.selectTreeArray;
        cell.textLabel.text = @"已选：";
        cell.textLabel.textColor = kLightGray;
        cell.textLabel.font = [UIFont systemFontOfSize:15.0];
        return cell;
    } else {
        TreeNodeCell *cell = [tableView dequeueReusableCellWithIdentifier:kTreeNodeCell];
        
        if (cell == nil) {
            cell = [[TreeNodeCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:kTreeNodeCell];
        }
        
        cell.nodeDelegate = self;
        cell.nodeData = self.nodeArray[indexPath.row - 1];
        // 强制刷新，主要是为了刷新那些自画线条
        
        cell.titleButton.selected = cell.nodeData.isChoose;
        [cell setNeedsDisplay];
        return cell;
    }
}

#pragma mark - node代理
-(BOOL)shouldClickFoldButtonAtNode:(TreeNodeCell *)node {
    if ([self.treeDelegate respondsToSelector:@selector(tree:shouldClickFoldButtonAtNode:)]) {
        return [self.treeDelegate tree:self shouldClickFoldButtonAtNode:node];
    }
    else {
        return YES;
    }
}

-(void)didClickFoldButtonAtNode:(TreeNodeCell *)node {
    // 获取变动的行索引
    NSUInteger beginIndex = [self.nodeArray indexOfObject:node.nodeData] + 2;
    NSUInteger indexCount = [[node.nodeData nodeArray:NO] count];
    NSMutableArray *indexArray = [NSMutableArray array];
    for (int i = 0; i < indexCount; i++) {
        [indexArray addObject:[NSIndexPath indexPathForRow:beginIndex + i inSection:0]];
    }
    // 用插入和删除函数就会产生动画
    if (node.nodeData.isExpand == NO) {
        
        [UIView animateWithDuration:0.2 animations:^{
            node.arrowImageView.transform = CGAffineTransformIdentity;
            node.arrowImageView.transform = CGAffineTransformMakeRotation(0);
        }];
        
        [self deleteRowsAtIndexPaths:indexArray withRowAnimation:(UITableViewRowAnimationTop)];
    }
    else {
        
        [UIView animateWithDuration:0.2 animations:^{
            node.arrowImageView.transform = CGAffineTransformIdentity;
            node.arrowImageView.transform = CGAffineTransformMakeRotation(-M_PI);
        }];
        
        [self insertRowsAtIndexPaths:indexArray withRowAnimation:(UITableViewRowAnimationBottom)];
    }
    
    if (beginIndex == 1) {
        [node setNeedsDisplay];
    }
    
    
    if ([self.treeDelegate respondsToSelector:@selector(tree:didClickFoldButtonAtNode:)]) {
        [self.treeDelegate tree:self didClickFoldButtonAtNode:node];
    }
}

- (void)didClickTitleAtNode:(TreeNodeCell *)node {
    if ([self.treeDelegate respondsToSelector:@selector(tree:didClickTitleAtNode:)]) {
        [self.treeDelegate tree:self didClickTitleAtNode:node];
    }
}


@end
