//
//  SelectStoreHeadView.m
//  redstar
//
//  Created by admin on 15/12/16.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "SelectStoreHeadView.h"

@implementation SelectStoreHeadView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.searchTextFiled.placeholder = @"请输入问题关键字";
        self.layer.borderColor = kSeparateLineCGColor;
        self.layer.borderWidth = 0.5;
    }
    return self;
}

#pragma mark - Lazy Loading
- (UITextField *)searchTextFiled
{
    if (!_searchTextFiled) {
        _searchTextFiled = [[UITextField alloc] init];
        _searchTextFiled.font = [UIFont systemFontOfSize:14.0];
        _searchTextFiled.backgroundColor = [UIColor whiteColor];
        _searchTextFiled.translatesAutoresizingMaskIntoConstraints = NO;
        _searchTextFiled.layer.cornerRadius = 4.0;
        _searchTextFiled.layer.borderWidth = 1.0;
        _searchTextFiled.layer.borderColor = kPasswordBorderColor;
        UIImageView *imageV = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"search_icon"]];
        imageV.width += 20;
        imageV.contentMode = UIViewContentModeCenter;
        _searchTextFiled.leftView = imageV;
        _searchTextFiled.leftViewMode = UITextFieldViewModeAlways;
        
        UIButton *imageR = [[UIButton alloc] init];
        imageR.frame = CGRectMake(0, 0, 28, 28);
        [imageR setImage:[UIImage imageNamed:@"close"] forState:UIControlStateNormal];
        [imageR addTarget:self action:@selector(searchClick:) forControlEvents:UIControlEventTouchUpInside];
        imageR.contentMode = UIViewContentModeCenter;
        imageR.width += 10;
        _searchTextFiled.rightView = imageR;
        _searchTextFiled.rightViewMode = UITextFieldViewModeAlways;
        [self addSubview:_searchTextFiled];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_searchTextFiled attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:8];
        [self addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_searchTextFiled attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_searchTextFiled attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_searchTextFiled attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-8];
        [self addConstraint:titleBottom];
    }
    return _searchTextFiled;
}

- (void)searchClick:(UIButton *)sender
{
    self.searchTextFiled.text = @"";
}

@end
