//
//  LookOnLineFootView.m
//  redstar
//
//  Created by admin on 15/12/8.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "LookOnLineFootView.h"

@interface LookOnLineFootView ()
@property (nonatomic, strong) UIImageView *backImageView1;
@end

@implementation LookOnLineFootView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    self.introLabel.text = @"处理说明";
    UIImage *image = [UIImage imageNamed:@"textbox"];
    UIImage *resizingName = [image resizableImageWithCapInsets:UIEdgeInsetsMake(1, 1, 24, 24) resizingMode:UIImageResizingModeStretch];
    self.backImageView1.image = resizingName;
    
    self.contentTextView.backgroundColor = [UIColor clearColor];
    self.placeholderLabel2.text = @"请输入文字，不超过500字";
    [self.resultButton setTitle:@"上报结果" forState:UIControlStateNormal];
}

- (UILabel *)introLabel
{
    if (!_introLabel) {
        _introLabel = [[UILabel alloc] init];
        _introLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _introLabel.font = [UIFont systemFontOfSize:15.0];
        _introLabel.textColor = kLightBlack;
        [self addSubview:_introLabel];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self addConstraint:contentHeight];
    }
    return _introLabel;
    
}

- (UIImageView *)backImageView1
{
    if (!_backImageView1) {
        _backImageView1 = [[UIImageView alloc] init];
        _backImageView1.userInteractionEnabled = YES;
        _backImageView1.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_backImageView1];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.introLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:90];
        [self addConstraint:contentHeight];
    }
    return _backImageView1;
}

- (UITextView *)contentTextView
{
    if (!_contentTextView) {
        _contentTextView = [[UITextView alloc] init];
        _contentTextView.font = [UIFont systemFontOfSize:15.0];
        _contentTextView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.backImageView1 addSubview:_contentTextView];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.backImageView1 addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [self.backImageView1 addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
        [self.backImageView1 addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.backImageView1 addConstraint:contentHeight];
    }
    return _contentTextView;
}

- (UILabel *)placeholderLabel2
{
    if (!_placeholderLabel2) {
        _placeholderLabel2 = [[UILabel alloc] init];
        _placeholderLabel2.translatesAutoresizingMaskIntoConstraints = NO;
        _placeholderLabel2.font = [UIFont systemFontOfSize:15.0];
        _placeholderLabel2.textColor = kOnLineCellDetailColor;
        [self.contentTextView addSubview:_placeholderLabel2];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [self.contentTextView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:5];
        [self.contentTextView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentTextView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentTextView addConstraint:contentHeight];
    }
    return _placeholderLabel2;
}

- (UIButton *)resultButton
{
    if (!_resultButton) {
        _resultButton = [[UIButton alloc] init];
        _resultButton.translatesAutoresizingMaskIntoConstraints = NO;
        _resultButton.backgroundColor = kNavigationBarColor;
        [self addSubview:_resultButton];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_resultButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
        [self addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_resultButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_resultButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_resultButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
        [self addConstraint:contentHeight];
    }
    return _resultButton;
}
@end
