//
//  FuncItem.m
//  redstar
//
//  Created by admin on 15/11/27.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "FuncItem.h"

@implementation FuncItem

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        self.imageView.contentMode = UIViewContentModeCenter;
        [self setTitleColor:kHomeItemTextColor forState:UIControlStateNormal];
        self.titleLabel.textAlignment = NSTextAlignmentCenter;
        self.titleLabel.font = [UIFont systemFontOfSize:15];
        [self setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        [self setTitleColor:[UIColor orangeColor] forState:UIControlStateSelected];
        self.layer.borderWidth = 0.5;
        self.layer.borderColor = kLineCGColor;
    }
    return self;
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    
    CGFloat btnW = self.width;
    CGFloat btnH = self.height;
    CGFloat imageH = btnH * 0.7;
    self.imageView.frame = CGRectMake(0, 7, btnW, imageH);
    
    CGFloat titleH = btnH - imageH;
    CGFloat titleY = imageH - 5;
    self.titleLabel.frame = CGRectMake(0, titleY, btnW, titleH);
    
    
}


@end
