//
//  InspectUpLoadFootView.m
//  redstar
//
//  Created by admin on 15/11/25.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectUpLoadFootView.h"
#import <UIImageView+WebCache.h>

//#define kImageItemWidth
//#define kImageItemHeigh

@implementation InspectUpLoadFootView

- (instancetype)initWithAnswerAttachments:(NSArray *)answerAttachments referenceAttachments:(NSArray *)referenceAttachments remark:(NSString *)remark
{
    self = [super init];
    if (self) {
        self.backgroundColor = kSectionBackGroundColor;
        NSLog(@"answerAttachments.count = %ld  referenceAttachments.count = %ld", (unsigned long)answerAttachments.count , (unsigned long)referenceAttachments.count);
        CGFloat imageMaginX = 20;
        CGFloat imageMaginY = 10;
        CGFloat imageW = (kScreenWidth - imageMaginX * 3) / 2;
        CGFloat imageH = 100;
        
        int answerCount = (int)answerAttachments.count;
        int answerRow = 0;
        if (answerCount % 2 == 0) {
            answerRow = answerCount / 2;
        } else {
            answerRow = (answerCount + 1) / 2;
        }
        
        int referenceCount = (int)referenceAttachments.count;
        int referenceRow = 0;
        if (referenceCount % 2 == 0) {
            referenceRow = referenceCount / 2;
        } else {
            referenceRow = (referenceCount + 1) / 2;
        }
        
        self.height = imageMaginY + (25 * 2) + answerRow * (imageH + imageMaginY) + imageMaginY + referenceRow * (imageH + imageMaginY) + imageMaginY + 100 + 60;
        
        self.titleLabel.text = @"现场照片";

        // 现场照片
        for (int i = 0; i < answerAttachments.count; i++) {
            UIImageView *imageView = [[UIImageView alloc] init];
            NSDictionary *dict = (NSDictionary *)answerAttachments[i];
            NSURL *imageUrl = [NSURL URLWithString:[NSString stringWithFormat:@"%@%@", kRedStarURL ,dict[@"fileUrl"]]];
            [imageView sd_setImageWithURL:imageUrl placeholderImage:[UIImage imageNamed:@"default_pic"]];
            int j = 0;
            if ((i + 1) % 2 == 0) {
                j = (i + 1) / 2;
                imageView.frame = CGRectMake(imageMaginX + (imageW + imageMaginX), 35 + imageMaginY + (j-1) * (imageH + imageMaginY), imageW, imageH);
            } else {
                j = (i + 2) / 2;
                imageView.frame = CGRectMake(imageMaginX, 35 + imageMaginY + (j-1) * (imageH + imageMaginY), imageW, imageH);
            }
            [self addSubview:imageView];
        }
        
        UILabel *referenceLabel = [[UILabel alloc] initWithFrame:CGRectMake(imageMaginX, 40 + answerRow * imageH + (answerRow + 1) * imageMaginY, kScreenWidth - imageMaginX * 2, 25)];
        referenceLabel.font = [UIFont systemFontOfSize:15.0];
        referenceLabel.textColor = kLightGray;
        referenceLabel.text = @"参考照片";
        [self addSubview:referenceLabel];
        
        
        
        // 参考照片
        for (int i = 0; i < referenceAttachments.count; i++) {
            UIImageView *imageView = [[UIImageView alloc] init];
            NSDictionary *dict = (NSDictionary *)referenceAttachments[i];
            NSURL *imageUrl = [NSURL URLWithString:[NSString stringWithFormat:@"%@%@", kRedStarURL ,dict[@"fileUrl"]]];
            [imageView sd_setImageWithURL:imageUrl placeholderImage:[UIImage imageNamed:@"default_pic"]];
            int j = 0;
            if ((i + 1) % 2 == 0) {
                j = (i + 1) / 2;
                imageView.frame = CGRectMake(imageMaginX + (imageW + imageMaginX), 65 + answerRow * imageH + (answerRow + 1) * imageMaginY + imageMaginY + (j-1) * (imageH + imageMaginY), imageW, imageH);
            } else {
                j = (i + 2) / 2;
                imageView.frame = CGRectMake(imageMaginX, 65 + answerRow * imageH + (answerRow + 1) * imageMaginY + imageMaginY + (j-1) * (imageH + imageMaginY), imageW, imageH);
            }
            [self addSubview:imageView];
        }
        
        // 备注
        UILabel *remarkLanel = [[UILabel alloc] initWithFrame:CGRectMake(imageMaginX, 65 + answerRow * imageH + (answerRow + 1) * imageMaginY + referenceRow * imageH + (referenceRow + 1) * imageMaginY, kScreenWidth - imageMaginX * 2, 25)];
        remarkLanel.font = [UIFont systemFontOfSize:15.0];
        remarkLanel.textColor = kLightGray;
        remarkLanel.text = @"备注";
        [self addSubview:remarkLanel];
        
        // 背景ImageView
        UIImageView *bgImageView = [[UIImageView alloc] init];
        bgImageView.translatesAutoresizingMaskIntoConstraints = NO;
        UIImage *image = [UIImage imageNamed:@"textbox"];
        UIImage *resizingName = [image resizableImageWithCapInsets:UIEdgeInsetsMake(1, 1, 24, 24) resizingMode:UIImageResizingModeStretch];
        bgImageView.image = resizingName;
        [self addSubview:bgImageView];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:bgImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:remarkLanel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:bgImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:bgImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:overDateRight];
        
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:bgImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:70];
        [self addConstraint:overDateWidth];
        
        // textView
        UITextView *textView = [[UITextView alloc] init];
        textView.text = [NSString stringWithFormat:@"%@", remark];
        textView.backgroundColor = [UIColor clearColor];
        textView.translatesAutoresizingMaskIntoConstraints = NO;
        [bgImageView addSubview:textView];
        
        NSLayoutConstraint *textViewTop = [NSLayoutConstraint constraintWithItem:textView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:bgImageView attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [bgImageView addConstraint:textViewTop];
        
        NSLayoutConstraint *textViewLeft = [NSLayoutConstraint constraintWithItem:textView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:bgImageView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [bgImageView addConstraint:textViewLeft];
        
        NSLayoutConstraint *textViewRight = [NSLayoutConstraint constraintWithItem:textView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:bgImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
        [bgImageView addConstraint:textViewRight];
        
        
        NSLayoutConstraint *textViewWidth = [NSLayoutConstraint constraintWithItem:textView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:bgImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [bgImageView addConstraint:textViewWidth];
        
        // 返回上一页
        UIButton *returnButton = [[UIButton alloc] init];
        returnButton.translatesAutoresizingMaskIntoConstraints = NO;
        returnButton.backgroundColor = kNavigationBarColor;
        returnButton.layer.cornerRadius = 4;
        [returnButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [returnButton setTitle:@"返回上一页面" forState:UIControlStateNormal];
        returnButton.titleLabel.font = [UIFont systemFontOfSize:20.0];
        [returnButton addTarget:self action:@selector(returnClick:) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:returnButton];

        NSLayoutConstraint *returnButtonTop = [NSLayoutConstraint constraintWithItem:returnButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:bgImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
        [self addConstraint:returnButtonTop];
        
        NSLayoutConstraint *returnButtonLeft = [NSLayoutConstraint constraintWithItem:returnButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:returnButtonLeft];
        
        NSLayoutConstraint *returnButtonRight = [NSLayoutConstraint constraintWithItem:returnButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:returnButtonRight];
        
        NSLayoutConstraint *returnButtonHeight = [NSLayoutConstraint constraintWithItem:returnButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self addConstraint:returnButtonHeight];
    }
    return self;
}

- (void)returnClick:(UIButton *)sender
{
    if (_delegate) {
        [_delegate returnParentsViewController];
    }
}

#pragma - lazy loading
- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.font = [UIFont systemFontOfSize:15.0];
        _titleLabel.textColor = kLightGray;
        [self addSubview:_titleLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:overDateRight];
        
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self addConstraint:overDateWidth];
    }
    return _titleLabel;
}


@end
