//
//  QuestionViewController.m
//  redstar
//
//  Created by admin on 15/11/2.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "QuestionViewController.h"
#import "QuestionListTableCell.h"
#import "MenuButton.h"
#import "QuestionDetailViewController.h"
#import "AddQuestionViewController.h"
#import "HttpClient.h"
#import "QuestionModel.h"
#import "SearchToolBar.h"
#import "TaxisView.h"
#import "ScreenView.h"
#import "MenuView.h"
#import "CustomDropMenuView.h"

#import "NoDataView.h"
#import <MBProgressHUD.h>

#define kQuestionListCell @"questionListTableViewCell"
#define kThumbTag 745645
@interface QuestionViewController () <UITableViewDelegate, UITableViewDataSource, ScreenTableDelegate, TaxisViewDelegate, InspectTableViewDelegate>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSMutableArray *allQuestionArray;

@property (nonatomic, strong) SearchToolBar *searchBar;
@property (nonatomic, strong) MenuView *menuView;

@property (nonatomic, strong) TaxisView *taxisView;
@property (nonatomic, strong) ScreenView *screenView;

@property (nonatomic, strong) UIView *bgView;
@property (nonatomic, strong) MenuButton *selctedButton;
@property (nonatomic, strong) UIButton *selectBtn;

@property (nonatomic, strong) NoDataView *noDataView;

@property (nonatomic, assign) NSInteger selectRow;
@property (nonatomic, assign) NSInteger timeSelectNum;

@end

@implementation QuestionViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    [self setupNav];
    
    [self requestQuestionList];
    
   
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self.menuView.taxiButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
    [self.menuView.screenButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
    self.tabBarController.tabBar.hidden = YES;
}


- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    [self.menuView removeFromSuperview];
    self.menuView = nil;
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Methods
- (void)requestQuestionList
{
    // 初始化数组
    self.allQuestionArray = [NSMutableArray array];
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];

    // 请求参数
    NSDictionary *parameters = @{@"user":user_uuid,
                                 @"scope":@"all",
                                 @"pageNumber":@(0),
                                 @"pageSize":@(20)
                                 };
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    //
    __block QuestionViewController *weakSelf = self;
    
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"问题与知识列表recods = %@", response);
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [weakSelf.allQuestionArray addObject:question];
        }
        if (_allQuestionArray.count == 0) {
            weakSelf.noDataView.backgroundColor = [UIColor whiteColor];
            [MBProgressHUD hideHUDForView:self.view animated:YES];
        } else {
            [weakSelf setupTableView];
            [MBProgressHUD hideHUDForView:self.view animated:YES];
        }
        
    }];
}

- (void)setupTableView
{
    [self.tableView registerClass:[QuestionListTableCell class] forCellReuseIdentifier:kQuestionListCell];
    
    self.searchBar.backgroundColor = kSectionBackGroundColor;
}

- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"问题与知识"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *rightButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, 60, 20)];
    [rightButton setTitle:@"新增问题" forState:UIControlStateNormal];
    [rightButton addTarget:self action:@selector(addQuestionClick:) forControlEvents:UIControlEventTouchUpInside];
    [rightButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    rightButton.titleLabel.font = [UIFont systemFontOfSize:15];
    UIBarButtonItem *rightButtonItem = [[UIBarButtonItem alloc] initWithCustomView:rightButton];
    self.navigationItem.rightBarButtonItem = rightButtonItem;
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
}

- (void)doBack:(id)sender
{
    [self.navigationController dismissViewControllerAnimated:YES completion:nil];
}

- (void)addQuestionClick:(UIButton *)sender
{
    NSArray *permissions = [[NSUserDefaults standardUserDefaults] objectForKey:@"permissions"];
    if ([permissions containsObject:@"500503"]) {
        AddQuestionViewController *addQuestionVC = [[AddQuestionViewController alloc] init];
        [self.navigationController pushViewController:addQuestionVC animated:YES];
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您没有新增问题权限！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
    
    
}

- (void)dropCilck:(MenuButton *)sender
{
    sender.isDrop = !sender.isDrop;
    
    if (_selctedButton.tag == sender.tag) {
        
        
        if (sender.isDrop) {
            if (sender.tag == 4001) {
                [self showRedView];
            } else {
                [self showGreenView];
            }
            [sender setTitleColor:[UIColor orangeColor] forState:UIControlStateNormal];
            
        } else {
            if (sender.tag == 4001) {
                [self closeRedView];
            } else {
                [self closeGreenView];
            }
            [sender setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
        }
    } else {
        // 前一次选中的按钮 选中状态置为NO
        _selctedButton.selected = NO;
        _selctedButton.isDrop = NO;
        // 进行选中状态为NO 的操作
        //   1.将发生“选中”->“未选中”状态变化的按钮文字由Orange->White
        [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
        //   2.判断当前是否有bgView 有->移除， 没有->跳过
        if (_bgView) {
            // _bgView存在
            [_bgView removeFromSuperview];
            _bgView = nil;
        }
        
        if (_taxisView) {
            [_taxisView removeFromSuperview];
            _taxisView = nil;
        }
        
        if (_screenView) {
            [_screenView removeFromSuperview];
            _screenView = nil;
        }
        
        
        // 将当前选中的按钮设置 选中状态为YES;
        sender.selected = YES;
        // 对选中按钮 进行相关操作
        //   1.将选中按钮的文字设置为Orange
        [sender setTitleColor:[UIColor orangeColor] forState:UIControlStateNormal];
        _selctedButton = (MenuButton *)sender;
        
        if (sender.tag == 4001) {
            [self showRedView];
        } else {
            [self showGreenView];
        }
    }
}


- (void)showRedView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:self.view.bounds];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeRedView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_taxisView) {
        _taxisView = [[TaxisView alloc] init];
        _taxisView.backgroundColor = [UIColor whiteColor];
    }
    
    _taxisView.delegate = self;
    [self.view addSubview:_bgView];
    [self.view insertSubview:_taxisView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, kTaxisViewHeight);
    CGRect fromFrame = CGRectMake(0, -kTaxisViewHeight, kScreenWidth, kTaxisViewHeight);
    
    _taxisView.frame = fromFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _taxisView.frame = toFrame;
    }];
    
}

- (void)closeRedView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    CGRect fromFrame = CGRectMake(0, -kTaxisViewHeight, kScreenWidth, kTaxisViewHeight);
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _taxisView.frame = fromFrame;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_taxisView removeFromSuperview];
    }];
}


- (void)showGreenView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:self.view.bounds];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeGreenView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_screenView) {
        _screenView = [[ScreenView alloc] initWithTitleArray:[NSArray arrayWithObjects:@"待解决", @"已解决",@"已作废",nil]];
        _screenView.delegate = self;
        _screenView.inspectTableView.inspectDelegate = self;
        _screenView.backgroundColor = [UIColor whiteColor];
    }
    [_screenView.resetBtn addTarget:self action:@selector(resetClick:) forControlEvents:UIControlEventTouchUpInside];
    [_screenView.submitBtn addTarget:self action:@selector(submitClick:) forControlEvents:UIControlEventTouchUpInside];
    
    [self.view addSubview:_bgView];
    [self.view insertSubview:_screenView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, kScreenViewHeight);
    CGRect fromFrame = CGRectMake(0, -kScreenViewHeight, kScreenWidth, kScreenViewHeight);
    
    _screenView.frame = fromFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _screenView.frame = toFrame;
    }];
    
}

- (void)closeGreenView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    CGRect fromFrame = CGRectMake(0, -kScreenViewHeight, kScreenWidth, kScreenViewHeight);
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _screenView.frame = fromFrame;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_screenView removeFromSuperview];
    }];
}


- (void)searchBarClick:(UIButton *)sender
{
    NSLog(@"%@", self.searchBar.searchTextFiled.text);
}

// 重置按钮
- (void)resetClick:(UIButton *)sender
{
    NSInteger selectedIndex = 0;
    NSIndexPath *selectedIndexPath = [NSIndexPath indexPathForRow:selectedIndex inSection:0];
    [_screenView.tableView selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    
    _screenView.textView.text = @"";
    
    NSInteger timeIndex = 0;
    NSIndexPath *timeIndexPath = [NSIndexPath indexPathForRow:timeIndex inSection:0];
    [_screenView.tableView selectRowAtIndexPath:timeIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    _selectRow = 0;
}
// 提交按钮
- (void)submitClick:(UIButton *)sender
{
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    
  
    NSMutableDictionary *parameters = [NSMutableDictionary dictionaryWithObjectsAndKeys:
                                       user_uuid,@"user",
                                       @"all",@"scope",
                                       @(0),@"pageNumber",
                                       @(10),@"pageSize", nil];
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    //
    __block QuestionViewController *weakSelf = self;
    
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    
    if (_screenView.groupTabBar.selectNumber == 0) {
        NSArray *queryOrder = @[@{@"field":@"state"}];
        [parameters setObject:queryOrder forKey:@"queryOrders"];
        if (_selectRow == 0) {
            [parameters setObject:@"created" forKey:@"state"];
        } else if (_selectRow == 1) {
            [parameters setObject:@"resolved" forKey:@"state"];
        } else {
            [parameters setObject:@"aborted" forKey:@"state"];
        }
        
    } else if (_screenView.groupTabBar.selectNumber == 1) {
        NSArray *queryOrder = @[@{@"field":@"title"}];
        [parameters setObject:queryOrder forKey:@"queryOrders"];
        if (_screenView.textView.text.length != 0){
            [parameters setObject:_screenView.textView.text forKey:@"contentLike"];
        } else {
            [parameters setObject:_screenView.textView.text forKey:@"contentLike"];
        }
    } else {
        NSArray *queryOrder = @[@{@"field":@"resolveTime",@"direction":@"desc"}];
        [parameters setObject:queryOrder forKey:@"queryOrders"];
        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];

        // 当前时间
        NSDate *today = [NSDate date];
        NSString *todayStr = [dateFormatter stringFromDate:today];
        
        if (_timeSelectNum == 0) {

            NSDate *week = [today dateByAddingTimeInterval:-60*60*24*7];
            NSString *weekStr = [dateFormatter stringFromDate:week];
            
            [parameters setObject:weekStr forKey:@"submitTimeFrom"];
            [parameters setObject:todayStr forKey:@"submitTimeTo"];
        } else if (_timeSelectNum == 1) {
            
            NSDate *oneMonth = [self getPriousorLaterDateFromDate:today withMonth:-1];
            NSString *oneMonthStr = [dateFormatter stringFromDate:oneMonth];
            NSLog(@"oneMonth = %@", oneMonthStr);
            
            [parameters setObject:oneMonthStr forKey:@"submitTimeFrom"];
            [parameters setObject:todayStr forKey:@"submitTimeTo"];
            
        } else if (_timeSelectNum == 2) {
            NSDate *threeMonth = [self getPriousorLaterDateFromDate:today withMonth:-3];
            NSString *threeMonthStr = [dateFormatter stringFromDate:threeMonth];
            
            [parameters setObject:threeMonthStr forKey:@"submitTimeFrom"];
            [parameters setObject:todayStr forKey:@"submitTimeTo"];
        } else if (_timeSelectNum == 3) {
            NSDate *oneYear = [self getPriousorLaterDateFromDate:today withMonth:-12];
            NSString *oneYearStr = [dateFormatter stringFromDate:oneYear];
            
            [parameters setObject:oneYearStr forKey:@"submitTimeFrom"];
            [parameters setObject:todayStr forKey:@"submitTimeTo"];
        } else {
            NSDate *oneYear = [self getPriousorLaterDateFromDate:today withMonth:-12];
            NSString *oneYearStr = [dateFormatter stringFromDate:oneYear];
            [parameters setObject:oneYearStr forKey:@"submitTimeTo"];
        }
       
    }
    
    
    NSLog(@"parameters = %@",parameters);

    
    
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"问题与知识列表recods = %@", response);
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [tempArray addObject:question];
        }
        _allQuestionArray = tempArray;

        if (_allQuestionArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            weakSelf.noDataView.backgroundColor = [UIColor whiteColor];
            [MBProgressHUD hideHUDForView:weakSelf.view animated:YES];
            [weakSelf closeGreenView];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            weakSelf.tableView.delegate = weakSelf;
            weakSelf.tableView.dataSource = weakSelf;
            [weakSelf.tableView reloadData];
            [MBProgressHUD hideHUDForView:weakSelf.view animated:YES];
            _screenView.textView.text = @"";
            [weakSelf closeGreenView];
        }
    }];

}

- (NSDate *)getPriousorLaterDateFromDate:(NSDate *)date withMonth:(int)month
{
    NSDateComponents *comps = [[NSDateComponents alloc] init];
    [comps setMonth:month];
    NSCalendar *calender = [[NSCalendar alloc] initWithCalendarIdentifier:NSGregorianCalendar];
    NSDate *mDate = [calender dateByAddingComponents:comps toDate:date options:0];
    return mDate;
}




#pragma mark - InspectTableViewDelegate
- (void)inspectTableViewDidSelectWithRow:(NSInteger)row
{
    _selectRow = row;
}

#pragma mark - TaxisDelegate
- (void)timeChange:(UIButton *)sender
{
    
    
    
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    
    
    NSArray *queryOrders;
    
    if (sender.tag - kTAxisBtnTag == 1) {
        queryOrders = @[];
        
    } else if (sender.tag - kTAxisBtnTag == 2) {
        
        queryOrders = @[@{@"field":@"likeCount",
                          @"direction":@"desc"}];
        
    } else {
        queryOrders = @[@{@"field":@"likeCount",
                          @"direction":@"asc"}];
    }
    
    NSDictionary *parameters = @{@"user":user_uuid,
                                 @"scope":@"all",
                                 @"pageNumber":@(0),
                                 @"pageSize":@(20),
                                 @"queryOrders":queryOrders
                                 };
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    __block QuestionViewController *weakSelf = self;
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"问题与知识列表recods = %@", response);
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [tempArray addObject:question];
        }
        _allQuestionArray = tempArray;
        
        if (_allQuestionArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            weakSelf.noDataView.backgroundColor = [UIColor whiteColor];
            [MBProgressHUD hideHUDForView:weakSelf.view animated:YES];
            [weakSelf closeGreenView];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            weakSelf.tableView.delegate = weakSelf;
            weakSelf.tableView.dataSource = weakSelf;
            [weakSelf.tableView reloadData];
            [MBProgressHUD hideHUDForView:weakSelf.view animated:YES];
            _screenView.textView.text = @"";
            [weakSelf closeGreenView];
        }
    }];

    
    [self closeRedView];
}

#pragma mark - ScreenTableDelegate
- (void)tableViewDidSelectRow:(NSInteger)row
{
    _timeSelectNum = row;
}

#pragma mark - UItableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _allQuestionArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    QuestionListTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kQuestionListCell];
    if (!cell) {
        cell = [[QuestionListTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kQuestionListCell];
    }
    cell.question = _allQuestionArray[indexPath.row];
    return cell;
}

// cell点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    QuestionDetailViewController *questionDetailVC = [[QuestionDetailViewController alloc] init];
    QuestionModel *question = (QuestionModel *)_allQuestionArray[indexPath.row];
    questionDetailVC.questionUuid = question.uuid;
    questionDetailVC.row = indexPath.row;
    [self.navigationController pushViewController:questionDetailVC animated:YES];
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 120;
}

// section高度
//- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
//{
//    return 45;
//}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0;
}


#pragma mark - lazy loading
- (MenuView *)menuView
{
    if (!_menuView) {
        _menuView = [[MenuView alloc] init];
        _menuView.translatesAutoresizingMaskIntoConstraints = NO;
        _menuView.backgroundColor = kInspectSectionBackGroundColor;
        UIWindow *window = [[UIApplication sharedApplication].windows lastObject];
        [window addSubview:_menuView];
        
        NSLayoutConstraint *menuTop = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:window attribute:NSLayoutAttributeTop multiplier:1.0 constant:64];
        [window addConstraint:menuTop];

        NSLayoutConstraint *menuLeft = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:window attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [window addConstraint:menuLeft];
        
        NSLayoutConstraint *menuRight = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:window attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [window addConstraint:menuRight];
        
        NSLayoutConstraint *menuHeight = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [window addConstraint:menuHeight];
    }
    return _menuView;
}

- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.tableFooterView = [[UIView alloc] init];
        [self.view addSubview:_tableView];
        [self.view insertSubview:_tableView atIndex:0];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:45];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (SearchToolBar *)searchBar
{
    if (!_searchBar) {
        _searchBar = [[SearchToolBar alloc] init];
        _searchBar.translatesAutoresizingMaskIntoConstraints = NO;
        [_searchBar.queryButton addTarget:self action:@selector(searchBarClick:) forControlEvents:UIControlEventTouchUpInside];
        [self.view insertSubview:_searchBar atIndex:999];
        [self.view insertSubview:_searchBar aboveSubview:_tableView];
        
        NSLayoutConstraint *tableHeight = [NSLayoutConstraint constraintWithItem:_searchBar attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
        [self.view addConstraint:tableHeight];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_searchBar attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_searchBar attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_searchBar attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _searchBar;
}

- (NoDataView *)noDataView
{
    if (!_noDataView) {
        _noDataView = [[NoDataView alloc] init];
        _noDataView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.view addSubview:_noDataView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _noDataView;
}

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    if (![_screenView.textView isExclusiveTouch]) {
        [_screenView.textView resignFirstResponder];
    }
    
    if (![self.searchBar.searchTextFiled isExclusiveTouch]) {
        [self.searchBar.searchTextFiled resignFirstResponder];
    }
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
