//
//  QuestionDetailCell.m
//  redstar
//
//  Created by admin on 15/11/2.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "QuestionDetailCell.h"

@implementation QuestionDetailCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setup
{
    
    
    
   
    
}

- (void)setQuestionDetail:(QuestionDetailModel *)questionDetail
{
    _questionDetail = questionDetail;
    
    // 状态
    if ([questionDetail.state isEqualToString:@"resolved"]) {
        NSString *stateText = [NSString stringWithFormat:@"状态：已解决"];
        NSMutableAttributedString *stateAttr = [[NSMutableAttributedString alloc] initWithString:stateText];
        [stateAttr addAttributes:@{NSForegroundColorAttributeName:kDetailCellDescribeTextColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(0,3)];
        [stateAttr addAttributes:@{NSForegroundColorAttributeName:kNavigationBarColor,NSFontAttributeName:[UIFont boldSystemFontOfSize:15.0f]} range:NSMakeRange(3,stateText.length - 3)];
        [self.stateLabel setAttributedText:stateAttr];
    } else {
        NSString *stateText = [NSString stringWithFormat:@"状态：已创建"];
        NSMutableAttributedString *stateAttr = [[NSMutableAttributedString alloc] initWithString:stateText];
        [stateAttr addAttributes:@{NSForegroundColorAttributeName:kDetailCellDescribeTextColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(0,3)];
        [stateAttr addAttributes:@{NSForegroundColorAttributeName:kdetailCellTitleColor,NSFontAttributeName:[UIFont boldSystemFontOfSize:15.0f]} range:NSMakeRange(3,stateText.length - 3)];
        [self.stateLabel setAttributedText:stateAttr];
    }
    
    if (questionDetail.myLike) {
        self.thumbBtn.selected = YES;
    } else {
        self.thumbBtn.selected = NO;
    }
    // 点赞数
    [self.thumbBtn setTitle:[NSString stringWithFormat:@"%d",questionDetail.likeCount] forState:UIControlStateNormal];

   
    // 分类
    NSString *sortText = [NSString stringWithFormat:@"分类：%@", questionDetail.category];
    NSMutableAttributedString *sortAttr = [[NSMutableAttributedString alloc] initWithString:sortText];
    [sortAttr addAttributes:@{NSForegroundColorAttributeName:kDetailCellDescribeTextColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(0,3)];
    [sortAttr addAttributes:@{NSForegroundColorAttributeName:kdetailCellTitleColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(3,sortText.length - 3)];
    [self.sortLabel setAttributedText:sortAttr];

    // 商场
    if (questionDetail.storePath == nil || questionDetail.storePath == NULL || [questionDetail.storePath isEqual:[NSNull null]]) {
        self.shopLabel.text = @"商场：";
        self.shopLabel.textColor = kDetailCellDescribeTextColor;
    } else {
        NSString *shopText = [NSString stringWithFormat:@"商场：%@", questionDetail.storePath];
        NSMutableAttributedString *shopAttr = [[NSMutableAttributedString alloc] initWithString:shopText];
        [shopAttr addAttributes:@{NSForegroundColorAttributeName:kDetailCellDescribeTextColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(0,3)];
        [shopAttr addAttributes:@{NSForegroundColorAttributeName:kdetailCellTitleColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(3,shopText.length - 3)];
        [self.shopLabel setAttributedText:shopAttr];
    }
    // 问题提报人
    NSString *peopleText = [NSString stringWithFormat:@"问题提报人：%@", questionDetail.submitUser_name];
    NSMutableAttributedString *peopleAttr = [[NSMutableAttributedString alloc] initWithString:peopleText];
    [peopleAttr addAttributes:@{NSForegroundColorAttributeName:kDetailCellDescribeTextColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(0,6)];
    [peopleAttr addAttributes:@{NSForegroundColorAttributeName:kdetailCellTitleColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(6,peopleText.length - 6)];
    [self.peopleLabel setAttributedText:peopleAttr];
    
    // 提报时间
    NSString *dateText = [NSString stringWithFormat:@"提报时间：%@", questionDetail.submitTime];
    NSMutableAttributedString *dateAttr = [[NSMutableAttributedString alloc] initWithString:dateText];
    [dateAttr addAttributes:@{NSForegroundColorAttributeName:kDetailCellDescribeTextColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(0,5)];
    [dateAttr addAttributes:@{NSForegroundColorAttributeName:kdetailCellTitleColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(5,dateText.length - 5)];
    [self.dateLabel setAttributedText:dateAttr];

}

#pragma mark - lazy loading
- (UILabel *)stateLabel
{
    if (!_stateLabel) {
        _stateLabel = [[UILabel alloc] init];
        _stateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_stateLabel];
        
        // 顶端
        NSLayoutConstraint *stateTop = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.contentView addConstraint:stateTop];
        
        // 左边
        NSLayoutConstraint *stateLeft = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:stateLeft];
        
        // 右边
        NSLayoutConstraint *stateRight = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.thumbBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-10];
        [self.contentView addConstraint:stateRight];
        
        // 高度
        NSLayoutConstraint *stateHeight = [NSLayoutConstraint constraintWithItem:_stateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:stateHeight];
    }
    return _stateLabel;
}

- (ZanButton *)thumbBtn
{
    if (!_thumbBtn) {
        _thumbBtn = [[ZanButton alloc] init];
        [_thumbBtn setImage:[UIImage imageNamed:@"commend"] forState:UIControlStateNormal];
        [_thumbBtn setImage:[UIImage imageNamed:@"commend_after"] forState:UIControlStateSelected];
        _thumbBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _thumbBtn.titleLabel.font = [UIFont systemFontOfSize:15.0];
        [_thumbBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        [self.contentView addSubview:_thumbBtn];
        
        // 顶端
        NSLayoutConstraint *thumbTop = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:13];
        [self.contentView addConstraint:thumbTop];
        
        // 左边
        NSLayoutConstraint *thumbWidth = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
        [self.contentView addConstraint:thumbWidth];
        
        // 右边
        NSLayoutConstraint *thumbRight = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:thumbRight];
        
        // 高度
        NSLayoutConstraint *thumbHeight = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:thumbHeight];
    }
    return _thumbBtn;
}


- (UILabel *)sortLabel
{
    if (!_sortLabel) {
        _sortLabel = [[UILabel alloc] init];
        _sortLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_sortLabel];
        
        // 顶端
        NSLayoutConstraint *sortTop = [NSLayoutConstraint constraintWithItem:_sortLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.stateLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:sortTop];
        
        // 左边
        NSLayoutConstraint *sortLeft = [NSLayoutConstraint constraintWithItem:_sortLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:sortLeft];
        
        // 右边
        NSLayoutConstraint *sortRight = [NSLayoutConstraint constraintWithItem:_sortLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:sortRight];
        
        // 高度
        NSLayoutConstraint *sortHeight = [NSLayoutConstraint constraintWithItem:_sortLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:sortHeight];
    }
    return _sortLabel;
}

- (UILabel *)shopLabel
{
    if (!_shopLabel) {
        _shopLabel = [[UILabel alloc] init];
        _shopLabel.font = [UIFont systemFontOfSize:15.0];
        _shopLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_shopLabel];
        
        // 顶端
        NSLayoutConstraint *sortTop = [NSLayoutConstraint constraintWithItem:_shopLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.sortLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:sortTop];
        
        // 左边
        NSLayoutConstraint *sortLeft = [NSLayoutConstraint constraintWithItem:_shopLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:sortLeft];
        
        // 右边
        NSLayoutConstraint *sortRight = [NSLayoutConstraint constraintWithItem:_shopLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:sortRight];
        
        // 高度
        NSLayoutConstraint *sortHeight = [NSLayoutConstraint constraintWithItem:_shopLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:sortHeight];
    }
    return _shopLabel;
}

- (UILabel *)peopleLabel
{
    if (!_peopleLabel) {
        _peopleLabel = [[UILabel alloc] init];
        _peopleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_peopleLabel];
        
        // 顶端
        NSLayoutConstraint *sortTop = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:sortTop];
        
        // 左边
        NSLayoutConstraint *sortLeft = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:sortLeft];
        
        // 右边
        NSLayoutConstraint *sortRight = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:sortRight];
        
        // 高度
        NSLayoutConstraint *sortHeight = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:sortHeight];
    }
    return _peopleLabel;
}


- (UILabel *)dateLabel
{
    if (!_dateLabel) {
        _dateLabel = [[UILabel alloc] init];
        _dateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_dateLabel];
        
        // 顶端
        NSLayoutConstraint *sortTop = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.peopleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:sortTop];
        
        // 左边
        NSLayoutConstraint *sortLeft = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:sortLeft];
        
        // 右边
        NSLayoutConstraint *sortRight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:sortRight];
        
//        // 高度
        NSLayoutConstraint *sortHeight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:sortHeight];
        
        // 高度
        NSLayoutConstraint *sortBottom = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-12];
        [self.contentView addConstraint:sortBottom];

    }
    return _dateLabel;
}
@end
