//
//  RedStarTools.m
//  redstar
//
//  Created by admin on 15/11/23.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RedStarTools.h"

@implementation RedStarTools

static RedStarTools *redStarToolsData = nil;

+ (RedStarTools *)sharedInstance
{
    @synchronized(self) {
        if (!redStarToolsData)
            redStarToolsData = [[self alloc] init];
        return redStarToolsData;
    }
}


- (void)loadLocalData
{
    NSArray *paths=NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask,YES);
    NSString *path = [paths objectAtIndex:0];
    NSString *filename=[path stringByAppendingPathComponent:@"local.plist"];
    self.localDatas = [[NSMutableArray alloc] initWithContentsOfFile:filename];
    
    if (!self.localDatas) {
        self.localDatas = [NSMutableArray array];
    }
}

- (void)saveLocalData
{
    NSArray *paths=NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask,YES);
    NSString *path = [paths objectAtIndex:0];
    NSString *filename=[path stringByAppendingPathComponent:@"local.plist"];
    
    [_localDatas writeToFile:filename atomically:YES];
}
@end
