//
//  InspectPointCell.m
//  redstar
//
//  Created by admin on 15/11/27.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectPointCell.h"

@implementation InspectPointCell

#pragma - lazy loading
- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.font = [UIFont systemFontOfSize:15.0];
        _titleLabel.textColor = kLightGray;
        [self.contentView addSubview:_titleLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:overDateRight];
        
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:23];
        [self.contentView addConstraint:overDateWidth];
    }
    return _titleLabel;
}

- (UILabel *)detailLabel
{
    if (!_detailLabel) {
        _detailLabel = [[UILabel alloc] init];
        _detailLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _detailLabel.font = [UIFont systemFontOfSize:15.0];
        _detailLabel.textColor = kLightBlack;
        _detailLabel.numberOfLines = 0;
        [self.contentView addSubview:_detailLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_detailLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:2];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_detailLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_detailLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:overDateRight];
        
        
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint constraintWithItem:_detailLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-8];
        [self.contentView addConstraint:overDateBottom];
    }
    return _detailLabel;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
