//
//  InspectNoUpLoadViewController.m
//  redstar
//
//  Created by admin on 15/11/26.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectNoUpLoadViewController.h"
#import "InspectPointCell.h"
#import "InpectPictureCell.h"

#define kImageW (kScreenWidth - kSpaceX * 3) / 2

#define kSpaceX 20

#define kInspectPointCell @"InspectPointCell"

@interface InspectNoUpLoadViewController () <UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, assign) int rowNumber;
@property (nonatomic, assign) int random;
@property (nonatomic, assign) BOOL isFull;
@end

@implementation InspectNoUpLoadViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    customLab.textAlignment = NSTextAlignmentCenter;
    [customLab setText:[NSString stringWithFormat:@"检查点--%@(%@/%d)", self.taskModel.category, self.taskModel.lineNo, self.questionCount]];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
    [self.tableView registerClass:[InspectPointCell class] forCellReuseIdentifier:kInspectPointCell];
    
    _rowNumber = 3;
    _isFull = NO;
    _random = 0;
}



#pragma mark - private methods
// 返回上一页面
- (void)doBack:(UIBarButtonItem *)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)reloadTableView:(UIButton *)sender
{
//    sender.selected = !sender.selected;
//    if (sender.selected) {
//        UIButton *addBtn = [[UIButton alloc] init];
//        addBtn.translatesAutoresizingMaskIntoConstraints = NO;
//        addBtn.layer.borderWidth = 0.5;
//        addBtn.backgroundColor = [UIColor greenColor];
//        addBtn.layer.borderColor = kSeparateLineCGColor;
//        // 添加长按手势,用作删除.  加号按钮不添加
//        UILongPressGestureRecognizer *gester = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPress:)];
//        [addBtn addGestureRecognizer:gester];
//        [cell.contentView addSubview:addBtn];
//        
//        NSLayoutConstraint *overDateTop = [NSLayoutConstraint
//                                           constraintWithItem:addBtn
//                                           attribute:NSLayoutAttributeTop
//                                           relatedBy:NSLayoutRelationEqual
//                                           toItem:cell.contentView
//                                           attribute:NSLayoutAttributeTop
//                                           multiplier:1.0
//                                           constant:5];
//        [cell.contentView addConstraint:overDateTop];
//        
//        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint
//                                            constraintWithItem:addBtn
//                                            attribute:NSLayoutAttributeLeft
//                                            relatedBy:NSLayoutRelationEqual
//                                            toItem:cell.contentView
//                                            attribute:NSLayoutAttributeLeft
//                                            multiplier:1.0
//                                            constant:20];
//        [cell.contentView addConstraint:overDateLeft];
//        
//        NSLayoutConstraint *overDateRight = [NSLayoutConstraint
//                                             constraintWithItem:addBtn
//                                             attribute:NSLayoutAttributeRight
//                                             relatedBy:NSLayoutRelationEqual
//                                             toItem:cell.contentView
//                                             attribute:NSLayoutAttributeCenterX
//                                             multiplier:1.0
//                                             constant:-10];
//        [cell.contentView addConstraint:overDateRight];
//        
//        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint
//                                              constraintWithItem:addBtn
//                                              attribute:NSLayoutAttributeHeight
//                                              relatedBy:NSLayoutRelationEqual
//                                              toItem:nil
//                                              attribute:NSLayoutAttributeNotAnAttribute
//                                              multiplier:1.0
//                                              constant:90];
//        [cell.contentView addConstraint:overDateHeight];
//        
//        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint
//                                              constraintWithItem:addBtn
//                                              attribute:NSLayoutAttributeBottom
//                                              relatedBy:NSLayoutRelationEqual
//                                              toItem:cell.contentView
//                                              attribute:NSLayoutAttributeBottom
//                                              multiplier:1.0
//                                              constant:-5];
//        [cell.contentView addConstraint:overDateBottom];
//        
//        cell.overDateLeft.constant = kScreenWidth / 2 + 10;
//        cell.overDateRight.constant = - 20;
//        [UIView animateWithDuration:0.3 animations:^{
//            [cell.contentView layoutIfNeeded];
//        }];
//    } else {
//        UIButton *addBtn = [[UIButton alloc] init];
//        addBtn.translatesAutoresizingMaskIntoConstraints = NO;
//        addBtn.layer.borderWidth = 0.5;
//        addBtn.backgroundColor = [UIColor greenColor];
//        addBtn.layer.borderColor = kSeparateLineCGColor;
//        // 添加长按手势,用作删除.  加号按钮不添加
//        UILongPressGestureRecognizer *gester = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPress:)];
//        [addBtn addGestureRecognizer:gester];
//        [cell.contentView addSubview:addBtn];
//        
//        NSLayoutConstraint *overDateTop = [NSLayoutConstraint
//                                           constraintWithItem:addBtn
//                                           attribute:NSLayoutAttributeTop
//                                           relatedBy:NSLayoutRelationEqual
//                                           toItem:cell.contentView
//                                           attribute:NSLayoutAttributeTop
//                                           multiplier:1.0
//                                           constant:5];
//        [cell.contentView addConstraint:overDateTop];
//        
//        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint
//                                            constraintWithItem:addBtn
//                                            attribute:NSLayoutAttributeLeft
//                                            relatedBy:NSLayoutRelationEqual
//                                            toItem:cell.contentView
//                                            attribute:NSLayoutAttributeLeft
//                                            multiplier:1.0
//                                            constant:kScreenWidth / 2 + 10];
//        [cell.contentView addConstraint:overDateLeft];
//        
//        NSLayoutConstraint *overDateRight = [NSLayoutConstraint
//                                             constraintWithItem:addBtn
//                                             attribute:NSLayoutAttributeRight
//                                             relatedBy:NSLayoutRelationEqual
//                                             toItem:cell.contentView
//                                             attribute:NSLayoutAttributeRight
//                                             multiplier:1.0
//                                             constant:- 20];
//        [cell.contentView addConstraint:overDateRight];
//        
//        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint
//                                              constraintWithItem:addBtn
//                                              attribute:NSLayoutAttributeHeight
//                                              relatedBy:NSLayoutRelationEqual
//                                              toItem:nil
//                                              attribute:NSLayoutAttributeNotAnAttribute
//                                              multiplier:1.0
//                                              constant:90];
//        [cell.contentView addConstraint:overDateHeight];
//        
//        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint
//                                              constraintWithItem:addBtn
//                                              attribute:NSLayoutAttributeBottom
//                                              relatedBy:NSLayoutRelationEqual
//                                              toItem:cell.contentView
//                                              attribute:NSLayoutAttributeBottom
//                                              multiplier:1.0
//                                              constant:-5];
//        [cell.contentView addConstraint:overDateBottom];
//        
//        [cell.photoButton removeFromSuperview];
//        cell.photoButton = nil;
//        _rowNumber += 1;
//        [self.tableView reloadData];
//
//    }
    
    InpectPictureCell *cell = (InpectPictureCell *)[[sender superview] superview];

    if (_isFull) {
        UIButton *addBtn = [[UIButton alloc] init];
        addBtn.translatesAutoresizingMaskIntoConstraints = NO;
        addBtn.layer.borderWidth = 0.5;
        addBtn.backgroundColor = [UIColor greenColor];
        addBtn.layer.borderColor = kSeparateLineCGColor;
        // 添加长按手势,用作删除.  加号按钮不添加
        UILongPressGestureRecognizer *gester = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPress:)];
        [addBtn addGestureRecognizer:gester];
        [cell.contentView addSubview:addBtn];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint
                                           constraintWithItem:addBtn
                                           attribute:NSLayoutAttributeTop
                                           relatedBy:NSLayoutRelationEqual
                                           toItem:cell.contentView
                                           attribute:NSLayoutAttributeTop
                                           multiplier:1.0
                                           constant:5];
        [cell.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint
                                            constraintWithItem:addBtn
                                            attribute:NSLayoutAttributeLeft
                                            relatedBy:NSLayoutRelationEqual
                                            toItem:cell.contentView
                                            attribute:NSLayoutAttributeLeft
                                            multiplier:1.0
                                            constant:kScreenWidth / 2 + 10];
        [cell.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint
                                             constraintWithItem:addBtn
                                             attribute:NSLayoutAttributeRight
                                             relatedBy:NSLayoutRelationEqual
                                             toItem:cell.contentView
                                             attribute:NSLayoutAttributeRight
                                             multiplier:1.0
                                             constant:- 20];
        [cell.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint
                                              constraintWithItem:addBtn
                                              attribute:NSLayoutAttributeHeight
                                              relatedBy:NSLayoutRelationEqual
                                              toItem:nil
                                              attribute:NSLayoutAttributeNotAnAttribute
                                              multiplier:1.0
                                              constant:90];
        [cell.contentView addConstraint:overDateHeight];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint
                                              constraintWithItem:addBtn
                                              attribute:NSLayoutAttributeBottom
                                              relatedBy:NSLayoutRelationEqual
                                              toItem:cell.contentView
                                              attribute:NSLayoutAttributeBottom
                                              multiplier:1.0
                                              constant:-5];
        [cell.contentView addConstraint:overDateBottom];
        
        cell.photoButton.hidden = YES;
        
        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:_rowNumber inSection:0];
        _rowNumber += 1;
        NSArray *indexArray = @[indexPath];
        [self.tableView beginUpdates];
        [self.tableView insertRowsAtIndexPaths:indexArray withRowAnimation:UITableViewRowAnimationFade];
        [self.tableView endUpdates];
        
        
    } else {
        UIButton *addBtn = [[UIButton alloc] init];
        addBtn.translatesAutoresizingMaskIntoConstraints = NO;
        addBtn.layer.borderWidth = 0.5;
        addBtn.backgroundColor = [UIColor greenColor];
        addBtn.layer.borderColor = kSeparateLineCGColor;
        // 添加长按手势,用作删除.  加号按钮不添加
        UILongPressGestureRecognizer *gester = [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPress:)];
        [addBtn addGestureRecognizer:gester];
        [cell.contentView addSubview:addBtn];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint
                                           constraintWithItem:addBtn
                                           attribute:NSLayoutAttributeTop
                                           relatedBy:NSLayoutRelationEqual
                                           toItem:cell.contentView
                                           attribute:NSLayoutAttributeTop
                                           multiplier:1.0
                                           constant:5];
        [cell.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint
                                            constraintWithItem:addBtn
                                            attribute:NSLayoutAttributeLeft
                                            relatedBy:NSLayoutRelationEqual
                                            toItem:cell.contentView
                                            attribute:NSLayoutAttributeLeft
                                            multiplier:1.0
                                            constant:20];
        [cell.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint
                                             constraintWithItem:addBtn
                                             attribute:NSLayoutAttributeRight
                                             relatedBy:NSLayoutRelationEqual
                                             toItem:cell.contentView
                                             attribute:NSLayoutAttributeCenterX
                                             multiplier:1.0
                                             constant:-10];
        [cell.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint
                                              constraintWithItem:addBtn
                                              attribute:NSLayoutAttributeHeight
                                              relatedBy:NSLayoutRelationEqual
                                              toItem:nil
                                              attribute:NSLayoutAttributeNotAnAttribute
                                              multiplier:1.0
                                              constant:90];
        [cell.contentView addConstraint:overDateHeight];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint
                                              constraintWithItem:addBtn
                                              attribute:NSLayoutAttributeBottom
                                              relatedBy:NSLayoutRelationEqual
                                              toItem:cell.contentView
                                              attribute:NSLayoutAttributeBottom
                                              multiplier:1.0
                                              constant:-5];
        [cell.contentView addConstraint:overDateBottom];
        
        cell.overDateLeft.constant = kScreenWidth / 2 + 10;
        cell.overDateRight.constant = - 20;
        [UIView animateWithDuration:0.3 animations:^{
            [cell.contentView layoutIfNeeded];
        }];

    }
    _isFull = !_isFull;
}

- (void)longPress:(UIGestureRecognizer *)gestureRecognizer
{
    if (gestureRecognizer.state == UIGestureRecognizerStateBegan)  {
        
        // 获取到点击的显示图片的按钮
        UIButton *showButton = (UIButton *)gestureRecognizer.view;
        
        // 创建长按删除的按钮
        UIButton *deleteButton = [UIButton buttonWithType:UIButtonTypeCustom];
        deleteButton.backgroundColor = [UIColor redColor];
       // deleteButton.bounds = CGRectMake(0, 0, deleImageWH, deleImageWH);
       // [deleteButton setImage:[UIImage imageNamed:kAdeleImage] forState:UIControlStateNormal];
        [deleteButton addTarget:self action:@selector(deletePicture:) forControlEvents:UIControlEventTouchUpInside];
        deleteButton.frame = CGRectMake(showButton.frame.size.width - deleteButton.frame.size.width, 0, deleteButton.frame.size.width, deleteButton.frame.size.height);
        [showButton addSubview:deleteButton];
    }
}

- (void)deletePicture:(UIButton *)button
{
    // 从存放所有Image的数组里移除当前点击的Image
//    [self.footerView.takePhotoView.allImages removeObject:[(UIButton *)button.superview imageForState:UIControlStateNormal]];
    // 移除显示Image的Button
    [button.superview removeFromSuperview];
    
    NSString *imageName = @"";
    //_imageNameArray[button.superview.tag - 1];
    NSString *fullPath = [[NSHomeDirectory() stringByAppendingPathComponent:@"Documents"] stringByAppendingPathComponent:imageName];
    NSFileManager* fileManager = [NSFileManager defaultManager];
    BOOL blHave=[[NSFileManager defaultManager] fileExistsAtPath:fullPath];
    if (!blHave) {
        return ;
    } else {
        BOOL blDele= [fileManager removeItemAtPath:fullPath error:nil];
        if (blDele) {
            NSLog(@"dele success");
        }else {
            NSLog(@"dele fail");
        }
    }
    
}



#pragma mark - TableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _rowNumber;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row < 2) {
        InspectPointCell *cell=[tableView dequeueReusableCellWithIdentifier:kInspectPointCell];
        if (!cell) {
            cell = [[InspectPointCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kInspectPointCell];
        }
        if (indexPath.row == 0) {
            cell.titleLabel.text = [NSString stringWithFormat:@"%@", _taskModel.title];
            cell.detailLabel.text = [NSString stringWithFormat:@"要求图片%d张", _taskModel.attachmentNumber];
        } else {
            cell.titleLabel.text = @"参考说明";
            cell.detailLabel.text = [NSString stringWithFormat:@"%@", _taskModel.reference];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    } else {
        NSString *identifier = [NSString stringWithFormat:@"InspectPictureCell%d", _random++];
        InpectPictureCell *cell=[tableView dequeueReusableCellWithIdentifier:identifier];
        if (!cell) {
        cell = [[InpectPictureCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:identifier];
        }
        [cell.photoButton addTarget:self action:@selector(reloadTableView:) forControlEvents:UIControlEventTouchUpInside];
        return cell;
    }
}



- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    
}


// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}


#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 300.0;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
