//
//
//  redstar
//
//  Created by admin on 15/11/27.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InpectPictureCell.h"

@implementation InpectPictureCell

#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setup
{
    
}

- (UIButton *)photoButton
{
    if (!_photoButton) {
        _photoButton = [[UIButton alloc] init];
        _photoButton.translatesAutoresizingMaskIntoConstraints = NO;
        _photoButton.backgroundColor = [UIColor redColor];
        [self.contentView addSubview:_photoButton];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint
                                           constraintWithItem:_photoButton
                                           attribute:NSLayoutAttributeTop
                                           relatedBy:NSLayoutRelationEqual
                                           toItem:self.contentView
                                           attribute:NSLayoutAttributeTop
                                           multiplier:1.0
                                           constant:5];
        [self.contentView addConstraint:overDateTop];
        
        self.overDateLeft = [NSLayoutConstraint
                                            constraintWithItem:_photoButton
                                            attribute:NSLayoutAttributeLeft
                                            relatedBy:NSLayoutRelationEqual
                                            toItem:self.contentView
                                            attribute:NSLayoutAttributeLeft
                                            multiplier:1.0
                                            constant:20];
        [self.contentView addConstraint:_overDateLeft];
        
        self.overDateRight = [NSLayoutConstraint
                                             constraintWithItem:_photoButton
                                             attribute:NSLayoutAttributeRight
                                             relatedBy:NSLayoutRelationEqual
                                             toItem:self.contentView
                                             attribute:NSLayoutAttributeRight
                                             multiplier:1.0
                                             constant:-(kScreenWidth / 2 + 10)];
        [self.contentView addConstraint:_overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint
                                             constraintWithItem:_photoButton
                                             attribute:NSLayoutAttributeHeight
                                             relatedBy:NSLayoutRelationEqual
                                             toItem:nil
                                             attribute:NSLayoutAttributeNotAnAttribute
                                             multiplier:1.0
                                             constant:90];
        [self.contentView addConstraint:overDateHeight];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint
                                              constraintWithItem:_photoButton
                                              attribute:NSLayoutAttributeBottom
                                              relatedBy:NSLayoutRelationEqual
                                              toItem:self.contentView
                                              attribute:NSLayoutAttributeBottom
                                              multiplier:1.0
                                              constant:-5];
        [self.contentView addConstraint:overDateBottom];
    }
    return _photoButton;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
