//
//  InspectDetailFooterView.m
//  redstar
//
//  Created by admin on 15/11/4.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectDetailFooterView.h"

#define kPictureX 20
#define kPictureY 0
#define kPictureWidth (kScreenWidth - kPictureX * 2)
#define kPictureHeight 40

#define kTakePhotoX 0
#define kTakePhotoY kPictureY + kPictureHeight
#define kTakePhotoWidth (kScreenWidth - kTakePhotoX * 2)
#define kTakePhotoHeight 130 // 待处理

#define kIntroX kPictureX
#define kIntroY kTakePhotoY + kTakePhotoHeight
#define kIntroWidth kPictureWidth
#define kIntroHeight kPictureHeight

#define kBackImageX kPictureX
#define kBackImageY kIntroY + kIntroHeight
#define kBackImageWidth kIntroWidth
#define kBackImageHeight 75

#define kReportX kPictureX
#define kReportY kBackImageY + kBackImageHeight + 20
#define kReportWidth kBackImageWidth
#define kReportHeight 50

#define kFootViewHeight kReportY + kReportHeight + 20

@interface InspectDetailFooterView () <UITextViewDelegate>
@property (nonatomic, strong) UILabel *pictureLabel;
@property (nonatomic, strong) UILabel *introLabel;
@property (nonatomic, strong) UIImageView *backImageView2;
@property (nonatomic, strong) UILabel *placeholderLabel2;
@end

@implementation InspectDetailFooterView


- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
        self.backgroundColor = kSectionBackGroundColor;
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup {
   
    self.pictureLabel.text = @"现场照片";
    self.takePhotoView.backgroundColor = kSectionBackGroundColor;
    self.introLabel.text = @"处理说明";
    UIImage *image = [UIImage imageNamed:@"textbox"];
    UIImage *resizingName = [image resizableImageWithCapInsets:UIEdgeInsetsMake(2, 2, 22, 22) resizingMode:UIImageResizingModeStretch];
    self.backImageView2.image = resizingName;
    self.contentTextView.backgroundColor = [UIColor clearColor];
    self.placeholderLabel2.text = @"请在此输入文字...";
    [self.reportBtn setTitle:@"上报结果" forState:UIControlStateNormal];
    
    self.width = kScreenWidth;
    self.height = kFootViewHeight;

}

- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text{
    if (![text isEqualToString:@""]) {
        _placeholderLabel2.hidden = YES;
    }
    if ([text isEqualToString:@""] && range.location == 0 && range.length == 1) {
        _placeholderLabel2.hidden = NO;
    }
    
    if ([text isEqualToString:@"\n"]) {
        [self.contentTextView resignFirstResponder];
        return NO;
    }
    

    return YES;
}

 - (UILabel *)pictureLabel
{
    if (!_pictureLabel) {
        _pictureLabel = [[UILabel alloc] initWithFrame:CGRectMake(kPictureX, kPictureY, kPictureWidth, kPictureHeight)];
        _pictureLabel.font = [UIFont systemFontOfSize:15.0];
        _pictureLabel.textColor = kLightBlack;
        [self addSubview:_pictureLabel];
    }
    return _pictureLabel;
}

- (TakePhotoView *)takePhotoView
{
    if (!_takePhotoView) {
        _takePhotoView = [[TakePhotoView alloc] initWithFrame:CGRectMake(kTakePhotoX, kTakePhotoY, kTakePhotoWidth, kTakePhotoHeight)];
        [self addSubview:_takePhotoView];
    }
    return _takePhotoView;
}

- (UILabel *)introLabel
{
    if (!_introLabel) {
        _introLabel = [[UILabel alloc] init];
        _introLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _introLabel.font = [UIFont systemFontOfSize:15.0];
        _introLabel.textColor = kLightBlack;
        [self addSubview:_introLabel];

        NSLayoutConstraint *someoneTop = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.takePhotoView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:someoneTop];
        
        NSLayoutConstraint *someoneLeft = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:someoneLeft];
        
        NSLayoutConstraint *someoneRight = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:someoneRight];
        
        NSLayoutConstraint *someoneHeight = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self addConstraint:someoneHeight];
        
    }
    return _introLabel;
}

- (UIImageView *)backImageView2
{
    if (!_backImageView2) {
        _backImageView2 = [[UIImageView alloc] initWithFrame:CGRectMake(kBackImageX, kBackImageY, kBackImageWidth, kBackImageHeight)];
        _backImageView2.userInteractionEnabled = YES;
        _backImageView2.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_backImageView2];
        
        NSLayoutConstraint *someoneTop = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.introLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:someoneTop];
        
        NSLayoutConstraint *someoneLeft = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:someoneLeft];
        
        NSLayoutConstraint *someoneRight = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:someoneRight];
        
        NSLayoutConstraint *someoneHeight = [NSLayoutConstraint constraintWithItem:_backImageView2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:75];
        [self addConstraint:someoneHeight];
    }
    return _backImageView2;
}


- (UITextView *)contentTextView
{
    if (!_contentTextView) {
        _contentTextView = [[UITextView alloc] init];
        _contentTextView.font = [UIFont systemFontOfSize:15.0];
        _contentTextView.delegate = self;
        _contentTextView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.backImageView2 addSubview:_contentTextView];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.backImageView2 addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [self.backImageView2 addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
        [self.backImageView2 addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.backImageView2 addConstraint:contentHeight];
    }
    return _contentTextView;
}

- (UILabel *)placeholderLabel2
{
    if (!_placeholderLabel2) {
        _placeholderLabel2 = [[UILabel alloc] init];
        _placeholderLabel2.translatesAutoresizingMaskIntoConstraints = NO;
        _placeholderLabel2.font = [UIFont systemFontOfSize:15.0];
        _placeholderLabel2.textColor = kOnLineCellDetailColor;
        [self.contentTextView addSubview:_placeholderLabel2];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [self.contentTextView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:5];
        [self.contentTextView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentTextView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentTextView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_placeholderLabel2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentTextView addConstraint:contentHeight];
    }
    return _placeholderLabel2;
}

- (UIButton *)reportBtn
{
    if (!_reportBtn) {
        _reportBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        _reportBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _reportBtn.titleLabel.font = [UIFont systemFontOfSize:20.0];
        _reportBtn.backgroundColor = kNavigationBarColor;
        _reportBtn.layer.cornerRadius = 5.0;
        [_reportBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [self addSubview:_reportBtn];
        
        NSLayoutConstraint *someoneTop = [NSLayoutConstraint constraintWithItem:_reportBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView2 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
        [self addConstraint:someoneTop];
        
        NSLayoutConstraint *someoneLeft = [NSLayoutConstraint constraintWithItem:_reportBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:someoneLeft];
        
        NSLayoutConstraint *someoneRight = [NSLayoutConstraint constraintWithItem:_reportBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:someoneRight];
        
        NSLayoutConstraint *someoneHeight = [NSLayoutConstraint constraintWithItem:_reportBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self addConstraint:someoneHeight];

    }
    return _reportBtn;
}

@end
