//
//  PictureTableCell.m
//  redstar
//
//  Created by admin on 15/11/1.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "PictureTableCell.h"

@interface PictureTableCell ()
@property (nonatomic, strong) UILabel *hotLabel;
@end

@implementation PictureTableCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}


#pragma mark - Private Methods
- (void)setup
{
    self.titleImageView.image = [UIImage imageNamed:@"default_pic"];
    self.titleLabel.textColor = kPictureCellTitleColor;
    self.hotLabel.font = [UIFont boldSystemFontOfSize:12.0];
    self.detailsLabel.textColor = kPictureCellDetailsColor;
    self.dateLabel.textColor = kPictureCellDateColor;
    self.thumbBtn.titleLabel.font = [UIFont systemFontOfSize:16.0];
    self.commentBtn.titleLabel.font = [UIFont systemFontOfSize:16.0];
}

#pragma mark - Lazy loading
- (UIImageView *)titleImageView
{
    if (!_titleImageView) {
        _titleImageView = [[UIImageView alloc] init];
        _titleImageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_titleImageView];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_titleImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:18];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageLeft = [NSLayoutConstraint constraintWithItem:_titleImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:15];
        [self.contentView addConstraint:titleImageLeft];
        
        NSLayoutConstraint *titleImageWidth = [NSLayoutConstraint constraintWithItem:_titleImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:85];
        [self.contentView addConstraint:titleImageWidth];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_titleImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self.contentView addConstraint:titleImageHeight];
    }
    return _titleImageView;
}

- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.font = [UIFont systemFontOfSize:17.0];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_titleLabel];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:16];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:10];
        [self.contentView addConstraint:titleImageLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.hotLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:titleImageHeight];
    }
    return _titleLabel;
}
- (UILabel *)hotLabel
{
    if (!_hotLabel) {
        _hotLabel = [[UILabel alloc] init];
        _hotLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _hotLabel.backgroundColor = kHotBackGroundColor;
        _hotLabel.textColor = [UIColor whiteColor];
        _hotLabel.text = @"HOT";
        _hotLabel.textAlignment = NSTextAlignmentCenter;
        _hotLabel.layer.cornerRadius = 3;
        [self.contentView addSubview:_hotLabel];
        
        // 顶端
        NSLayoutConstraint *hotTop = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:20];
        [self.contentView addConstraint:hotTop];
        
        // 左边
        NSLayoutConstraint *hotWidth = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:34];
        [self.contentView addConstraint:hotWidth];
        
        NSLayoutConstraint *hotRight = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:hotRight];
        
        NSLayoutConstraint *hotHeight = [NSLayoutConstraint constraintWithItem:_hotLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:15];
        [self.contentView addConstraint:hotHeight];
    }
    return _hotLabel;
}
- (UILabel *)detailsLabel
{
    if (!_detailsLabel) {
        _detailsLabel = [[UILabel alloc] init];
        _detailsLabel.font = [UIFont systemFontOfSize:15.0];
        _detailsLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _detailsLabel.numberOfLines = 0;
        [self.contentView addSubview:_detailsLabel];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageLeft = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:10];
        [self.contentView addConstraint:titleImageLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-15];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_detailsLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self.contentView addConstraint:titleImageHeight];
    }
    return _detailsLabel;
}

- (UILabel *)dateLabel
{
    if (!_dateLabel) {
        _dateLabel = [[UILabel alloc] init];
        _dateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _dateLabel.font = [UIFont systemFontOfSize:14.0];
        [self.contentView addSubview:_dateLabel];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageLeft = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:15];
        [self.contentView addConstraint:titleImageLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.thumbBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self.contentView addConstraint:titleImageHeight];
        
        NSLayoutConstraint *titleImageBottom = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleImageBottom];
    }
    return _dateLabel;
}

- (ZanButton *)thumbBtn
{
    if (!_thumbBtn) {
        _thumbBtn = [[ZanButton alloc] init];
        [_thumbBtn setImage:[UIImage imageNamed:@"commend"] forState:UIControlStateNormal];
        _thumbBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_thumbBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        [self.contentView addSubview:_thumbBtn];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:12];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageWidth = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.commentBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleImageWidth];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.commentBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-15];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleImageHeight];
    }
    return _thumbBtn;
}

- (ZanButton *)commentBtn
{
    if (!_commentBtn) {
        _commentBtn = [[ZanButton alloc] init];
        [_commentBtn setImage:[UIImage imageNamed:@"comment"] forState:UIControlStateNormal];
        _commentBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_commentBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        [self.contentView addSubview:_commentBtn];
        
        NSLayoutConstraint *titleImageTop = [NSLayoutConstraint constraintWithItem:_commentBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:12];
        [self.contentView addConstraint:titleImageTop];
        
        NSLayoutConstraint *titleImageWidth = [NSLayoutConstraint constraintWithItem:_commentBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self.contentView addConstraint:titleImageWidth];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_commentBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-15];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleImageHeight = [NSLayoutConstraint constraintWithItem:_commentBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleImageHeight];
    }
    return _commentBtn;
}
- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
