//
//  AnnounceViewController.m
//  redstar
//
//  Created by admin on 15/10/24.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AnnounceViewController.h"
#import "InspectListViewController.h"
#import "RankingListViewController.h"
#import "PictureViewController.h"
#import "QuestionViewController.h"



@interface AnnounceViewController ()
@property (nonatomic, strong) UIView *lineView;
@end

@implementation AnnounceViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"功能"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    [self setup];
}

#pragma mark - Private Methods
- (void)setup
{
    [self.onLineSamplingBtn setTitle:@"在线抽查" forState:UIControlStateNormal];
    [self.wordOfMouthBtn setTitle:@"口碑巡检" forState:UIControlStateNormal];
    [self.standardBtn setTitle:@"口碑标准" forState:UIControlStateNormal];
    [self.pictureBtn setTitle:@"图说口碑" forState:UIControlStateNormal];
    [self.questionBtn setTitle:@"问题与知识" forState:UIControlStateNormal];
    [self.caseBtn setTitle:@"优秀案例" forState:UIControlStateNormal];
    self.lineView.backgroundColor = kSeparateLineViewColor;

}

- (void)itemClick:(FuncItem *)sender
{
    FuncItem *item = (FuncItem *)sender;
    UINavigationController *nav;
    if ([item.titleLabel.text isEqualToString:@"在线抽查"]) {
        return;
    } else if ([item.titleLabel.text isEqualToString:@"口碑巡检"]) {
        InspectListViewController *inspectListVC = [[InspectListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:inspectListVC];
    } else if ([item.titleLabel.text isEqualToString:@"口碑标准"]) {
        return;
    } else if ([item.titleLabel.text isEqualToString:@"图说口碑"]) {
        PictureViewController *pictureVC = [[PictureViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:pictureVC];
    } else if ([item.titleLabel.text isEqualToString:@"问题与知识"]) {
        QuestionViewController *questionVC = [[QuestionViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:questionVC];
    } else if ([item.titleLabel.text isEqualToString:@"优秀案例"]) {
        RankingListViewController *rankingListVC = [[RankingListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:rankingListVC];
    } else {
        return;
    }
    
    [nav.navigationBar setBarTintColor:kNavigationBarColor];
    [nav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    [self presentViewController:nav animated:YES completion:nil];
}


#pragma mark - lazy loading
- (FuncItem *)onLineSamplingBtn
{
    if (!_onLineSamplingBtn) {
        _onLineSamplingBtn = [[FuncItem alloc] init];
        _onLineSamplingBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_onLineSamplingBtn addTarget:self action:@selector(itemClick:) forControlEvents:UIControlEventTouchUpInside];
        [_onLineSamplingBtn setImage:[UIImage imageNamed:@"task_000"] forState:UIControlStateNormal];
        [self.view addSubview:_onLineSamplingBtn];
        
        NSLayoutConstraint *onLineSamplingTop = [NSLayoutConstraint constraintWithItem:_onLineSamplingBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:onLineSamplingTop];
        
        NSLayoutConstraint *onLineSamplingLeft = [NSLayoutConstraint constraintWithItem:_onLineSamplingBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:onLineSamplingLeft];
        
        NSLayoutConstraint *onLineSamplingWidth = [NSLayoutConstraint constraintWithItem:_onLineSamplingBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.wordOfMouthBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.view addConstraint:onLineSamplingWidth];
        
        NSLayoutConstraint *onLineSamplingRight = [NSLayoutConstraint constraintWithItem:_onLineSamplingBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.wordOfMouthBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:onLineSamplingRight];
        
        NSLayoutConstraint *onLineSamplingHeight = [NSLayoutConstraint constraintWithItem:_onLineSamplingBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:119];
        [self.view addConstraint:onLineSamplingHeight];
        
        
        
    }
    return _onLineSamplingBtn;
}

- (FuncItem *)wordOfMouthBtn
{
    if (!_wordOfMouthBtn) {
        _wordOfMouthBtn = [[FuncItem alloc] init];
        [_wordOfMouthBtn addTarget:self action:@selector(itemClick:) forControlEvents:UIControlEventTouchUpInside];

        [_wordOfMouthBtn setImage:[UIImage imageNamed:@"task_001"] forState:UIControlStateNormal];
        _wordOfMouthBtn.translatesAutoresizingMaskIntoConstraints = NO;
        
        [self.view addSubview:_wordOfMouthBtn];
        
        NSLayoutConstraint *wordOfMouthTop = [NSLayoutConstraint constraintWithItem:_wordOfMouthBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:wordOfMouthTop];
        
        NSLayoutConstraint *wordOfMouthRight = [NSLayoutConstraint constraintWithItem:_wordOfMouthBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.standardBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:wordOfMouthRight];
        
        NSLayoutConstraint *wordOfMouthWithd = [NSLayoutConstraint constraintWithItem:_wordOfMouthBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.standardBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.view addConstraint:wordOfMouthWithd];
        
        NSLayoutConstraint *wordOfMouthHeight = [NSLayoutConstraint constraintWithItem:_wordOfMouthBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:_onLineSamplingBtn attribute:NSLayoutAttributeHeight multiplier:1.0 constant:0];
        [self.view addConstraint:wordOfMouthHeight];
        
    }
    return _wordOfMouthBtn;
}

- (FuncItem *)standardBtn
{
    if (!_standardBtn) {
        _standardBtn = [[FuncItem alloc] init];
        [_standardBtn setImage:[UIImage imageNamed:@"task_002"] forState:UIControlStateNormal];
        _standardBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_standardBtn addTarget:self action:@selector(itemClick:) forControlEvents:UIControlEventTouchUpInside];

        [self.view addSubview:_standardBtn];
        
        NSLayoutConstraint *standardRight = [NSLayoutConstraint constraintWithItem:_standardBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:standardRight];
        
        
        NSLayoutConstraint *standardHeight = [NSLayoutConstraint constraintWithItem:_standardBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:_wordOfMouthBtn attribute:NSLayoutAttributeHeight multiplier:1.0 constant:0];
        [self.view addConstraint:standardHeight];
        
        
        NSLayoutConstraint *standardTop = [NSLayoutConstraint constraintWithItem:_standardBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:standardTop];
        
    }
    return _standardBtn;
}

- (FuncItem *)pictureBtn
{
    if (!_pictureBtn) {
        _pictureBtn = [[FuncItem alloc] init];
        [_pictureBtn setImage:[UIImage imageNamed:@"task_003"] forState:UIControlStateNormal];
        _pictureBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_pictureBtn addTarget:self action:@selector(itemClick:) forControlEvents:UIControlEventTouchUpInside];

        [self.view addSubview:_pictureBtn];
        
        NSLayoutConstraint *pictureTop = [NSLayoutConstraint constraintWithItem:_pictureBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.onLineSamplingBtn attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:pictureTop];
        
        NSLayoutConstraint *pictureLeft = [NSLayoutConstraint constraintWithItem:_pictureBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:pictureLeft];
        
        
        NSLayoutConstraint *pictureRight = [NSLayoutConstraint constraintWithItem:_pictureBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.questionBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:pictureRight];
        
        NSLayoutConstraint *pictureWidth = [NSLayoutConstraint constraintWithItem:_pictureBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.questionBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.view addConstraint:pictureWidth];
        
        NSLayoutConstraint *pictureHeight = [NSLayoutConstraint constraintWithItem:_pictureBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:self.onLineSamplingBtn attribute:NSLayoutAttributeHeight multiplier:1.0 constant:0];
        [self.view addConstraint:pictureHeight];
        
    }
    return _pictureBtn;
}

- (FuncItem *)questionBtn
{
    if (!_questionBtn) {
        _questionBtn = [[FuncItem alloc] init];
        [_questionBtn setImage:[UIImage imageNamed:@"task_004"] forState:UIControlStateNormal];
        _questionBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_questionBtn addTarget:self action:@selector(itemClick:) forControlEvents:UIControlEventTouchUpInside];

        [self.view addSubview:_questionBtn];
        
        NSLayoutConstraint *questionWidth = [NSLayoutConstraint constraintWithItem:_questionBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.caseBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.view addConstraint:questionWidth];
        
        NSLayoutConstraint *questionRight = [NSLayoutConstraint constraintWithItem:_questionBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.caseBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:questionRight];
        
        NSLayoutConstraint *questionTop = [NSLayoutConstraint constraintWithItem:_questionBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_pictureBtn attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:questionTop];
        
        NSLayoutConstraint *questionHeight = [NSLayoutConstraint constraintWithItem:_questionBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:_pictureBtn attribute:NSLayoutAttributeHeight multiplier:1.0 constant:0];
        [self.view addConstraint:questionHeight];
    }
    return _questionBtn;
}

- (FuncItem *)caseBtn
{
    if (!_caseBtn) {
        _caseBtn = [[FuncItem alloc] init];
        [_caseBtn setImage:[UIImage imageNamed:@"task_005"] forState:UIControlStateNormal];
        _caseBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_caseBtn addTarget:self action:@selector(itemClick:) forControlEvents:UIControlEventTouchUpInside];

        [self.view addSubview:_caseBtn];
        
        NSLayoutConstraint *caseTop = [NSLayoutConstraint constraintWithItem:_caseBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_questionBtn attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:caseTop];
        
        NSLayoutConstraint *caseRight = [NSLayoutConstraint constraintWithItem:_caseBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:caseRight];
        
        NSLayoutConstraint *caseHeight = [NSLayoutConstraint constraintWithItem:_caseBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:_questionBtn attribute:NSLayoutAttributeHeight multiplier:1.0 constant:0];
        [self.view addConstraint:caseHeight];
        
    }
    return _caseBtn;
}

- (UIView *)lineView
{
    if (!_lineView) {
        _lineView = [[UIView alloc] init];
        _lineView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.view addSubview:_lineView];
        
        NSLayoutConstraint *lineViewLeft = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:lineViewLeft];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewTop = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.caseBtn attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:lineViewTop];
        
        NSLayoutConstraint *lineViewHeight = [NSLayoutConstraint constraintWithItem:_lineView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
        [self.view addConstraint:lineViewHeight];
    }
    return _lineView;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
