//
//  RootTabBarController.m
//  redstar
//
//  Created by admin on 15/11/3.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RootTabBarController.h"

#import "HomeViewController.h"
#import "AnnounceViewController.h"
#import "ChartViewController.h"
#import "MineViewController.h"

#import <AFNetworking.h>
#import "CommonFunc.h"

@interface RootTabBarController ()
@end

@implementation RootTabBarController

- (void)viewDidLoad
{
    [self setupTabbar];
        
    self.delegate = self;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.parentViewController.tabBarController.tabBar.hidden = YES;

}

- (void)viewDidDisappear:(BOOL)animated
{
    self.parentViewController.tabBarController.tabBar.hidden = YES;

}


//
- (void)setupTabbar
{
    // 跳转到tabbarController
    
    HomeViewController *home = (HomeViewController *)[self setUpOneChildViewController:[[HomeViewController alloc] init] title:@"首页" imageName:@"home_unchecked" selImageName:@"home_checked"];
    UINavigationController *homeNav = [[UINavigationController alloc] initWithRootViewController:home];
    [homeNav.navigationBar setBarTintColor:kNavigationBarColor];
    [homeNav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    
    
    AnnounceViewController *announce = (AnnounceViewController *)[self setUpOneChildViewController:[[AnnounceViewController alloc] init] title:@"功能" imageName:@"function_uncheck" selImageName:@"function_check"];
    // 添加nav
    UINavigationController *announceNav = [[UINavigationController alloc] initWithRootViewController:announce];
    [announceNav.navigationBar setBarTintColor:kNavigationBarColor];
    [announceNav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    
    ChartViewController *chart = (ChartViewController *)[self setUpOneChildViewController:[[ChartViewController alloc] init] title:@"报表查询" imageName:@"report_unchecked" selImageName:@"report_checked"];
    UINavigationController *chartNav = [[UINavigationController alloc] initWithRootViewController:chart];
    [chartNav.navigationBar setBarTintColor:kNavigationBarColor];
    [chartNav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    
    MineViewController *mine = (MineViewController *)[self setUpOneChildViewController:[[MineViewController alloc] init] title:@"我的" imageName:@"aboutme_unchecked" selImageName:@"aboutme_checke"];
    UINavigationController *mineNav = [[UINavigationController alloc] initWithRootViewController:mine];
    [mineNav.navigationBar setBarTintColor:kNavigationBarColor];
    [mineNav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    
    [[UITabBarItem appearance] setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:
                                                       kNavigationBarColor, NSForegroundColorAttributeName,
                                                       nil] forState:UIControlStateSelected];

    self.viewControllers = @[homeNav, announceNav, chartNav, mineNav];
}



// 添加一个控制器的属性
- (UIViewController *)setUpOneChildViewController:(UIViewController *)vc title:(NSString *)title imageName:(NSString *)imageName selImageName:(NSString *)selImageName
{
    // 添加TabBar按钮的图片文字
    vc.title = title;
    vc.tabBarItem.image = [UIImage imageNamed:imageName];
    UIImage *selImage = [UIImage imageNamed:selImageName];
    selImage = [selImage imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
    vc.tabBarItem.selectedImage = selImage;
    
    return vc;
    
    
}

#pragma mark - UITabBarController Delegate
//
//- (BOOL)tabBarController:(UITabBarController *)tabBarController shouldSelectViewController:(UIViewController *)viewController {
//    NSLog(@"shouldSelectViewController  %@", tabBarController.selectedViewController);
//    if (viewController.tabBarItem.tag == 30001) {
//        [((UINavigationController *)tabBarController.selectedViewController) pushViewController:viewController animated:YES];
//        return NO;
//    }
//    return YES;
//}

//- (void)tabBarController:(UITabBarController *)tabBarController didSelectViewController:(UIViewController *)viewController
//{
//    if ([viewController isKindOfClass:[MineViewController class]]) {
//        MineViewController *mine = [[MineViewController alloc] init];
//        mine.tabBarItem.title= @"我的";
//        mine.tabBarItem.image = [UIImage imageNamed:@"aboutme_unchecked"];
//        mine.tabBarItem.selectedImage = [[UIImage imageNamed:@"aboutme_checke"] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
//        [((UINavigationController *)tabBarController.selectedViewController) pushViewController:mine animated:YES];
//    }
//}


@end
