//
//  HttpClient.m
//  redstar
//
//  Created by admin on 15/11/7.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "HttpClient.h"
#import "CommonFunc.h"

@interface HttpClient ()
{
    AFHTTPSessionManager *_manager;
    NSString *_url;
}

@end
@implementation HttpClient

- (id)initWithUrl:(NSString *)url
{
    self = [super init];
    if (self) {
        _url = url;
        _manager = [AFHTTPSessionManager manager];
        _manager.requestSerializer = [AFJSONRequestSerializer serializer];
        _manager.responseSerializer = [AFJSONResponseSerializer serializer];
        
        
        
        // 设置请求头
        [_manager.requestSerializer setValue:@"application/json;charset=utf-8" forHTTPHeaderField:@"Content-Type"];
        //[_manager.requestSerializer setValue:@"5a74170150b940ae0150b940f7db0082" forHTTPHeaderField:@"enterprise"];
        [_manager.requestSerializer setValue:[[NSUserDefaults standardUserDefaults] objectForKey:@"enterprise_uuid"] forHTTPHeaderField:@"enterprise"];
    }
    return self;
}


// 登陆初始化
- (id)initWithLogin
{
    self = [super init];
    if (self) {
        _manager = [AFHTTPSessionManager manager];
        _manager.requestSerializer = [AFJSONRequestSerializer serializer];
        _manager.responseSerializer = [AFJSONResponseSerializer serializer];
        
        // 设置请求头
        [_manager.requestSerializer setValue:@"application/json;charset=utf-8" forHTTPHeaderField:@"Content-Type"];        
    }
    return self;
}

- (void)postParameters:(id)parameters completion:(completionBlock)completion
{
    NSString *url = _url;
    [_manager POST:url parameters:parameters success:^(NSURLSessionDataTask *task, id responseObject) {
        if (completion) {
            NSError *error = nil;
            completion(responseObject, error);
        }
    } failure:^(NSURLSessionDataTask *task, NSError *error) {
        if (completion) {
            completion(nil,error);
        }
    }];
}


- (void)getParameters:(id)parameters completion:(completionBlock)completion
{
    NSString *url = _url;
    [_manager GET:url parameters:parameters success:^(NSURLSessionDataTask *task, id responseObject) {
        if (completion) {
            NSError *error = nil;
            completion(responseObject, error);
        }
    } failure:^(NSURLSessionDataTask *task, NSError *error) {
        if (completion) {
            completion(nil,error);
        }
    }];
}

// 登陆
- (void)loginWithUsername:(NSString *)username password:(NSString *)password completion:(completionBlock)completion
{
    // url
    NSString *url = [NSString stringWithFormat:@"%@%@%@", kRedStarURL, kLoginURL, username];
    url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];

    // password
    //NSString *passwordMD5 = [CommonFunc md5:password];
    // 参数
    NSDictionary *parameters = @{@"authenticode":@"211534962",
                                 @"password":password
                                 };
    [_manager POST:url parameters:parameters success:^(NSURLSessionDataTask *task, id responseObject) {
        if (completion) {
            NSError *error = nil;
            completion(responseObject, error);
        }
    } failure:^(NSURLSessionDataTask *task, NSError *error) {
        if (completion) {
            completion(nil,error);
        }
    }];
}

- (void)checkAndUpdateCurrentVersionWithCompletion:(completionBlock)completion
{
    [self getParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 获取问题列表
- (void)getQuestionListWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

- (void)getQuestionDetailWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self getParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 获取巡检列表
- (void)getInspectListWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 获取巡检列表
- (void)getRankingListWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 获取口碑巡检明细
- (void)getPraiseDetailWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self getParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

- (void)submitCommentWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 点赞
- (void)likeCountWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 取消点赞
- (void)cancelLikeCountWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 上传新问题
- (void)uploadNewQuestionWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

- (void)uploadInspectResultWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

- (void)getAnnounceListWithCompletion:(completionBlock)completion
{
    [self postParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

- (void)getAnnounceDetailWithCompletion:(completionBlock)completion
{
    [self getParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 提交公告已读状态
- (void)settingAnnounceYetReadWithCompletion:(completionBlock)completion
{
    [self postParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 获取管理层的抽查任务的列表
- (void)getManageSportCheckListWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 获取商场的抽查列表
- (void)getStoreSportCheckListWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}


// 发起抽查
- (void)saveSportCheckWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 抽查任务的明细
- (void)getSportCheckDetailWithCompletion:(completionBlock)completion
{
    [self getParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 上报抽查结果
- (void)reportCheckResultWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 抽查评分
- (void)gradeCheckResultWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}


// 获取问题专业组
- (void)getQuestionGroupWithCompletion:(completionBlock)completion
{
    [self getParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 获取问题专业组
- (void)getQuestionCategoryWithCompletion:(completionBlock)completion
{
    [self getParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

/**
 *  图说口碑相关URL
 */

// 保存图说口碑
- (void)savePicturePraiseWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 上传口碑图片
- (void)upLoadPraisePictureWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 提交图说口碑
- (void)submitPicturePraiseWithCompletion:(completionBlock)completion
{
    [self postParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 查询图说口碑
- (void)queryPicturePraiseWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 图说口碑明细
- (void)getPicturePraiseDetailWithCompletion:(completionBlock)completion
{
    [self getParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 口碑点赞
- (void)getLikePicturePraiseWithCompletion:(completionBlock)completion
{
    [self postParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 口碑取消点赞
- (void)cancelLikePicturePraiseWithCompletion:(completionBlock)completion
{
    [self postParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

// 获取口碑列表
- (void)queryShortPraiseWithCompletion:(completionBlock)completion
{
    [self getParameters:nil completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

//
- (void)queryLowerOrgsWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}


// 获取口碑标准的附件列表
- (void)getAttachmentsWithParameters:(id)parameters completion:(completionBlock)completion
{
    [self postParameters:parameters completion:^(id response, NSError *error) {
        if (completion) {
            completion (response, error);
        }
    }];
}

@end
