//
//  HomeViewController.m
//  redstar
//
//  Created by admin on 15/10/23.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "HomeViewController.h"
#import "HomeHeaderView.h"
#import "RankListHeaderView.h"

#import "InspectListViewController.h"
#import "RankingListViewController.h"
#import "OnLineViewController.h"
#import "PicCategoryViewController.h"
#import "QuestionViewController.h"
#import "PictureViewController.h"

#import "HomeCellItem.h"

#import "PictureTableCell.h"
#define kHomePictureListCell @"homePictureListCell"
#import "PictureStoryViewController.h"

#import "HomeTitleTableCell.h"
#define kHomeTitleTableCell @"homeTitleTableCell"
#import "RankingListCell.h"
#define kHomeRankingListCell @"homeRankingListsCell"
#import "RankDetailViewController.h"
#import "RankListModel.h"
#import "RankCommentCell.h"

#import "QuestionListTableCell.h"
#define kHomeQuestionListTableCell @"homeQuestionListTableCell"
#import "QuestionModel.h"
#import "QuestionDetailViewController.h"
#define kQuestionTag 387428

#import "InspectListCell.h"
#define kHomeInspectListCell @"homeInspectListsCell"
#import "InspectTaskViewController.h"
#import "TaskListModel.h"

#import "PictureTableCell.h"
#define KHomePicTableCell @"pictureTableViewCell"

#import "SpotCheckOnLineViewController.h"

#import "LookOnLineViewController.h"

#import "StandardViewController.h"

#import "HttpClient.h"
#import <MBProgressHUD.h>

#import <MJRefresh.h>
#import "SearchViewController.h"

typedef NSComparisonResult (^NSComparator)(id obj1, id obj2);

@interface HomeViewController () <UITableViewDelegate, UITableViewDataSource, UIScrollViewDelegate, UITextFieldDelegate, RankListHeaderDelegate>
@property (nonatomic, strong) UIImageView *bgImageView; // 背景
@property (nonatomic, strong) UITextField *searchTextField; // 搜索框
@property (nonatomic, strong) UILabel *shopnameLabel; // 店名
@property (nonatomic, strong) UILabel *nameLabel; // 用户姓名


// 当前视图
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) HomeHeaderView *headView;

@property (nonatomic, strong) NSMutableArray *titleArray; // section标题
@property (nonatomic, strong) NSMutableArray *sectionArray; // section标题

@property (nonatomic, strong) NSMutableArray *allQuestionArray; // 问题与知识
@property (nonatomic, strong) NSMutableArray *taskListDataArray; // 问题与知识
@property (nonatomic, strong) NSMutableArray *allRankListArray;
@property (nonatomic, strong) NSMutableArray *allPraiseListArray;
@property (nonatomic, strong) NSMutableArray *allExcellentCaseArray; // 优秀案例
@property (nonatomic, strong) NSMutableArray *allPatrolReportArray; // 巡店报告

@end

@implementation HomeViewController

#pragma mark - ViewDidLoad
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"首页"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    self.titleArray = [NSMutableArray array];
    self.sectionArray = [NSMutableArray arrayWithObjects:@"口碑报告",@"商场风采",@"优秀案例",@"巡店报告", @"问题知识",@"口碑巡检",nil];
    self.allRankListArray = [NSMutableArray array];
    self.taskListDataArray = [NSMutableArray array];
    self.allQuestionArray = [NSMutableArray array];
    self.allPraiseListArray = [NSMutableArray array];
    
    [self setupNav];
    
    
    NSArray *permissions = [[NSUserDefaults standardUserDefaults] objectForKey:@"permissions"];
    
    // 口碑报告 商场风采 图说口碑 口碑标准  问题知识 口碑巡检
    
    if ([permissions containsObject:@"500201"]) {
        [self.titleArray addObject:@"口碑报告"];
        [self requestRankingList];
    } else {
        [_sectionArray removeObject:@"口碑报告"];
    }
    
//    @"casus";
// 
//    sopVC.category = @"report";
    
    [self.titleArray addObject:@"商场风采"];
    
    NSArray *typeArray = [NSArray arrayWithObjects:@"store", @"casus",@"report",nil];
    
    // 商场风采
    [self requestPicturePraiseWithType:typeArray[0]];
    // 优秀案例
    [self requestPicturePraiseWithType:typeArray[1]];
    // 巡店报告
    [self requestPicturePraiseWithType:typeArray[2]];

    
    if ([permissions containsObject:@"500301"] || [permissions containsObject:@"500302"]) {
        [self.titleArray addObject:@"图说口碑"];
    }
    
    if ([permissions containsObject:@"500401"] || [permissions containsObject:@"500402"]) {
        [self.titleArray addObject:@"口碑标准"];
    }
    
    if ([permissions containsObject:@"500501"] || [permissions containsObject:@"500502"]) {
        [self.titleArray addObject:@"问题知识"];
        [self requestQuestionList];
    }else {
        [_sectionArray removeObject:@"问题知识"];
    }
    
    if ([permissions containsObject:@"500101"] || [permissions containsObject:@"500102"]) {
        [self.titleArray addObject:@"口碑巡检"];
        [self requestInspectList];
    }else {
        [_sectionArray removeObject:@"口碑巡检"];
    }
    
    [self setupTableView];
    
    
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(refreshInspectList)
                                                 name:kRefreshInspectPointNotification
                                               object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(refreshQuestionList)
                                                 name:kRefreshQuestionNotification
                                               object:nil];
    
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.tabBarController.tabBar.hidden = NO;
    self.navigationController.navigationBar.hidden = YES;
    [self.tableView.header beginRefreshing];
}

#pragma mark - 刷新数据
- (void)refreshAllData
{
    [self refreshInspectList];
    [self refreshRankingList];
    [self refreshQuestionList];
    [self refreshPraiseList];
}

- (void)refreshPraiseList
{
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQueryPicturePraiseURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSDictionary *parameters = @{
                                 @"scope":@"all",
                                 @"user":user_uuid,
                                 @"type":@"store",
                                 @"pageNumber":@(0),
                                 @"pageSize":@(2)
                                 };
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    // 请求问题列表
    [httpClient queryPicturePraiseWithParameters:parameters completion:^(id response, NSError *error) {
        NSLog(@"刷新！！== 图说口碑 response = %@   error = %@" , response, error);
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *dict in dataArray) {
            PictureListModel *picList = [[PictureListModel alloc] init];
            [picList setValuesForKeysWithDictionary:dict];
            [tempArray addObject:picList];
        }
        _allPraiseListArray = tempArray;
        
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        [self.tableView.header endRefreshing];

    }];

}

// 刷新口碑任务
- (void)refreshInspectList
{
    // 口碑任务
    NSString *url3 = [NSString stringWithFormat:@"%@%@", kRedStarURL, kInspectListURL];
    HttpClient *httpCilent3 = [[HttpClient alloc] initWithUrl:url3];
    NSDictionary *parameters3 = @{@"userUuid":[[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"],
                                  @"queryOrders":@[@{@"field":@"lastModifyInfo", @"direction":@"desc"}],
                                  @"pageNumber":@(0),
                                  @"pageSize":@(2)
                                  };
    
    [httpCilent3 getInspectListWithParameters:parameters3 completion:^(id response, NSError *error) {
        NSLog(@"刷新！！ = 巡检列表%@", response);
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        NSMutableArray *inspectTempArr = [NSMutableArray array];
        for (NSDictionary *dict in dataArray) {
            TaskListModel *taskList = [[TaskListModel alloc] init];
            [taskList setValuesForKeysWithDictionary:dict];
            [inspectTempArr addObject:taskList];
        }
        _taskListDataArray = inspectTempArr;
        
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        [self.tableView.header endRefreshing];
    }];

}

- (void)refreshRankingList {
    // 口碑巡检
    NSString *url1 = [NSString stringWithFormat:@"%@%@", kRedStarURL, kRankingListURL];
    HttpClient *httpCilent1 = [[HttpClient alloc] initWithUrl:url1];
    NSDictionary *parameters1 = @{@"praiseUuid":@"",
                                  @"statisMode":@(0),
                                  @"pageNumber":@(0),
                                  @"pageSize":@(3)
                                  };
    __block HomeViewController *weakSelf = self;
    [httpCilent1 getRankingListWithParameters:parameters1 completion:^(id response, NSError *error) {
        NSLog(@"刷新！！ = 口碑报告response = %@", response);
        
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        
        NSMutableArray *rankTempArr = [NSMutableArray array];
        for (NSDictionary *ListDict in dataArray) {
            RankListModel *rankList = [RankListModel rankListModelWithDict:ListDict];
            [rankTempArr addObject:rankList];
        }
        weakSelf.allRankListArray = rankTempArr;
        
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        [self.tableView.header endRefreshing];

    }];
}

- (void)refreshQuestionList {
    // 问题与知识
    NSString *url2 = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSDictionary *parameters2 = @{
                                  @"user":user_uuid,
                                  @"scope":@"all",
                                  @"pageNumber":@(0),
                                  @"pageSize":@(2)
                                  };
    
    HttpClient *httpClient2 = [[HttpClient alloc] initWithUrl:url2];
    [httpClient2 getQuestionListWithParameters:parameters2 completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"刷新！！ = 问题与知识列表recods = %@", response);
        
        NSMutableArray *questionTempArr = [NSMutableArray array];
        
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [questionTempArr addObject:question];
        }
        _allQuestionArray = questionTempArr;
        
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];

}


#pragma mark - 请求数据
- (void)requestRankingList
{
    
    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kRankingListURL];
    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
    NSDictionary *parameters = @{@"praiseUuid":@"",
                                 @"statisMode":@(0),
                                 @"pageNumber":@(0),
                                 @"pageSize":@(3)
                                 };

    [httpCilent getRankingListWithParameters:parameters completion:^(id response, NSError *error) {
        
        NSLog(@"口碑报告response = %@", response);
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        
        NSMutableArray *tgArray = [NSMutableArray array];
        
        for (NSDictionary *ListDict in dataArray) {
            RankListModel *rankList = [RankListModel rankListModelWithDict:ListDict];
            [tgArray addObject:rankList];
        }
        _allRankListArray = (NSMutableArray *)[self sortRankListWithRankListArray:tgArray];
        
        for (int i = 0 ; i < _allRankListArray.count; i++) {
            RankListModel *rank = _allRankListArray[i];
            if (i == 0) {
                rank.index = i + 1;
            } else {
                RankListModel *prevRank = _allRankListArray[i-1];
                rank.index = rank.score == prevRank.score ? prevRank.index: i + 1;
            }
        }
        if (_allRankListArray.count == 0) {
            [_sectionArray removeObject:@"口碑报告"];
        }
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];

        
        
    }];
}

- (NSArray *)sortRankListWithRankListArray:(NSMutableArray *)allRanking
{
    NSArray *sortedArray = [allRanking sortedArrayUsingComparator:^NSComparisonResult(RankListModel *p1, RankListModel *p2){
        //return [p2.score compare:p1.score];
        return [@(p2.score) compare:@(p1.score)];

    }];
    return sortedArray;
}



- (void)requestInspectList
{
    
    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kInspectListURL];
    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
    

    NSDictionary *parameters = @{
                                 @"userUuid":[[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"],
                                 @"queryOrders":@[@{@"field":@"lastModifyInfo", @"direction":@"desc"}],
                                 @"pageNumber":@(0),
                                 @"pageSize":@(2)
                                 };
    [httpCilent getInspectListWithParameters:parameters completion:^(id response, NSError *error) {
        
        NSLog(@"巡检列表%@", response);
        NSLog(@"error = %@", error);
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *dict in dataArray) {
            TaskListModel *taskList = [[TaskListModel alloc] init];
            [taskList setValuesForKeysWithDictionary:dict];
            [tempArray addObject:taskList];
        }
        _taskListDataArray = [NSMutableArray arrayWithArray:tempArray];
        
        if (_taskListDataArray.count == 0) {
            [_sectionArray removeObject:@"口碑巡检"];
        }
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];

    }];

}

- (void)requestQuestionList
{
    // 初始化数组
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    // 请求参数
    NSDictionary *parameters = @{@"user":user_uuid,
                                 @"scope":@"all",
                                 @"pageNumber":@(0),
                                 @"pageSize":@(2)
                                 };
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        
       // [self requestInspectList];
        
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"问题与知识列表recods = %@", response);
        NSLog(@"error = %@", error);
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [tempArray addObject:question];
        }
        _allQuestionArray = [NSMutableArray arrayWithArray:tempArray];
        if (_allQuestionArray.count == 0) {
            [_sectionArray removeObject:@"问题知识"];
        }
        [self.tableView reloadData];

        self.tableView.tableHeaderView = self.headView;
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];
}

- (void)requestPicturePraiseWithType:(NSString *)type
{
    
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQueryPicturePraiseURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSDictionary *parameters = @{
                                 @"scope":@"all",
                                 @"user":user_uuid,
                                 @"type":type,
                                 @"pageNumber":@(0),
                                 @"pageSize":@(2)
                                 };
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    // 请求问题列表
    [httpClient queryPicturePraiseWithParameters:parameters completion:^(id response, NSError *error) {
       // [self requestQuestionList];
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *dict in dataArray) {
            PictureListModel *picList = [[PictureListModel alloc] init];
            [picList setValuesForKeysWithDictionary:dict];
            [tempArray addObject:picList];
        }
        
        if ([type isEqualToString:@"store"]) {
            _allPraiseListArray = [NSMutableArray arrayWithArray:tempArray];
            if (_allPraiseListArray.count == 0) {
                [_sectionArray removeObject:@"商场风采"];
            }
        } else if ([type isEqualToString:@"casus"]) {
            _allExcellentCaseArray = [NSMutableArray arrayWithArray:tempArray];
            if (_allExcellentCaseArray.count == 0) {
                [_sectionArray removeObject:@"优秀案例"];
            }
        } else {
            _allPatrolReportArray = [NSMutableArray arrayWithArray:tempArray];
            if (_allPatrolReportArray.count == 0) {
                [_sectionArray removeObject:@"巡店报告"];
            }
        }
        
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];
    
}


#pragma mark - Private Methods
- (void)setupNav
{
    UIEdgeInsets insets = UIEdgeInsetsMake( 0, 199, 0, 175);
    UIImage *image = [[UIImage imageNamed:@"home_title"] resizableImageWithCapInsets:insets resizingMode:UIImageResizingModeStretch];
    self.bgImageView.image = image;
    self.searchTextField.backgroundColor = [UIColor clearColor];
    self.nameLabel.backgroundColor = [UIColor clearColor];
    _nameLabel.text = [NSString stringWithFormat:@"%@，你好!", [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"]];
    self.shopnameLabel.backgroundColor = [UIColor clearColor];
    _shopnameLabel.text = [NSString stringWithFormat:@"%@", [[NSUserDefaults standardUserDefaults] objectForKey:@"org_name"]];

}

- (void)setupTableView
{
    self.headView = [[HomeHeaderView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 115)];
    
    self.headView.scrollView.contentSize = CGSizeMake(2 * kScreenWidth, 86);
    CGFloat itemW = kScreenWidth / 4;
    CGFloat itemH = self.headView.scrollView.frame.size.height;

    for (int i = 0; i < _titleArray.count; i++) {
        HomeCellItem *item = [[HomeCellItem alloc] init];
        item.frame = CGRectMake(i * itemW, 0, itemW, itemH);
        NSString *nameStr = _titleArray[i];
        UIImage *image = [UIImage imageNamed:[NSString stringWithFormat:@"%@", nameStr]];
        [item setImage:image forState:UIControlStateNormal];
        [item setTitleColor:kPictureCellDetailsColor forState:UIControlStateNormal];
        [item setTitle:nameStr forState:UIControlStateNormal];
        [item addTarget:self action:@selector(itemClick:) forControlEvents:UIControlEventTouchUpInside];
        [self.headView.scrollView addSubview:item];
    }
    
    self.tableView.tableHeaderView = self.headView;
    
    // 设置下拉刷新
    self.tableView.header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        // 进入刷新状态后会自动调用这个block
        [self refreshAllData];
        
    }];
    [self.tableView reloadData];

}

// 更多按钮点击事件
- (void)moreButtonClick:(UIButton *)sender
{
    NSInteger section = sender.tag - 332892;
    UINavigationController *nav;
    if ([_sectionArray[section] isEqualToString:@"在线抽查"]) {
        SpotCheckOnLineViewController *spotOnline = [[SpotCheckOnLineViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:spotOnline];
    } else if ([_sectionArray[section] isEqualToString:@"口碑巡检"]) {
        InspectListViewController *inspectListVC = [[InspectListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:inspectListVC];
    } else if ([_sectionArray[section] isEqualToString:@"口碑标准"]) {
        StandardViewController *standardVC = [[StandardViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:standardVC];
    } else if ([_sectionArray[section] isEqualToString:@"图说口碑"]) {
        PicCategoryViewController *pictureVC = [[PicCategoryViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:pictureVC];
    } else if ([_sectionArray[section] isEqualToString:@"问题知识"]) {
        QuestionViewController *questionVC = [[QuestionViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:questionVC];
    } else if ([_sectionArray[section] isEqualToString:@"口碑报告"]){
        RankingListViewController *rankingListVC = [[RankingListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:rankingListVC];
    } else if ([_sectionArray[section] isEqualToString:@"查看抽查"]){
        LookOnLineViewController *lookOnLine = [[LookOnLineViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:lookOnLine];
    } else if ([_sectionArray[section] isEqualToString:@"商场风采"]) {
        PictureViewController *pic = [[PictureViewController alloc] init];
        pic.come = @"首页";
        pic.titleStr = @"商场风采";
        pic.category = @"store";
        nav = [[UINavigationController alloc] initWithRootViewController:pic];
    } else if ([_sectionArray[section] isEqualToString:@"优秀案例"]) {
        PictureViewController *pic = [[PictureViewController alloc] init];
        pic.come = @"首页";
        pic.titleStr = @"优秀案例";
        pic.category = @"casus";
        nav = [[UINavigationController alloc] initWithRootViewController:pic];
    } else if ([_sectionArray[section] isEqualToString:@"巡店报告"]) {
        PictureViewController *pic = [[PictureViewController alloc] init];
        pic.come = @"首页";
        pic.titleStr = @"巡店报告";
        pic.category = @"report";
        nav = [[UINavigationController alloc] initWithRootViewController:pic];
    }
    
    [nav.navigationBar setBarTintColor:kNavigationBarColor];
    [nav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    [self presentViewController:nav animated:YES completion:nil];
    
}

- (void)itemClick:(HomeCellItem *)sender
{
    HomeCellItem *item = (HomeCellItem *)sender;
    UINavigationController *nav;
    if ([item.titleLabel.text isEqualToString:@"在线抽查"]) {
        SpotCheckOnLineViewController *spotOnline = [[SpotCheckOnLineViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:spotOnline];
    } else if ([item.titleLabel.text isEqualToString:@"口碑巡检"]) {
        InspectListViewController *inspectListVC = [[InspectListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:inspectListVC];
    } else if ([item.titleLabel.text isEqualToString:@"口碑标准"]) {
        StandardViewController *standardVC = [[StandardViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:standardVC];
    } else if ([item.titleLabel.text isEqualToString:@"图说口碑"]) {
        PicCategoryViewController *pictureVC = [[PicCategoryViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:pictureVC];
    } else if ([item.titleLabel.text isEqualToString:@"问题知识"]) {
        QuestionViewController *questionVC = [[QuestionViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:questionVC];
    } else if ([item.titleLabel.text isEqualToString:@"口碑报告"]){
        RankingListViewController *rankingListVC = [[RankingListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:rankingListVC];
    } else if ([item.titleLabel.text isEqualToString:@"查看抽查"]){
        LookOnLineViewController *lookOnLine = [[LookOnLineViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:lookOnLine];
    } else if ([item.titleLabel.text isEqualToString:@"商场风采"]) {
        PictureViewController *pic = [[PictureViewController alloc] init];
        pic.come = @"首页";
        pic.category = @"store";
        pic.titleStr = @"商场风采";
        nav = [[UINavigationController alloc] initWithRootViewController:pic];
    }
    
    [nav.navigationBar setBarTintColor:kNavigationBarColor];
    [nav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    [self presentViewController:nav animated:YES completion:nil];
}




#pragma mark - TableView Delegate/DataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return _sectionArray.count;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSUInteger s2 = [_sectionArray indexOfObject:@"口碑报告"];
    NSUInteger s4 = [_sectionArray indexOfObject:@"商场风采"];
    NSUInteger s3 = [_sectionArray indexOfObject:@"问题知识"];
    NSUInteger s1 = [_sectionArray indexOfObject:@"口碑巡检"];
    NSUInteger s5 = [_sectionArray indexOfObject:@"优秀案例"];
    NSUInteger s6 = [_sectionArray indexOfObject:@"巡店报告"];

    
    if ([_sectionArray[section] isEqualToString:@"口碑巡检"] && section == s1) {
        return _taskListDataArray.count;
    } else if ([_sectionArray[section] isEqualToString:@"口碑报告"] && section == s2) {
        return _allRankListArray.count + 1;
    } else if ([_sectionArray[section] isEqualToString:@"问题知识"] && section == s3) {
        return _allQuestionArray.count;
    } else if ([_sectionArray[section] isEqualToString:@"商场风采"] && section == s4) {
        return _allPraiseListArray.count;
    } else if ([_sectionArray[section] isEqualToString:@"优秀案例"] && section == s5) {
        return _allExcellentCaseArray.count;
    } else if ([_sectionArray[section] isEqualToString:@"巡店报告"] && section == s6) {
        return _allPatrolReportArray.count;
    } else {
        return 0;
    }
}


// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSUInteger s2 = [_sectionArray indexOfObject:@"口碑报告"];
    NSUInteger s4 = [_sectionArray indexOfObject:@"商场风采"];
    NSUInteger s3 = [_sectionArray indexOfObject:@"问题知识"];
    NSUInteger s1 = [_sectionArray indexOfObject:@"口碑巡检"];
    NSUInteger s5 = [_sectionArray indexOfObject:@"优秀案例"];
    NSUInteger s6 = [_sectionArray indexOfObject:@"巡店报告"];

    if ([_sectionArray[indexPath.section] isEqualToString:@"口碑巡检"] && indexPath.section == s1) {
        InspectListCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeInspectListCell];
        if (!cell) {
            cell = [[InspectListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeInspectListCell];
        }
        TaskListModel *taskList = _taskListDataArray[indexPath.row];
        cell.taskList = taskList;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.allView.backgroundColor = kProgressViewAllBackColor;
        UIImage *image = [UIImage imageNamed:@"progress-bar"];
        image = [image resizableImageWithCapInsets:UIEdgeInsetsZero resizingMode:UIImageResizingModeTile];
        cell.alreadyView.image = image;
        return cell;
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑报告"] && indexPath.section == s2) {
        if (indexPath.row == 0) {
            HomeTitleTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeTitleTableCell];
            if (!cell) {
                cell = [[HomeTitleTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeTitleTableCell];
            }
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            return cell;
        } else {
            RankingListCell *cell = [tableView dequeueReusableCellWithIdentifier:kHomeRankingListCell];
            if (!cell) {
                cell = [[RankingListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeRankingListCell];
            }
            for (int i = 0 ; i < _allRankListArray.count; i++) {
                RankListModel *rank = _allRankListArray[i];
                if (i == 0) {
                    rank.index = i + 1;
                } else {
                    RankListModel *prevRank = _allRankListArray[i-1];
                    rank.index = rank.score == prevRank.score ? prevRank.index: i + 1;
                }
            }
            RankListModel *rankList = _allRankListArray[indexPath.row - 1];
            cell.rankList = rankList;
            cell.gradeImageView.image = [UIImage imageNamed:[NSString stringWithFormat:@"medal_0%d", rankList.index]];
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            return cell;
        }
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"问题知识"] && indexPath.section == s3) {
        // 问题与知识
        QuestionListTableCell *cell = [tableView dequeueReusableCellWithIdentifier:kHomeQuestionListTableCell];
        if (!cell) {
            cell = [[QuestionListTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeQuestionListTableCell];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        QuestionModel *question = _allQuestionArray[indexPath.row];
        cell.question = question;
        return cell;
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"商场风采"] && indexPath.section == s4) {
        PictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:KHomePicTableCell];
        if (!cell) {
            cell = [[PictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:KHomePicTableCell];
        }
        cell.pictureList = _allPraiseListArray[indexPath.row];
        return cell;
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"优秀案例"] && indexPath.section == s5) {
        PictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:KHomePicTableCell];
        if (!cell) {
            cell = [[PictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:KHomePicTableCell];
        }
        cell.pictureList = _allExcellentCaseArray[indexPath.row];
        return cell;
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"巡店报告"] && indexPath.section == s6) {
        PictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:KHomePicTableCell];
        if (!cell) {
            cell = [[PictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:KHomePicTableCell];
        }
        cell.pictureList = _allPatrolReportArray[indexPath.row];
        return cell;
    } else {
        return nil;
    }
    
    

    
}

// cell点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSUInteger s2 = [_sectionArray indexOfObject:@"口碑报告"];
    NSUInteger s4 = [_sectionArray indexOfObject:@"商场风采"];
    NSUInteger s3 = [_sectionArray indexOfObject:@"问题知识"];
    NSUInteger s1 = [_sectionArray indexOfObject:@"口碑巡检"];
    NSUInteger s5 = [_sectionArray indexOfObject:@"优秀案例"];
    NSUInteger s6 = [_sectionArray indexOfObject:@"巡店报告"];
    if ([_sectionArray[indexPath.section] isEqualToString:@"口碑巡检"] && indexPath.section == s1) {
        InspectTaskViewController *inspectTaskVC = [[InspectTaskViewController alloc] init];
        TaskListModel *taskList = self.taskListDataArray[indexPath.row];
        inspectTaskVC.uuid = taskList.uuid;
        inspectTaskVC.store_uuid = taskList.store_uuid;
        inspectTaskVC.multiplier = (CGFloat)taskList.reportCount / taskList.questionCount ;
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:inspectTaskVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑报告"] && indexPath.section == s2) {
        if (indexPath.row == 0) {
            return;
        }
        RankListModel *rankList = _allRankListArray[indexPath.row - 1];
        RankDetailViewController *rankDetailVC = [[RankDetailViewController alloc] init];
        rankDetailVC.indexRow = rankList.index;
        rankDetailVC.uuid = rankList.uuid;
        rankDetailVC.store_uuid = rankList.store_uuid;
        rankDetailVC.storeAddress = rankList.storeAddress;
        rankDetailVC.storePictures = rankList.storePictures;
        rankDetailVC.commentId = rankList.commentId;
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:rankDetailVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"问题知识"] && indexPath.section == s3) {
        QuestionDetailViewController *questionDetailVC = [[QuestionDetailViewController alloc] init];
        QuestionModel *question = self.allQuestionArray[indexPath.row];
        questionDetailVC.questionUuid = question.uuid;
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:questionDetailVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"商场风采"] && indexPath.section == s4) {
        PictureListModel *picList = _allPraiseListArray[indexPath.row];
        PictureStoryViewController *storyVC = [[PictureStoryViewController alloc] init];
        storyVC.uuid = picList.uuid;
        storyVC.titleStr = @"商场风采";
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:storyVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"优秀案例"] && indexPath.section == s5) {
        PictureListModel *picList = _allExcellentCaseArray[indexPath.row];
        PictureStoryViewController *storyVC = [[PictureStoryViewController alloc] init];
        storyVC.uuid = picList.uuid;
        storyVC.titleStr = @"优秀案例";
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:storyVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"巡店报告"] && indexPath.section == s6) {
        PictureListModel *picList = _allPatrolReportArray[indexPath.row];
        PictureStoryViewController *storyVC = [[PictureStoryViewController alloc] init];
        storyVC.uuid = picList.uuid;
        storyVC.titleStr = @"巡店报告";
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:storyVC animated:YES];
    } else {
        return;
    }
}


// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 36;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 10;
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    
        // 创建sectionView
        UIView *sectionView = [[UIView alloc] init];
        sectionView.userInteractionEnabled = YES;
        sectionView.backgroundColor = [UIColor whiteColor];
        
        UIView *lineView = [[UIView alloc] init];
        lineView.translatesAutoresizingMaskIntoConstraints = NO;
        lineView.backgroundColor = kSeparateLineColor;
        [sectionView addSubview:lineView];
        
        NSLayoutConstraint *lineTop = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [sectionView addConstraint:lineTop];
        
        NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [sectionView addConstraint:lineLeft];
        
        NSLayoutConstraint *lineRight = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [sectionView addConstraint:lineRight];
        
        NSLayoutConstraint *lineHeight = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:0.5];
        [sectionView addConstraint:lineHeight];
        
        // 创建标题label
        UILabel *titleLabel = [[UILabel alloc] init];
        titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        titleLabel.textColor = kPictureCellDetailsColor;
        titleLabel.font = [UIFont systemFontOfSize:17.0];

        titleLabel.text = _sectionArray[section];

    
        [sectionView addSubview:titleLabel];
        
        
        // 查看更多按钮
        UIButton *moreButton = [[UIButton alloc] init];
        moreButton.tag = 332892 + section;
        moreButton.translatesAutoresizingMaskIntoConstraints = NO;
        [moreButton setTitle:@"更多" forState:UIControlStateNormal];
        [moreButton setTitleColor:kMoreButtonTextColor forState:UIControlStateNormal];
        [moreButton addTarget:self action:@selector(moreButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        moreButton.titleLabel.font = [UIFont systemFontOfSize:13.0];
        [sectionView addSubview:moreButton];
        
        // 箭头Iamge
        UIImageView *arrowIamgeView = [[UIImageView alloc] init];
        arrowIamgeView.image = [UIImage imageNamed:@"arrow_right"];
        arrowIamgeView.translatesAutoresizingMaskIntoConstraints = NO;
        [sectionView addSubview:arrowIamgeView];
        
        NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:3];
        [sectionView addConstraint:titleLabelTop];
        
        NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [sectionView addConstraint:titleLabelLeft];
        
        NSLayoutConstraint *titleLabelRight = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:moreButton attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [sectionView addConstraint:titleLabelRight];
        
        NSLayoutConstraint *titleLabelBottom = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [sectionView addConstraint:titleLabelBottom];
        
    
        
        
        // moreButton布局
        NSLayoutConstraint *moreButtonTop = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:3];
        [sectionView addConstraint:moreButtonTop];
        
        NSLayoutConstraint *moreButtonRight = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:arrowIamgeView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [sectionView addConstraint:moreButtonRight];
        
        NSLayoutConstraint *moreButtonWidth = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
        [sectionView addConstraint:moreButtonWidth];
        
        NSLayoutConstraint *moreButtonBottom = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [sectionView addConstraint:moreButtonBottom];
        
        // arrowIamgeView布局
        NSLayoutConstraint *arrowIamgeViewTop = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:13];
        [sectionView addConstraint:arrowIamgeViewTop];
        
        NSLayoutConstraint *arrowIamgeViewRight = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [sectionView addConstraint:arrowIamgeViewRight];
        
        NSLayoutConstraint *arrowIamgeViewWidth = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:7];
        [sectionView addConstraint:arrowIamgeViewWidth];
        
        NSLayoutConstraint *arrowIamgeViewHeight = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:12];
        [sectionView addConstraint:arrowIamgeViewHeight];
        
        
        return sectionView;
}



#pragma mark - lazy loading
- (UIImageView *)bgImageView
{
    if (!_bgImageView) {
        _bgImageView = [[UIImageView alloc] init];
        _bgImageView.translatesAutoresizingMaskIntoConstraints = NO;
        _bgImageView.userInteractionEnabled = YES;
        [self.view addSubview:_bgImageView];
        
        NSLayoutConstraint *bgImageTop = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:bgImageTop];
        
        NSLayoutConstraint *bgImageLeft = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:bgImageLeft];
        
        NSLayoutConstraint *bgImageHeight = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:95];
        [self.view addConstraint:bgImageHeight];
        
        NSLayoutConstraint *bgImageRight = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:bgImageRight];
    }
    return _bgImageView;
}

- (UITextField *)searchTextField
{
    if (!_searchTextField) {
        _searchTextField = [[UITextField alloc] init];
        _searchTextField.translatesAutoresizingMaskIntoConstraints = NO;
        _searchTextField.font = [UIFont systemFontOfSize:13.0];
        _searchTextField.textAlignment = NSTextAlignmentCenter;
        _searchTextField.layer.cornerRadius = 4.0;
        _searchTextField.textColor = [UIColor whiteColor];
        _searchTextField.layer.borderColor = [[UIColor whiteColor] CGColor];
        _searchTextField.layer.borderWidth = 0.5;
        _searchTextField.placeholder = @"查询";
        _searchTextField.delegate = self;
        [_searchTextField setValue:[UIColor whiteColor] forKeyPath:@"_placeholderLabel.textColor"];
        UIButton *imageV = [[UIButton alloc] init];
        imageV.frame = CGRectMake(0, 0, 28, 28);
        [imageV setImage:[UIImage imageNamed:@"search"] forState:UIControlStateNormal];
        [imageV addTarget:self action:@selector(searchClick:) forControlEvents:UIControlEventTouchUpInside];
        imageV.contentMode = UIViewContentModeCenter;
        imageV.width += 10;
        _searchTextField.rightView = imageV;
        _searchTextField.rightViewMode = UITextFieldViewModeAlways;
        [self.bgImageView addSubview:_searchTextField];
        
        NSLayoutConstraint *bgImageTop = [NSLayoutConstraint constraintWithItem:_searchTextField attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeTop multiplier:1.0 constant:35];
        [self.bgImageView addConstraint:bgImageTop];
        
        NSLayoutConstraint *bgImageRight = [NSLayoutConstraint constraintWithItem:_searchTextField attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.bgImageView addConstraint:bgImageRight];
        
        NSLayoutConstraint *bgImageHeight = [NSLayoutConstraint constraintWithItem:_searchTextField attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:28];
        [self.bgImageView addConstraint:bgImageHeight];
        
        NSLayoutConstraint *bgImageWidth = [NSLayoutConstraint constraintWithItem:_searchTextField attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:100];
        [self.bgImageView addConstraint:bgImageWidth];
    }
    return _searchTextField;
}

- (UILabel *)nameLabel
{
    if (!_nameLabel) {
        _nameLabel = [[UILabel alloc] init];
        _nameLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _nameLabel.font = [UIFont systemFontOfSize:13.0];
        _nameLabel.textAlignment = NSTextAlignmentRight;
        _nameLabel.textColor = [UIColor whiteColor];
        [self.bgImageView addSubview:_nameLabel];
        
        NSLayoutConstraint *bgImageTop = [NSLayoutConstraint constraintWithItem:_nameLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.searchTextField attribute:NSLayoutAttributeBottom multiplier:1.0 constant:3];
        [self.bgImageView addConstraint:bgImageTop];
        
        NSLayoutConstraint *bgImageRight = [NSLayoutConstraint constraintWithItem:_nameLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.bgImageView addConstraint:bgImageRight];
        
        NSLayoutConstraint *bgImageBottom = [NSLayoutConstraint constraintWithItem:_nameLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.bgImageView addConstraint:bgImageBottom];
        
        NSLayoutConstraint *bgImageWidth = [NSLayoutConstraint constraintWithItem:_nameLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:110];
        [self.bgImageView addConstraint:bgImageWidth];
    }
    return _nameLabel;
}

- (UILabel *)shopnameLabel
{
    if (!_shopnameLabel) {
        _shopnameLabel = [[UILabel alloc] init];
        _shopnameLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _shopnameLabel.font = [UIFont systemFontOfSize:13.0];
        _shopnameLabel.textAlignment = NSTextAlignmentRight;
        _shopnameLabel.textColor = [UIColor whiteColor];
        [self.bgImageView addSubview:_shopnameLabel];
        
        NSLayoutConstraint *bgImageTop = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.searchTextField attribute:NSLayoutAttributeBottom multiplier:1.0 constant:3];
        [self.bgImageView addConstraint:bgImageTop];
        
        NSLayoutConstraint *bgImageRight = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.nameLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-10];
        [self.bgImageView addConstraint:bgImageRight];
        
        NSLayoutConstraint *bgImageBottom = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.bgImageView addConstraint:bgImageBottom];
        
        NSLayoutConstraint *bgImageLeft = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.bgImageView addConstraint:bgImageLeft];
    }
    return _shopnameLabel;
}


- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 300.0;
        _tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 40)];
        [_tableView registerClass:[PictureTableCell class] forCellReuseIdentifier:kHomePictureListCell];
        [_tableView registerClass:[HomeTitleTableCell class] forCellReuseIdentifier:kHomeTitleTableCell];
        [_tableView registerClass:[RankingListCell class] forCellReuseIdentifier:kHomeRankingListCell];
        [_tableView registerClass:[QuestionListTableCell class] forCellReuseIdentifier:kHomeQuestionListTableCell];

        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:95];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}


- (void)searchClick:(UIButton *)sender
{
    if (![_searchTextField.text isEqualToString:@""]) {
        SearchViewController *searchVC = [[SearchViewController alloc] init];
        searchVC.customStr = _searchTextField.text;
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:searchVC animated:YES];
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"请输入关键字！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
    [_searchTextField resignFirstResponder];
}

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    if ([textField resignFirstResponder]) {
        return YES;
    }
    return NO;
}

- (void)clickHeadView
{
    [_tableView reloadData];
}

-(void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

@end
