//
//  RankDetailViewController.m
//  redstar
//
//  Created by admin on 15/10/29.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankDetailViewController.h"
#import "RankDetailTableCell.h"
#import "RankSectionTableCell.h"
#import "RankScrollTableViewCell.h"
#import "RankDetailHeaderView.h"
#import <UIButton+WebCache.h>
#import "RankHeadView.h"
#import <MBProgressHUD.h>
#import "HttpClient.h"

#import "TaskGroup.h"
#import "TaskModel.h"
#import "TaskDetailModel.h"
#import "CheckPicViewController.h"
#import "CommentView.h"

#import <UIButton+WebCache.h>
#import <RATreeView.h>

#define kRankDetailCell @"RankDetailTableCell"
#define kRankSectionTableCell @"RankSectionTableviewCell"
#define kRankScrollTableViewCell @"RankScrollTableViewCell"

@interface RankDetailViewController () <RATreeViewDelegate, RATreeViewDataSource, UITextViewDelegate>
@property (nonatomic, strong) RATreeView *treeView;


@property (nonatomic, strong) NSMutableArray *taskData;
@property (nonatomic, strong) RankDetailHeaderView *rankDetailHeaderView;
@property (nonatomic, strong) UIView *footerView;
@property (nonatomic, strong) UIButton *commentButton;
@property (nonatomic, strong) UIView *backGroundView;
@property (nonatomic, strong) CommentView *commentView;

@end

@implementation RankDetailViewController
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.hidden = NO;
    self.tabBarController.tabBar.hidden = YES;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"口碑详情"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;

    [self.commentButton setTitle:@"添加评论" forState:UIControlStateNormal];
    // 请求口碑排名详情
    [self requestRankingDetail];
    
}


#pragma mark - Private Methods

- (void)requestRankingDetail
{
    NSString *url = [NSString stringWithFormat:@"%@%@%@/%@",kRedStarURL, kInspectDetailURL, self.uuid, self.store_uuid];
    NSLog(@"url = %@" , url);
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
    
    [httpClient getPraiseDetailWithParameters:nil completion:^(id response, NSError *error) {
        NSLog(@"口碑巡检明细PraiseDetail = %@", response);
        NSDictionary *dataDict = response[@"data"];
        TaskDetailModel *taskDetail = [TaskDetailModel taskDetailModelWithDict:dataDict];
        self.rankDetailHeaderView.taskDetail = taskDetail;
        [self.rankDetailHeaderView.showAllBtn addTarget:self action:@selector(showAllClick:) forControlEvents:UIControlEventTouchUpInside];
        [self setupScrollView];

        NSArray *dataArray = taskDetail.categories;
        
        NSMutableArray *tgArray = [NSMutableArray array];
        for (NSDictionary *dict in dataArray) {
            TaskGroup *taskGroup = [TaskGroup taskGroupWithDict:dict];
            
            for (int a = 0; a < taskGroup.answers.count; a++) {
                TaskModel *task = taskGroup.answers[a];
                task.index = a;
            }
            
            [tgArray addObject:taskGroup];
        }
        
        _taskData = tgArray;
        
        [self.treeView registerClass:[RankSectionTableCell class] forCellReuseIdentifier:kRankSectionTableCell];
        [self.treeView registerClass:[RankDetailTableCell class] forCellReuseIdentifier:kRankDetailCell];
         [self.treeView registerClass:[RankScrollTableViewCell class] forCellReuseIdentifier:kRankScrollTableViewCell];
    }];

}

- (void)setupScrollView
{
    int imageCount = (int)self.storePictures.count;
    
    CGFloat marginW = 5.0;
    CGFloat imageViewW = 90 + 2 * marginW;
    CGFloat imageViewH = self.rankDetailHeaderView.rankDetailView.showScrollView.bounds.size.height - 4;
    
    if (imageCount == 0) {
        self.rankDetailHeaderView.rankDetailView.showScrollView.contentSize = CGSizeMake(4 *imageViewW, imageViewH + 4);
        
        for (int i = 0; i < 4; i++) {
            UIButton *button = [[UIButton alloc] init];
            [button setImage:[UIImage imageNamed:@"default_pic"] forState:UIControlStateNormal];
            button.frame = CGRectMake(i * imageViewW + 2, 2, imageViewW - 2 * marginW, imageViewH);
            [button addTarget:self action:@selector(showBigPic:) forControlEvents:UIControlEventTouchUpInside];
            [self.rankDetailHeaderView.rankDetailView.showScrollView addSubview:button];
        }
    } else {
        self.rankDetailHeaderView.rankDetailView.showScrollView.contentSize = CGSizeMake(imageCount *imageViewW, imageViewH + 4);
        
        for (int i = 0; i < imageCount; i++) {
            UIButton *button = [[UIButton alloc] init];
            NSDictionary *dict = (NSDictionary *)self.storePictures[i];
            NSURL *imageUrl = [NSURL URLWithString:[NSString stringWithFormat:@"%@%@", kRedStarURL ,dict[@"fileUrl"]]];
            [button sd_setImageWithURL:imageUrl forState:UIControlStateNormal placeholderImage:[UIImage imageNamed:@"default_pic"]];
            button.frame = CGRectMake(i * imageViewW + 2, 2, imageViewW - 2 * marginW, imageViewH);
            [button addTarget:self action:@selector(showBigPic:) forControlEvents:UIControlEventTouchUpInside];
            [self.rankDetailHeaderView.rankDetailView.showScrollView addSubview:button];
        }
        
    }
}

- (void)showBigPic:(UIButton *)btn
{
    CheckPicViewController *checkVC = [[CheckPicViewController alloc] init];
    checkVC.checkImage = btn.imageView.image;
    [self.navigationController pushViewController:checkVC animated:YES];
}

// 返回上一页面
- (void)doBack:(UIBarButtonItem *)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)addComment:(UIButton *)sender
{
    NSArray *permissions = [[NSUserDefaults standardUserDefaults] objectForKey:@"permissions"];
    
    // 口碑报告 商场风采 图说口碑 口碑标准  问题知识 口碑巡检
    
    if ([permissions containsObject:@"500202"]) {
        
        if (!_backGroundView) {
            _backGroundView = [[UIView alloc] initWithFrame:self.view.bounds];
            UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeBackGroundView)];
            [_backGroundView addGestureRecognizer:tapGR];
        }
        if (!_commentView) {
            _commentView = [[CommentView alloc] init];
            _commentView.backgroundColor = [UIColor whiteColor];
        }
        _commentView.contentTextView.text = @"";
        _commentView.contentTextView.delegate = self;
        [_commentView.quitBtn addTarget:self action:@selector(closeBackGroundView) forControlEvents:UIControlEventTouchUpInside];
        [_commentView.sureBtn addTarget:self action:@selector(submitComment:) forControlEvents:UIControlEventTouchUpInside];
        [self.view insertSubview:_backGroundView aboveSubview:_treeView];
        [self.view insertSubview:_commentView aboveSubview:_backGroundView];
        
        _backGroundView.alpha = 0;
        _backGroundView.backgroundColor = [UIColor blackColor];
        
        CGRect toFrame = CGRectMake(0, self.view.frame.size.height - kCommentViewHeight, kScreenWidth, kCommentViewHeight);
        CGRect fromFrame = CGRectMake(0, kScreenHeight, kScreenWidth, kCommentViewHeight);
        
        _commentView.frame = fromFrame;
        [UIView animateWithDuration:0.3 animations:^{
            _backGroundView.alpha = 0.6;
            _commentView.frame = toFrame;
        }];

    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您没有口碑报告的评论权限！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
}

// 提交评论
- (void)submitComment:(UIButton *)sender
{
    // 提示框
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您确定要提交评论吗？" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确定", nil];
    alert.tag = 3652234;
    alert.delegate = self;
    [alert show];
}

- (void)closeBackGroundView
{
    CGRect fromFrame = CGRectMake(0, kScreenHeight, kScreenWidth, kCommentViewHeight);
    [UIView animateWithDuration:0.3 animations:^{
        _backGroundView.alpha = .0f;
        _commentView.frame = fromFrame;
    } completion:^(BOOL finished) {
        [_backGroundView removeFromSuperview];
        [_commentView removeFromSuperview];
    }];
}

- (void)showAllClick:(UIButton *)sender
{
    sender.selected = !sender.selected;
    if (sender.selected) {
        _rankDetailHeaderView.arrowImageView2.transform = CGAffineTransformMakeRotation(-M_PI);

        
        _treeView.expandsChildRowsWhenRowExpands = YES;
        
        for (TaskGroup *taskGroup in self.taskData) {
            [_treeView expandRowForItem:taskGroup expandChildren:YES withRowAnimation:RATreeViewRowAnimationFade];
        }
    } else {
        _rankDetailHeaderView.arrowImageView2.transform = CGAffineTransformMakeRotation(0);

        _treeView.expandsChildRowsWhenRowExpands = NO;
        
        for (TaskGroup *taskGroup in self.taskData) {
            [_treeView collapseRowForItem:taskGroup collapseChildren:YES withRowAnimation:RATreeViewRowAnimationFade];
        }
    }
    
    
    
    
}

#pragma mark - RAtreeView Delegate/DataSource
- (NSInteger)treeView:(RATreeView *)treeView numberOfChildrenOfItem:(id)item
{
    NSInteger level = [treeView levelForCellForItem:item];
    if (level == -1) {
        return [self.taskData count];
    } else if (level == 0) {
        TaskGroup *data = item;
        return data.answers.count;
    } else if (level == 1) {
        TaskModel *data = item;
        if (data.answerAttachments.count == 0) {
            return 0;
        } else {
            return 1;
        }
       // return 0;
        
    } else {
        return 0;
    }
}


- (id)treeView:(RATreeView *)treeView child:(NSInteger)index ofItem:(id)item
{
    NSInteger level = [treeView levelForCellForItem:item];
    if (level == -1) {
        return [self.taskData objectAtIndex:index];
    } else if (level == 0) {
        TaskGroup *data = item;
        return data.answers[index];
    } else if (level == 1) {
        TaskModel *data = item;
        if (data.answerAttachments.count == 0) {
            return nil;
        } else {
            return data.answerAttachments;
        }
    } else {
        return nil;
    }
}

- (UITableViewCell *)treeView:(RATreeView *)treeView cellForItem:(id)item
{
    NSInteger level = [self.treeView levelForCellForItem:item];
    
    if (level == 0) {
        TaskGroup *data = item;
        RankSectionTableCell *cell = [self.treeView dequeueReusableCellWithIdentifier:kRankSectionTableCell];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        
        cell.categoryLabel.text = [NSString stringWithFormat:@"%@", data.category];
        
        NSString *scoreStr = [NSString stringWithFormat:@"%@ 分", data.score];
        NSMutableAttributedString *scoreAttr = [[NSMutableAttributedString alloc] initWithString:scoreStr];
        [scoreAttr addAttributes:@{NSForegroundColorAttributeName:kNavigationBarColor,NSFontAttributeName:[UIFont systemFontOfSize:19.0f]} range:NSMakeRange(0,scoreAttr.length - 1)];
        [scoreAttr addAttributes:@{NSForegroundColorAttributeName:kDetailSmallTitleColor, NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(scoreAttr.length - 1,1)];
        [cell.scoreLabel setAttributedText:scoreAttr];
        
        NSString *rankStr = [NSString stringWithFormat:@"第 %@ 名", data.ranking];
        NSMutableAttributedString *rankAttr = [[NSMutableAttributedString alloc] initWithString:rankStr];
        [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,1)];
        [rankAttr addAttributes:@{NSForegroundColorAttributeName:kGradeNumberTextColor} range:NSMakeRange(1,rankStr.length - 2)];
        [rankAttr addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"Arial-BoldMT" size:18.0] range:NSMakeRange(1,rankStr.length - 2)];
        [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(rankStr.length - 1,1)];
        [cell.gradeLabel setAttributedText:rankAttr];
        
        cell.arrowImageView.image = [UIImage imageNamed:@"arrow_down"];
        
        return cell;
    } else if (level == 1) {// if (level == 1)
        TaskModel *data = item;
        
        RankDetailTableCell *cell = [self.treeView dequeueReusableCellWithIdentifier:kRankDetailCell];
        if (!cell) {
            cell = [[RankDetailTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kRankDetailCell];
        }
        
        cell.task = data;
        
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        
        [cell.mainTitleBtn setTitle:[NSString stringWithFormat:@"%d、%@", (int)(data.index + 1) ,data.title] forState:UIControlStateNormal];
        if (data.score == NULL || data.score == nil || [data.score isEqual:[NSNull null]]) {
            cell.scoreLabel.text = [NSString stringWithFormat:@"0分"];
        } else {
            cell.scoreLabel.text = [NSString stringWithFormat:@"%@分", data.score];
        }
        
        return cell;
        
    } else {
        NSArray *data = item;
        RankScrollTableViewCell *cell = [self.treeView dequeueReusableCellWithIdentifier:kRankScrollTableViewCell];
        if (!cell) {
            cell = [[RankScrollTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kRankScrollTableViewCell];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        
        
        NSMutableArray *urlArray = [NSMutableArray array];
        for (NSDictionary *imageUrlDict in data) {
            NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, imageUrlDict[@"fileUrl"]];
            [urlArray addObject:urlStr];
        }
        
        CGFloat marginW = 5.0;
        CGFloat imageViewW = 90 + 2 * marginW;
        cell.scrollView.contentSize = CGSizeMake((urlArray.count - 1) * imageViewW, 65);
        
        for (int i = 0; i < urlArray.count; i++) {
            UIButton *button = [[UIButton alloc] init];
            button.translatesAutoresizingMaskIntoConstraints = NO;
            NSString *urlStr = [NSString stringWithFormat:@"%@", urlArray[i]];
            NSURL *url = [NSURL URLWithString:urlStr];
            [button sd_setImageWithURL:url forState:UIControlStateNormal placeholderImage:[UIImage imageNamed:@"default_pic"]];
            [button addTarget:self action:@selector(showBigPic:) forControlEvents:UIControlEventTouchUpInside];
            [cell.scrollView addSubview:button];
            
            
            NSLayoutConstraint *urlTop = [NSLayoutConstraint constraintWithItem:button attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:cell.scrollView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
            [cell.scrollView addConstraint:urlTop];
            
            NSLayoutConstraint *urlLeft = [NSLayoutConstraint constraintWithItem:button attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:cell.scrollView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:i * imageViewW];
            [cell.scrollView addConstraint:urlLeft];
            
            NSLayoutConstraint *urlWidth = [NSLayoutConstraint constraintWithItem:button attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:imageViewW];
            [cell.scrollView  addConstraint:urlWidth];
            
            NSLayoutConstraint *urlHeight = [NSLayoutConstraint constraintWithItem:button attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
            [cell.scrollView addConstraint:urlHeight];
        }
        return cell;
    }
    
    
    
    
    
    
}

- (void)treeView:(RATreeView *)treeView willExpandRowForItem:(id)item
{
    NSInteger level = [self.treeView levelForCellForItem:item];
    if (level == 0) {
        RankSectionTableCell *cell = (RankSectionTableCell *)[_treeView cellForItem:item];
        [UIView animateWithDuration:0.2 animations:^{
            cell.arrowImageView.transform = CGAffineTransformIdentity;
            cell.arrowImageView.transform = CGAffineTransformMakeRotation(-M_PI);
        }];
    } else if (level == 1) {
        RankDetailTableCell *cell = (RankDetailTableCell *)[_treeView cellForItem:item];
        [UIView animateWithDuration:0.2 animations:^{
            cell.arrowImageView.transform = CGAffineTransformIdentity;
            cell.arrowImageView.transform = CGAffineTransformMakeRotation(M_PI / 2);
        }];
    }
}

- (void)treeView:(RATreeView *)treeView willCollapseRowForItem:(id)item
{
    NSInteger level = [self.treeView levelForCellForItem:item];
    if (level == 0) {
        RankSectionTableCell *cell = (RankSectionTableCell *)[_treeView cellForItem:item];
        [UIView animateWithDuration:0.2 animations:^{
            cell.arrowImageView.transform = CGAffineTransformIdentity;
            cell.arrowImageView.transform = CGAffineTransformMakeRotation(0);
        }];
    } else if (level == 1) {
        RankDetailTableCell *cell = (RankDetailTableCell *)[_treeView cellForItem:item];
        [UIView animateWithDuration:0.2 animations:^{
            cell.arrowImageView.transform = CGAffineTransformIdentity;
            cell.arrowImageView.transform = CGAffineTransformMakeRotation(-0);
        }];
    }
}


- (BOOL)treeView:(RATreeView *)treeView canEditRowForItem:(id)item
{
    return NO;
}

#pragma mark - UItextDelegate
- (void)textViewDidBeginEditing:(UITextView *)textView
{
    [UIView animateWithDuration:0.3 animations:^{
        _commentView.frame = CGRectMake(0, self.view.frame.size.height - kCommentViewHeight - 173, kScreenWidth, kCommentViewHeight);
    }];
}

- (void)textViewDidEndEditing:(UITextView *)textView
{
    [UIView animateWithDuration:0.3 animations:^{
        _commentView.frame = CGRectMake(0, self.view.frame.size.height - kCommentViewHeight, kScreenWidth, kCommentViewHeight);
    }];
}

- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{
    
    if (![text isEqualToString:@""]) {
        _commentView.placeholderLabel2.hidden = YES;
    }
    
    if ([text isEqualToString:@""] && range.location == 0 && range.length == 1) {
        _commentView.placeholderLabel2.hidden = NO;
    }
    
    if ([text isEqualToString:@"\n"]) {
        [_commentView.contentTextView resignFirstResponder];
        if (textView.text.length != 0) {
            _commentView.placeholderLabel2.hidden = YES;
        } else {
            _commentView.placeholderLabel2.hidden = NO;
        }
        return NO;
    }
    
    if (range.location>=200) {
        return  NO;
    }
    else {
        return YES;
    }
    
    return YES;
}

#pragma mark - UIAlertViewDelegate
-(void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (alertView.tag == 3652234) {
        if (buttonIndex == 0) {
            return;
        } else {
            // 提交数据
            NSDate *date = [NSDate date];
            NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
            [dateFormatter setDateFormat:@"YYYY-MM-dd+hh:mm:ss"];
            NSString *dateString = [dateFormatter stringFromDate:date];
            
            
            NSString *operId = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_code"];
            NSString *operName = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"];
            
            NSString *url  = [NSString stringWithFormat:@"%@%@?time=%@&operId=%@&operName=%@", kRedStarURL, kAddCommentURL , dateString , operId, operName];
            url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
            NSLog(@"url = %@", url);
            
            HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
            NSLog(@"selll = %@", self.commentId);
            NSDictionary *parameters = @{@"entityType":@"praise",
                                         @"entityUuid":self.commentId,
                                         @"comment":_commentView.contentTextView.text};
            NSLog(@"parameters = %@", parameters);
            [MBProgressHUD showHUDAddedTo:self.view animated:YES];
            [httpClient submitCommentWithParameters:parameters completion:^(id response, NSError *error) {
                NSLog(@"respo = %@, error = %@", response , error);
                if ([response[@"message"] isEqualToString:@"ok"]) {
                    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"添加评论成功" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
                    alert.delegate = self;
                    [alert show];
                    [MBProgressHUD hideHUDForView:self.view animated:YES];
                } else {
                    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"添加评论失败" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
                    [alert show];
                    [MBProgressHUD hideHUDForView:self.view animated:YES];
                }
            }];
            
            [self closeBackGroundView];        }
    }
}


#pragma mark - lazy Laoding
- (RATreeView *)treeView
{
    if (!_treeView) {
        _treeView = [[RATreeView alloc] initWithFrame:CGRectZero];
        _treeView.translatesAutoresizingMaskIntoConstraints = NO;
        _treeView.delegate = self;
        _treeView.dataSource = self;
        _treeView.showsVerticalScrollIndicator = NO;
        _treeView.showsHorizontalScrollIndicator = NO;
        _treeView.treeHeaderView = self.rankDetailHeaderView;
        _treeView.treeFooterView = self.footerView;
        _treeView.rowHeight = UITableViewAutomaticDimension;
        _treeView.estimatedRowHeight = 300.0;
        [self.view addSubview:_treeView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_treeView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_treeView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_treeView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_treeView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _treeView;
}

- (RankDetailHeaderView *)rankDetailHeaderView
{
    if (!_rankDetailHeaderView) {
        _rankDetailHeaderView = [[RankDetailHeaderView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 298)];
        if (self.indexRow <= 3) {
            NSString *imageName = [NSString stringWithFormat:@"medal_0%ld", (long)(_indexRow)];
            _rankDetailHeaderView.rankDetailView.gradeImageView.image = [UIImage imageNamed:imageName];
        } else {
            NSString *rankStr = [NSString stringWithFormat:@"第 %ld 名", (long)(_indexRow)];
            NSMutableAttributedString *rankAttr = [[NSMutableAttributedString alloc] initWithString:rankStr];
            [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,1)];
            [rankAttr addAttributes:@{NSForegroundColorAttributeName:kGradeNumberTextColor} range:NSMakeRange(1,rankStr.length - 2)];
            [rankAttr addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"Arial-BoldMT" size:18.0] range:NSMakeRange(1,rankStr.length - 2)];
            [rankAttr addAttributes:@{NSForegroundColorAttributeName:kRankHeadTitleTextColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(rankStr.length - 1,1)];
            [_rankDetailHeaderView.rankDetailView.gradeLabel setAttributedText:rankAttr];
        }
        self.rankDetailHeaderView.backgroundColor = kSectionBackGroundColor;
        if (self.storeAddress == nil || self.storeAddress == NULL || [self.storeAddress isEqual:[NSNull null]] || self.storeAddress == Nil || [self.storeAddress isEqualToString:@"(null)"]) {
            self.rankDetailHeaderView.rankDetailView.addressLabel.text = @"";
        } else {
            self.rankDetailHeaderView.rankDetailView.addressLabel.text = [NSString stringWithFormat:@"%@", self.storeAddress];

        }
        self.rankDetailHeaderView.rankDetailView.storePictures = self.storePictures;
    }
    return _rankDetailHeaderView;
}

- (UIView *)footerView
{
    if (!_footerView) {
        _footerView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 80)];
        
        UIView *lineView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 1)];
        lineView.backgroundColor = kSeparateLineColor;
        [self.footerView addSubview:lineView];
    }
    return _footerView;
}

- (UIButton *)commentButton
{
    if (!_commentButton) {
        _commentButton = [[UIButton alloc] init];
        // 设置圆角
        _commentButton.layer.cornerRadius = 5;
        _commentButton.translatesAutoresizingMaskIntoConstraints = NO;
        _commentButton.backgroundColor = kLoginButtonBackGroundColor;
        [_commentButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [_commentButton addTarget:self action:@selector(addComment:) forControlEvents:UIControlEventTouchUpInside];
        _commentButton.titleLabel.font = [UIFont systemFontOfSize:20.0];
        [self.footerView addSubview:_commentButton];
        
        // 顶端
        NSLayoutConstraint *loginTop = [NSLayoutConstraint constraintWithItem:_commentButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.footerView attribute:NSLayoutAttributeTop multiplier:1.0 constant:20];
        [self.footerView addConstraint:loginTop];
        
        // 左边
        NSLayoutConstraint *loginLeft = [NSLayoutConstraint constraintWithItem:_commentButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.footerView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.footerView addConstraint:loginLeft];
        
        // 右边
        NSLayoutConstraint *loginRight = [NSLayoutConstraint constraintWithItem:_commentButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.footerView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.footerView addConstraint:loginRight];
        
        // 高度
        NSLayoutConstraint *loginHeight = [NSLayoutConstraint constraintWithItem:_commentButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self.footerView addConstraint:loginHeight];
    }
    return _commentButton;
}

@end
