//
//  RankDetailHeaderView.m
//  redstar
//
//  Created by admin on 15/11/12.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankDetailHeaderView.h"

@interface RankDetailHeaderView ()
@property (nonatomic, strong) UIImageView *arrowImageView1;

@end

@implementation RankDetailHeaderView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}


- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup {
    
    [self.historyBtn setTitle:@"历史成绩" forState:UIControlStateNormal];
    self.arrowImageView1.image = [UIImage imageNamed:@"arrow_right"];
    
    self.rankDetailView.backgroundColor = [UIColor whiteColor];
    
    self.titleLabel.text = @"口碑七大重点工作详情";
    [self.showAllBtn setTitle:@"展开全部" forState:UIControlStateNormal];
    self.arrowImageView2.image = [UIImage imageNamed:@"unfold_btn"];
}


- (void)setTaskDetail:(TaskDetailModel *)taskDetail
{
    _taskDetail = taskDetail;
    self.shopNameLabel.text = [NSString stringWithFormat:@"%@",  taskDetail.store_name];
   // self.rankDetailView.addressLabel.text = [NSString stringWithFormat:@"%@", taskDetail.];
    self.rankDetailView.titleLabel.text = [NSString stringWithFormat:@"%@",  taskDetail.name];
    self.rankDetailView.reportTimeLabel.text = @"上报时间";
    self.rankDetailView.totalScoreLabel.text = @"总评分";
    self.rankDetailView.totalGradeLabel.text = @"总排名";
    self.rankDetailView.timeLabel.text = [NSString stringWithFormat:@"%@",  taskDetail.beginDate];
    //self.rankDetailView.scoreLabel.text = [NSString stringWithFormat:@"%@",  taskDetail.score];
    if (taskDetail.score == 0) {
        self.rankDetailView.scoreLabel.text = [NSString stringWithFormat:@"0"];
    } else {
        self.rankDetailView.scoreLabel.text = [NSString stringWithFormat:@"%.1f",taskDetail.score];
    }
}



- (UILabel *)shopNameLabel
{
    if (!_shopNameLabel) {
        _shopNameLabel = [[UILabel alloc] init];
        _shopNameLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _shopNameLabel.textColor = kDetailSection0TitleColor;
        _shopNameLabel.font = [UIFont systemFontOfSize:18.0];
        [self addSubview:_shopNameLabel];
        // label
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_shopNameLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self addConstraint:titleTop];
        
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_shopNameLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:titleLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_shopNameLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.historyBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:titleRight];
        
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_shopNameLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self addConstraint:titleHeight];
    }
    return _shopNameLabel;
}

- (UIButton *)historyBtn
{
    if (!_historyBtn) {
        _historyBtn = [[UIButton alloc] init];
        _historyBtn.titleLabel.font = [UIFont systemFontOfSize:14.0];
        _historyBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_historyBtn setTitleColor:kDetailSection1TitleColor forState:UIControlStateNormal];
        [self addSubview:_historyBtn];
        // label
        NSLayoutConstraint *historyTop = [NSLayoutConstraint constraintWithItem:_historyBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self addConstraint:historyTop];
        
        NSLayoutConstraint *historyWidth = [NSLayoutConstraint constraintWithItem:_historyBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self addConstraint:historyWidth];
        
        NSLayoutConstraint *historyRight = [NSLayoutConstraint constraintWithItem:_historyBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.arrowImageView1 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:historyRight];
        
        NSLayoutConstraint *historyHeight = [NSLayoutConstraint constraintWithItem:_historyBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self addConstraint:historyHeight];
    }
    return _historyBtn;
}

- (UIImageView *)arrowImageView1
{
    if (!_arrowImageView1) {
        _arrowImageView1 = [[UIImageView alloc] init];
        _arrowImageView1.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_arrowImageView1];
        // label
        NSLayoutConstraint *historyTop = [NSLayoutConstraint constraintWithItem:_arrowImageView1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:16];
        [self addConstraint:historyTop];
        
        NSLayoutConstraint *historyWidth = [NSLayoutConstraint constraintWithItem:_arrowImageView1 attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:7];
        [self addConstraint:historyWidth];
        
        NSLayoutConstraint *historyRight = [NSLayoutConstraint constraintWithItem:_arrowImageView1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:historyRight];
        
        NSLayoutConstraint *historyHeight = [NSLayoutConstraint constraintWithItem:_arrowImageView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:12];
        [self addConstraint:historyHeight];
    }
    return _arrowImageView1;
}

- (RankDetailView *)rankDetailView
{
    if (!_rankDetailView) {
        _rankDetailView = [[RankDetailView alloc] init];
        _rankDetailView.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_rankDetailView];
        
        // label
        NSLayoutConstraint *historyTop = [NSLayoutConstraint constraintWithItem:_rankDetailView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopNameLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:historyTop];
        
        NSLayoutConstraint *historyLeft = [NSLayoutConstraint constraintWithItem:_rankDetailView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:historyLeft];
        
        NSLayoutConstraint *historyRight = [NSLayoutConstraint constraintWithItem:_rankDetailView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:historyRight];
        
        NSLayoutConstraint *historyHeight = [NSLayoutConstraint constraintWithItem:_rankDetailView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:208];
        [self addConstraint:historyHeight];
    }
    return _rankDetailView;
}

- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.textColor = kDetailSection1TitleColor;
        _titleLabel.font = [UIFont systemFontOfSize:17.0];
        [self addSubview:_titleLabel];
        // label
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.rankDetailView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:titleTop];
        
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:titleLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.showAllBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:titleRight];
        
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self addConstraint:titleHeight];
    }
    return _titleLabel;

}

- (UIButton *)showAllBtn
{
    if (!_showAllBtn) {
        _showAllBtn = [[UIButton alloc] init];
        _showAllBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _showAllBtn.titleLabel.font = [UIFont systemFontOfSize:14.0];
        [_showAllBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        [self addSubview:_showAllBtn];
        // label
        NSLayoutConstraint *historyTop = [NSLayoutConstraint constraintWithItem:_showAllBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.rankDetailView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:historyTop];
        
        NSLayoutConstraint *historyWidth = [NSLayoutConstraint constraintWithItem:_showAllBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self addConstraint:historyWidth];
        
        NSLayoutConstraint *historyRight = [NSLayoutConstraint constraintWithItem:_showAllBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.arrowImageView2 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:historyRight];
        
        NSLayoutConstraint *historyHeight = [NSLayoutConstraint constraintWithItem:_showAllBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self addConstraint:historyHeight];
    }
    return _showAllBtn;
}

- (UIImageView *)arrowImageView2
{
    if (!_arrowImageView2) {
        _arrowImageView2 = [[UIImageView alloc] init];
        _arrowImageView2.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_arrowImageView2];
        // label
        NSLayoutConstraint *historyTop = [NSLayoutConstraint constraintWithItem:_arrowImageView2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.rankDetailView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:17];
        [self addConstraint:historyTop];
        
        NSLayoutConstraint *historyWidth = [NSLayoutConstraint constraintWithItem:_arrowImageView2 attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:12.5];
        [self addConstraint:historyWidth];
        
        NSLayoutConstraint *historyRight = [NSLayoutConstraint constraintWithItem:_arrowImageView2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:historyRight];
        
        NSLayoutConstraint *historyHeight = [NSLayoutConstraint constraintWithItem:_arrowImageView2 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:10.5];
        [self addConstraint:historyHeight];
    }
    return _arrowImageView2;
}



@end
