//
//  SOPViewController.m
//  redstar
//
//  Created by admin on 15/12/25.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "SOPViewController.h"
#import "GroupTabBar.h"
#import "GroupItems.h"
#import "SOPTableView.h"
#import "HttpClient.h"
#import "AttachmentTableViewCell.h"
#import "AttachmentModel.h"

#import <MBProgressHUD.h>

#define kAttachmentTableCell @"sopAttachmentCell"

#define SELECTED_VIEW_CONTROLLER_TAG 39998

@interface SOPViewController () <UIAlertViewDelegate,GroupTabBarDelegate, SOPTableViewDelegate, UITableViewDelegate, UITableViewDataSource, UIDocumentInteractionControllerDelegate>
@property (nonatomic, strong) GroupTabBar *groupTabBar;

@property (nonatomic, strong) NSArray *titleArray;
@property (nonatomic, strong) NSArray *allTopicArray;
@property (nonatomic, strong) NSArray *allTableViewArray;

@property (nonatomic, strong) NSArray *titleArray0;
@property (nonatomic, strong) NSArray *titleArray1;
@property (nonatomic, strong) NSArray *titleArray2;
@property (nonatomic, strong) NSArray *titleArray3;
@property (nonatomic, strong) NSArray *titleArray4;
@property (nonatomic, strong) NSArray *titleArray5;
@property (nonatomic, strong) NSArray *titleArray6;
@property (nonatomic, strong) NSArray *titleArray7;
@property (nonatomic, strong) NSArray *titleArray8;
@property (nonatomic, strong) NSArray *titleArray9;

@property (nonatomic, assign) NSInteger row;

@property (nonatomic, strong) UIButton *resetBtn;
@property (nonatomic, strong) UIButton *queryBtn;

@property (nonatomic, strong) UIView *bgView;
@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) NSMutableArray *attachmentArray;

@property (nonatomic, strong) NSMutableDictionary *sopDict;

@end

@implementation SOPViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    [self setupData];
    
    self.attachmentArray = [NSMutableArray array];
    
    
    [self setupNav];
    
    [self setGroupBar];
    
    [self.resetBtn addTarget:self action:@selector(resetClick:) forControlEvents:UIControlEventTouchUpInside];
    [self.queryBtn addTarget:self action:@selector(queryClick:) forControlEvents:UIControlEventTouchUpInside];
}

- (void)setupData
{
    self.titleArray = [NSArray arrayWithObjects:@"手册使用说明",@"服务口碑实施管理规定",@"质量管理",@"价格管理",@"现场服务",@"售后服务", @"环境管理",@"现场管理",@"400呼叫管理",@"单品管理",nil];
    self.titleArray0 = [NSArray arrayWithObjects:@"手册使用说明",nil];
    self.titleArray1 = [NSArray arrayWithObjects:@"服务口碑实施管理规定",nil];
    
    self.titleArray2 = [NSArray arrayWithObjects:@"商品环保、质量检测管理规定",@"商品资质管理规定",@"商场三年质保管理规定",@"绿色展陈管理规定", nil];
    self.titleArray3 = [NSArray arrayWithObjects:@"商品标价签管理规定",@"商品调价管理规定",@"商场全国大促活动执行管理规定",@"商户促销活动管理规定",@"“全场最低七折”管理规定", nil];
    self.titleArray4 = [NSArray arrayWithObjects:@"商场现场基本服务基本规范",@"便民服务管理规定",@"营业员管理规定",@"播音管理规定",@"商场实施管理者“顾客之声VOC”管理规定", @"30天无理由退货管理规定",@"15分钟退单管理规定",@"商场全员顾客服务规范管理规定",@"设计免费咨询管理规定",nil];
    self.titleArray5 = [NSArray arrayWithObjects:@"商场客诉处理管理规定",@"先行赔付管理规定",@"商品质量保证金管理规定",@"送货跟单回访管理规定", nil];
    self.titleArray6 = [NSArray arrayWithObjects:@"商场基础环境管理规范",@"口碑商场环境管理规范", @"商场停车场管理规定",@"商场洗手间管理规范",@"商场综合物料管理规定",nil];
    self.titleArray7 = [NSArray arrayWithObjects:@"楼层日常巡场管理规定",@"商户进/出货管理规定",@"商户进场管理规定",@"商户撤场管理规定",@"红星美凯龙商户信用等级评定办法", nil];
    self.titleArray8 = [NSArray arrayWithObjects:@"呼叫中心商场虚拟座席远程管理规定", nil];
    self.titleArray9 = [NSArray arrayWithObjects:@"商品信息管理规定", nil];
    
    self.allTopicArray = [NSMutableArray arrayWithObjects:_titleArray0, _titleArray1,_titleArray2,_titleArray3,_titleArray4,_titleArray5,_titleArray6,_titleArray7,_titleArray8,_titleArray9,nil];
    
    self.sopDict = [NSMutableDictionary dictionary];
    [_sopDict setObject:@"FFKB-SYSM" forKey:@"手册使用说明手册使用说明"];
    
    [_sopDict setObject:@"FFKB-SSGL-01" forKey:@"服务口碑实施管理规定服务口碑实施管理规定"];
    
    [_sopDict setObject:@"FFKB-ZLGL-01" forKey:@"质量管理商品环保、质量检测管理规定"];
    [_sopDict setObject:@"FFKB-ZLGL-02" forKey:@"质量管理商品资质管理规定"];
    [_sopDict setObject:@"FFKB-ZLGL-03" forKey:@"质量管理商场三年质保管理规定"];
    [_sopDict setObject:@"FFKB-ZLGL-04" forKey:@"质量管理绿色展陈管理规定"];
    
    [_sopDict setObject:@"FFKB-JGGL-01" forKey:@"价格管理商品标价签管理规定"];
    [_sopDict setObject:@"FFKB-JGGL-02" forKey:@"价格管理商品调价管理规定"];
    [_sopDict setObject:@"FFKB-JGGL-03" forKey:@"价格管理商场全国大促活动执行管理规定"];
    [_sopDict setObject:@"FFKB-JGGL-04" forKey:@"价格管理商户促销活动管理规定"];
    [_sopDict setObject:@"FFKB-JGGL-05" forKey:@"价格管理“全场最低七折”管理规定"];
    
    [_sopDict setObject:@"FFKB-XCFW-01" forKey:@"现场服务商场现场基本服务基本规范"];
    [_sopDict setObject:@"FFKB-XCFW-02" forKey:@"现场服务便民服务管理规定"];
    [_sopDict setObject:@"FFKB-XCFW-03" forKey:@"现场服务营业员管理规定"];
    [_sopDict setObject:@"FFKB-XCFW-04" forKey:@"现场服务播音管理规定"];
    [_sopDict setObject:@"FFKB-XCFW-05" forKey:@"现场服务商场实施管理者“顾客之声VOC”管理规定"];
    [_sopDict setObject:@"FFKB-XCFW-06" forKey:@"现场服务30天无理由退货管理规定"];
    [_sopDict setObject:@"FFKB-XCFW-07" forKey:@"现场服务15分钟退单管理规定"];
    [_sopDict setObject:@"FFKB-XCFW-08" forKey:@"现场服务商场全员顾客服务规范管理规定"];
    [_sopDict setObject:@"FFKB-XCFW-09" forKey:@"现场服务设计免费咨询管理规定"];
    
    [_sopDict setObject:@"FFKB-SHFW-01" forKey:@"售后服务商场客诉处理管理规定"];
    [_sopDict setObject:@"FFKB-SHFW-02" forKey:@"售后服务先行赔付管理规定"];
    [_sopDict setObject:@"FFKB-SHFW-03" forKey:@"售后服务商品质量保证金管理规定"];
    [_sopDict setObject:@"FFKB-SHFW-04" forKey:@"售后服务送货跟单回访管理规定"];
    
    [_sopDict setObject:@"FFKB-HJGL-01" forKey:@"环境管理商场基础环境管理规范"];
    [_sopDict setObject:@"FFKB-HJGL-02" forKey:@"环境管理口碑商场环境管理规范"];
    [_sopDict setObject:@"FFKB-HJGL-03" forKey:@"环境管理商场停车场管理规定"];
    [_sopDict setObject:@"FFKB-HJGL-04" forKey:@"环境管理商场洗手间管理规范"];
    [_sopDict setObject:@"FFKB-HJGL-05" forKey:@"环境管理商场综合物料管理规定"];
    
    [_sopDict setObject:@"FFKB-XCGL-01" forKey:@"现场管理楼层日常巡场管理规定"];
    [_sopDict setObject:@"FFKB-XCGL-02" forKey:@"现场管理商户进/出货管理规定"];
    [_sopDict setObject:@"FFKB-XCGL-03" forKey:@"现场管理商户进场管理规定"];
    [_sopDict setObject:@"FFKB-XCGL-04" forKey:@"现场管理商户撤场管理规定"];
    [_sopDict setObject:@"FFKB-XCGL-05" forKey:@"现场管理红星美凯龙商户信用等级评定办法"];
    
    [_sopDict setObject:@"FFKB-HJGL-01" forKey:@"400呼叫管理呼叫中心商场虚拟座席远程管理规定"];
    [_sopDict setObject:@"FFKB-DPGL-01" forKey:@"单品管理商品信息管理规定"];


}

- (void)resetClick:(UIButton *)sender
{
    NSInteger selectedIndex = 0;
    NSIndexPath *selectedIndexPath = [NSIndexPath indexPathForRow:selectedIndex inSection:0];
    for (SOPTableView *sop in _allTableViewArray) {
        [sop selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    }
    _row = 0;
}

- (void)queryClick:(UIButton *)sender
{
    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kGetAttachmentsURL];
    HttpClient *http = [[HttpClient alloc] initWithUrl:url];
    
    NSMutableArray *titleArray = _allTopicArray[_groupTabBar.selectNumber];
    NSString *encode = [_sopDict objectForKey:[NSString stringWithFormat:@"%@%@", _titleArray[_groupTabBar.selectNumber],titleArray[_row]]];
    NSDictionary *parameters = @{@"type":@"sop",
                               @"encode":encode
                                 };
    [http getAttachmentsWithParameters:parameters completion:^(id response, NSError *error) {
        NSLog(@"7.1 口碑标注附件列表 = %@, error = %@", response, error);
        NSArray *dataArray = response[@"data"];
        
        for (NSDictionary *attaDict in dataArray) {
            AttachmentModel *atta = [[AttachmentModel alloc] init];
            [atta setValuesForKeysWithDictionary:attaDict];
            [_attachmentArray addObject:atta];
        }
        
        if (_attachmentArray.count == 0) {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"暂无附件！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
            [alert show];
            return;
        }
        
        CGFloat tableH = _attachmentArray.count * 45;
        
        if (!_bgView) {
            _bgView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, kScreenHeight)];
            UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeRedView)];
            [_bgView addGestureRecognizer:tapGR];
        }
        CGRect toFrame = CGRectMake(0, 0, kScreenWidth - 50, tableH + 40);

        if (!_tableView) {
            _tableView = [[UITableView alloc] initWithFrame:toFrame style:UITableViewStyleGrouped];
            _tableView.backgroundColor = [UIColor whiteColor];
        }
        _tableView.delegate = self;
        _tableView.dataSource = self;
        [self.view addSubview:_bgView];
        [self.view insertSubview:_tableView aboveSubview:_bgView];
        
        _bgView.alpha = 0;
        _bgView.backgroundColor = [UIColor blackColor];
        
        _tableView.alpha = 0.0;
        _tableView.center = CGPointMake( _bgView.center.x, _bgView.center.y - 74);
        [UIView animateWithDuration:0.3 animations:^{
            _bgView.alpha = 0.6;
            _tableView.alpha = 1.0;
        }];
        
        
    }];
    _row = 0;
}

- (void)closeRedView
{
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _tableView.alpha = 0.0;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_tableView removeFromSuperview];
    }];
}

- (void)showFile:(UIButton *)sender
{
    NSInteger row = sender.tag - 998473;
    AttachmentModel *atta = _attachmentArray[row];
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *path = paths.lastObject;
    NSString *url = [NSString stringWithFormat:@"%@/%@", path, atta.fileName];
    
    NSFileManager *fileManager = [NSFileManager defaultManager];
    if ([fileManager fileExistsAtPath:url]) {
        
        UIDocumentInteractionController *docController = [UIDocumentInteractionController interactionControllerWithURL:[NSURL fileURLWithPath:url]];//为该对象初始化一个加载路径
        docController.delegate = self;//设置代理
        [docController presentPreviewAnimated:YES];
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"文件不存在，请先下载在查看！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
}

- (UIViewController *)documentInteractionControllerViewControllerForPreview:(UIDocumentInteractionController *)controller
{
    return self;
}

- (void)downloadFile:(UIButton *)sender
{
    NSInteger row = sender.tag - 998473;
    AttachmentModel *atta = _attachmentArray[row];
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *path = paths.lastObject;
    
    NSString *fileName = [NSString stringWithFormat:@"%@", atta.fileName];
    [self downloadFileURL:[NSString stringWithFormat:@"%@%@", kRedStarURL, atta.fileUrl] savePath:path fileName:fileName];
}

- (void)downloadFileURL:(NSString *)aUrl savePath:(NSString *)aSavePath fileName:(NSString *)aFileName
{
    NSFileManager *fileManager = [NSFileManager defaultManager];
    
    //检查本地文件是否已存在
    NSString *fileName = [NSString stringWithFormat:@"%@/%@", aSavePath, aFileName];
    //检查附件是否存在
    if ([fileManager fileExistsAtPath:fileName]) {
        NSLog(@"存在了");
    }else{
        NSLog(@"不存在");
        
        //创建附件存储目录
        if (![fileManager fileExistsAtPath:aSavePath]) {
            [fileManager createDirectoryAtPath:aSavePath withIntermediateDirectories:YES attributes:nil error:nil];
        }
        //下载附件
        NSLog(@"aaaurl === %@", aUrl);
        aUrl = [aUrl stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
        NSLog(@"aaaurl === %@", aUrl);

        NSURL *url = [[NSURL alloc] initWithString:aUrl];
        
        
        NSURLRequest *request = [NSURLRequest requestWithURL:url];
        
        AFHTTPRequestOperation *operation = [[AFHTTPRequestOperation alloc] initWithRequest:request];
        operation.inputStream   = [NSInputStream inputStreamWithURL:url];
        operation.outputStream  = [NSOutputStream outputStreamToFileAtPath:fileName append:NO];
        
        
        //下载进度控制
        [operation setDownloadProgressBlock:^(NSUInteger bytesRead, long long totalBytesRead, long long totalBytesExpectedToRead) {
            // 设置进度条进度
            MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view animated:YES];
            hud.mode = MBProgressHUDModeAnnularDeterminate;
            
//            if (expectedContentLength > 0 && progressContentLength <= expectedContentLength)
//                progress = (CGFloat) progressContentLength / expectedContentLength;
//            else
//                progress = (progressContentLength % 1000000l) / 1000000.0f;
            
            
            CGFloat precent = totalBytesRead / totalBytesExpectedToRead;
            hud.labelText = [NSString stringWithFormat:@"%f", precent];
            NSLog(@"prrrrrrrrrrrrrr ==== %f", precent);
            
        }];
        //已完成下载
        [operation setCompletionBlockWithSuccess:^(AFHTTPRequestOperation *operation, id responseObject) {
            [self closeRedView];
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"下载成功！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
            alert.tag = 66690;
            [alert show];
            [self.tableView reloadData];

        } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
            [self closeRedView];
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"下载失败！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
            [alert show];
            [self.tableView reloadData];

        }];
        
        
        
        [operation start];
    }
}


- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"营运标准"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
}

- (void)setGroupBar
{
    self.groupTabBar = [[GroupTabBar alloc] initWithFrame:CGRectMake(0, 0, 120, kScreenHeight - 64 - 60)];
    _groupTabBar.delegate = self;
    [self.view addSubview:_groupTabBar];
    
    NSInteger selectedIndex = 0;
    NSIndexPath *selectedIndexPath = [NSIndexPath indexPathForRow:selectedIndex inSection:0];
    
    SOPTableView *tableView0 = [[SOPTableView alloc] initWithTitleArray:_titleArray0];
    tableView0.sop_delegate = self;
    GroupItems *tableItem0 = [[GroupItems alloc] initWithTitle:_titleArray[0] view:tableView0];
    
    SOPTableView *tableView1 = [[SOPTableView alloc] initWithTitleArray:_titleArray1];
    tableView1.sop_delegate = self;
    GroupItems *tableItem1 = [[GroupItems alloc] initWithTitle:_titleArray[1] view:tableView1];
    
    SOPTableView *tableView2 = [[SOPTableView alloc] initWithTitleArray:_titleArray2];
    tableView2.sop_delegate = self;
    GroupItems *tableItem2 = [[GroupItems alloc] initWithTitle:_titleArray[2] view:tableView2];
    
    SOPTableView *tableView3 = [[SOPTableView alloc] initWithTitleArray:_titleArray3];
    tableView3.sop_delegate = self;
    GroupItems *tableItem3 = [[GroupItems alloc] initWithTitle:_titleArray[3] view:tableView3];
    
    SOPTableView *tableView4 = [[SOPTableView alloc] initWithTitleArray:_titleArray4];
    tableView4.sop_delegate = self;
    GroupItems *tableItem4 = [[GroupItems alloc] initWithTitle:_titleArray[4] view:tableView4];
    
    SOPTableView *tableView5 = [[SOPTableView alloc] initWithTitleArray:_titleArray5];
    tableView5.sop_delegate = self;
    GroupItems *tableItem5 = [[GroupItems alloc] initWithTitle:_titleArray[5] view:tableView5];
    
    SOPTableView *tableView6 = [[SOPTableView alloc] initWithTitleArray:_titleArray6];
    tableView6.sop_delegate = self;
    GroupItems *tableItem6 = [[GroupItems alloc] initWithTitle:_titleArray[6] view:tableView6];
    
    SOPTableView *tableView7 = [[SOPTableView alloc] initWithTitleArray:_titleArray7];
    tableView7.sop_delegate = self;
    GroupItems *tableItem7 = [[GroupItems alloc] initWithTitle:_titleArray[7] view:tableView7];
    
    SOPTableView *tableView8 = [[SOPTableView alloc] initWithTitleArray:_titleArray8];
    tableView8.sop_delegate = self;
    GroupItems *tableItem8 = [[GroupItems alloc] initWithTitle:_titleArray[8] view:tableView8];
    
    SOPTableView *tableView9 = [[SOPTableView alloc] initWithTitleArray:_titleArray9];
    tableView9.sop_delegate = self;
    GroupItems *tableItem9 = [[GroupItems alloc] initWithTitle:_titleArray[9] view:tableView9];
    
    [tableView0 selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [tableView1 selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [tableView2 selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [tableView3 selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [tableView4 selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [tableView5 selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [tableView6 selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [tableView7 selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [tableView8 selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    [tableView9 selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    
    self.allTableViewArray = [NSMutableArray arrayWithObjects:tableView0,tableView1, tableView2,tableView3,tableView4,tableView5,tableView6,tableView7,tableView8,tableView9,nil];

    [self.view insertSubview:tableView0 belowSubview:_groupTabBar];
    [self.view insertSubview:tableView1 belowSubview:_groupTabBar];
    [self.view insertSubview:tableView2 belowSubview:_groupTabBar];
    [self.view insertSubview:tableView3 belowSubview:_groupTabBar];
    [self.view insertSubview:tableView4 belowSubview:_groupTabBar];
    [self.view insertSubview:tableView5 belowSubview:_groupTabBar];
    [self.view insertSubview:tableView6 belowSubview:_groupTabBar];
    [self.view insertSubview:tableView7 belowSubview:_groupTabBar];
    [self.view insertSubview:tableView8 belowSubview:_groupTabBar];
    [self.view insertSubview:tableView9 belowSubview:_groupTabBar];

    
    _groupTabBar.items = @[ tableItem0,tableItem1, tableItem2, tableItem3, tableItem4, tableItem5, tableItem6, tableItem7, tableItem8, tableItem9];
    [_groupTabBar showIndex:0];


}

-(void)doBack:(id)sender
{
    
//    if ([[self.navigationController.viewControllers objectAtIndex:0] isKindOfClass:[StandardViewController class]]) {
//        StandardViewController *masterVC = (StandardViewController *)[self.navigationController.viewControllers objectAtIndex:0];
//        [self.navigationController popToViewController:masterVC animated:YES];
//    }
//    [self.navigationController dismissViewControllerAnimated:YES completion:nil];
    [self.navigationController popViewControllerAnimated:YES];
}

#pragma mark - UIAlertViewDelegate
-(void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (alertView.tag == 66690) {
        if (buttonIndex == 0) {
            [self.tableView reloadData];
        }
    }
}

#pragma mark - UITableView Delegate/DataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _attachmentArray.count;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    AttachmentTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kAttachmentTableCell];
    if (!cell) {
        cell = [[AttachmentTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kAttachmentTableCell];
    }
    AttachmentModel *atta = _attachmentArray[indexPath.row];
    NSString *name = atta.fileName;
    [cell.nameBtn setTitle:name forState:UIControlStateNormal];
    cell.nameBtn.titleLabel.numberOfLines = 0;
    
    [cell.nameBtn addTarget:self action:@selector(showFile:) forControlEvents:UIControlEventTouchUpInside];
    [cell.downloadBtn addTarget:self action:@selector(downloadFile:) forControlEvents:UIControlEventTouchUpInside];
    cell.downloadBtn.tag = 998473 + indexPath.row;
    cell.nameBtn.tag = 998473 + indexPath.row;
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *path = paths.lastObject;
    NSString *url = [NSString stringWithFormat:@"%@/%@", path, atta.fileName];
    NSFileManager *fileManager = [NSFileManager defaultManager];
    if ([fileManager fileExistsAtPath:url]) {
        cell.downloadBtn.selected = YES;
        cell.downloadBtn.backgroundColor = [UIColor grayColor];
    } else {
        cell.downloadBtn.selected = NO;
        cell.downloadBtn.backgroundColor = [UIColor colorWithRed:47 / 255.0 green:209/ 255.0 blue:92 / 255.0 alpha:1.0];
        
    }
    
    return cell;
    
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView *view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 40)];
    UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(15, 0, kScreenWidth - 20, 40)];
    label.text = @"附件";
    label.textColor = kNavigationBarColor;
    label.font = [UIFont systemFontOfSize:14.0];
    [view addSubview:label];
    return view;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 40;
}

#pragma mark - SOPTableViewDelegate
- (void)selectRowWithDetailRow:(NSInteger)row
{
    _row = row;
}

#pragma mark - GroupTabBarDelegate
- (void)switchView:(UIView *)view
{
    UIView *currentView = [self.view viewWithTag:SELECTED_VIEW_CONTROLLER_TAG];
    [currentView removeFromSuperview];
    currentView = nil;
    
    view.frame = CGRectMake(self.groupTabBar.frame.size.width,0,kScreenWidth - self.groupTabBar.frame.size.width, self.groupTabBar.size.height);
    
    view.tag = SELECTED_VIEW_CONTROLLER_TAG;
    
    [self.view insertSubview:view belowSubview:_groupTabBar];
    
}

#pragma mark - lazy loading
- (UIButton *)resetBtn
{
    if (!_resetBtn) {
        _resetBtn = [[UIButton alloc] init];
        _resetBtn.backgroundColor = [UIColor grayColor];
        _resetBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_resetBtn setTitle:@"重置" forState:UIControlStateNormal];
        _resetBtn.layer.cornerRadius = 4.0;
        [self.view addSubview:_resetBtn];
        
        NSLayoutConstraint *lineViewHeight = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self.view addConstraint:lineViewHeight];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-10];
        [self.view addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewBottom = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-7.5];
        [self.view addConstraint:lineViewBottom];
        
        NSLayoutConstraint *lineViewLeft = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.view addConstraint:lineViewLeft];
    }
    return _resetBtn;
}

- (UIButton *)queryBtn
{
    if (!_queryBtn) {
        _queryBtn = [[UIButton alloc] init];
        _queryBtn.backgroundColor = kNavigationBarColor;
        _queryBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_queryBtn setTitle:@"查看附件" forState:UIControlStateNormal];
        _queryBtn.layer.cornerRadius = 4.0;
        [self.view addSubview:_queryBtn];
        
        NSLayoutConstraint *lineViewHeight = [NSLayoutConstraint constraintWithItem:_queryBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [self.view addConstraint:lineViewHeight];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_queryBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.view addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewBottom = [NSLayoutConstraint constraintWithItem:_queryBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-7.5];
        [self.view addConstraint:lineViewBottom];
        
        NSLayoutConstraint *lineViewLeft = [NSLayoutConstraint constraintWithItem:_queryBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:10];
        [self.view addConstraint:lineViewLeft];
    }
    return _queryBtn;
}


@end
